/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.exception.LicenseExpiredException;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.OAuthService;
import com.kaanha.reports.service.TableauService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ViewServletUtils {
    static Logger logger = Logger.getLogger(ViewServletUtils.class);

    public static void processRequest(HttpServletRequest request, HttpServletResponse response, UserPersistenceService userService, ViewRenderer viewRenderer, ReportPersistenceService reportService, AdminPersistenceService adminService) throws ResourceNotFoundException, ParseErrorException, Exception {
        boolean valid;
        OAuthParams oAuthParams;
        HashMap out;
        HashMap context = Maps.newHashMap();
        AioUser loggedInUser = (AioUser)request.getAttribute("loggedInUser");
        String action = request.getPathInfo();
        if ("/saved".equals(action)) {
            ArrayList savedReports = Lists.newArrayList((Object[])userService.getSavedReports(loggedInUser));
            context.put("savedReports", savedReports);
            context.put("sharedReports", userService.getSharedReports(loggedInUser));
            context.put("scheduledReports", reportService.getScheduledReports(savedReports));
        }
        if ("/oauth".equals(action)) {
            String redirectUrlPrefix;
            OAuthParams oAuthParams2 = OAuthParams.build(viewRenderer.getPlatformType(), request, loggedInUser, action);
            userService.createAccessToken(oAuthParams2, request.getParameter("oauth_token"), request.getParameter("oauth_verifier"));
            String _action = request.getParameter("action");
            if (PlatformTypeEnum.HOSTED.equals((Object)viewRenderer.getPlatformType())) {
                redirectUrlPrefix = "";
                redirectUrlPrefix = "rest".equals(_action) ? ("com.kaanha.reports".equals(oAuthParams2.getAddOnKey()) ? oAuthParams2.getBaseUrl() + "/plugins/servlet/aio/view/rest" : oAuthParams2.getBaseUrl() + "/plugins/servlet/aio-ts/view/rest") : ("com.kaanha.reports".equals(oAuthParams2.getAddOnKey()) ? oAuthParams2.getBaseUrl() + "/plugins/servlet/aio/view/saved" : ("com.kaanha.timesheets".equals(oAuthParams2.getAddOnKey()) ? oAuthParams2.getBaseUrl() + "/plugins/servlet/aio-ts/view/saved" : oAuthParams2.getBaseUrl() + "/plugins/servlet/aio-tb/view/tableau"));
                context.put("redirectUrl", redirectUrlPrefix);
            } else {
                redirectUrlPrefix = oAuthParams2.getBaseUrl() + "/plugins/servlet/ac/" + oAuthParams2.getAddOnKey();
                if ("com.kaanha.jira.tableau".equals(oAuthParams2.getAddOnKey())) {
                    context.put("redirectUrl", redirectUrlPrefix + "/jira-tableau-create");
                } else if ("rest".equals(_action)) {
                    context.put("redirectUrl", redirectUrlPrefix + "/jira-reports-rest");
                } else {
                    context.put("redirectUrl", redirectUrlPrefix + "/jira-reports-open");
                }
            }
        }
        String tableauKey = request.getParameter("link");
        if ("/unsubscribe".equals(action)) {
            String reportName = userService.unsubscribe(tableauKey);
            context.put("reportName", reportName);
        }
        if ("/dashboard".equals(action) || "/dashboard-hosted".equals(action)) {
            ArrayList savedReports = Lists.newArrayList((Object[])userService.getSavedReports(loggedInUser));
            savedReports.addAll(userService.getSharedReports(loggedInUser));
            context.put("savedReports", savedReports);
        }
        if ("/sample".equals(action)) {
            reportService.populateCannedReports(loggedInUser);
            ArrayList cannedReports = Lists.newArrayList(reportService.getCannedReports());
            ArrayList cannedReportCategories = Lists.newArrayList(ReportPersistenceService.getCannedReportCategories());
            context.put("cannedReports", cannedReports);
            context.put("cannedReportCategories", cannedReportCategories);
        }
        if ("/tableau".equals(action)) {
            out = Maps.newHashMap();
            oAuthParams = OAuthParams.build(viewRenderer.getPlatformType(), request, loggedInUser, action);
            valid = OAuthService.getInstance().initOAuth(oAuthParams, out);
            context.put("oAuthValid", valid);
            context.put("tableauInfo", out);
            context.put("tableauRequest", true);
            if (valid) {
                String contextPath = "/aio";
                if (PlatformTypeEnum.HOSTED.equals((Object)viewRenderer.getPlatformType())) {
                    contextPath = "/plugins/servlet/aio-tb";
                }
                String connectorUrl = new StringBuffer(HttpUtils.getBaseUrl(request)).append(contextPath + "/public/tableauconnect?link=").append(userService.createOrFindTableauConnectorKey(loggedInUser)).toString();
                context.put("connectorUrl", connectorUrl);
            }
        }
        if ("/rest".equals(action)) {
            out = Maps.newHashMap();
            oAuthParams = OAuthParams.build(viewRenderer.getPlatformType(), request, loggedInUser, action);
            valid = OAuthService.getInstance().initOAuth(oAuthParams, out);
            context.put("oAuthValid", valid);
            context.put("restInfo", out);
            context.put("restRequest", true);
            if (valid) {
                context.put("respApiToken", userService.createOrFindRestApiToken(loggedInUser));
            }
        }
        if ("/tableauconnect".equals(action)) {
            loggedInUser = new TableauService().fetchUser(tableauKey);
            if (PlatformTypeEnum.CLOUD.equals((Object)viewRenderer.getPlatformType())) {
                AioTenant tenant = loggedInUser.getTenant();
                String sen = tenant.getServiceEntitlementNumber();
                boolean status = tenant.getLicenseActive();
                logger.debug((Object)(tenant.getAddOnKey() + ", " + tableauKey + ", " + sen + ", " + status));
                if (!status && (tenant.getTrialEnd() == null || tenant.getTrialEnd().before(new Date()))) {
                    throw new LicenseExpiredException(tenant.getAddOnKey());
                }
            }
            context.put("loggedInUser", loggedInUser);
        }
        if ("/teams".equals(action)) {
            context.put("myTeams", Lists.newArrayList((Object[])loggedInUser.getTeams()));
            context.put("sharedTeams", Lists.newArrayList((Object[])loggedInUser.getSharedTeams()));
        }
        if ("/admin_preferences".equals(action)) {
            context.put("adminPreferences", adminService.getAddOnPreferences(loggedInUser));
        }
        if ("/my_preferences".equals(action)) {
            context.put("myPreferences", userService.getMyPreferences(loggedInUser));
        }
        viewRenderer.render(request, response, context);
    }

    public static VelocityEngine initVelocity() throws Exception {
        VelocityEngine velocityEngine = new VelocityEngine();
        Properties p2 = new Properties();
        p2.setProperty("resource.loader", "classpath");
        p2.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        p2.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        velocityEngine.init(p2);
        return velocityEngine;
    }
}

