/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kaanha.reports.servlet.ContextBuilder;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewServletUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ViewRenderer {
    private VelocityEngine velocityEngine;
    private TemplateRenderer templateRenderer;
    private PlatformTypeEnum platformType;

    public ViewRenderer(PlatformTypeEnum platformType, TemplateRenderer templateRenderer) throws Exception {
        this.templateRenderer = templateRenderer;
        this.platformType = platformType;
        if (PlatformTypeEnum.CLOUD.equals((Object)platformType)) {
            this.velocityEngine = ViewServletUtils.initVelocity();
        }
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws ResourceNotFoundException, ParseErrorException, Exception {
        String viewName = request.getPathInfo();
        this.renderView(request, response, viewName, context);
    }

    public void renderView(HttpServletRequest request, HttpServletResponse response, String viewName, Map<String, Object> context) throws Exception, IOException {
        this.renderView(request, response, viewName, context, null);
    }

    public void renderView(HttpServletRequest request, HttpServletResponse response, String viewName, Map<String, Object> context, String message) throws ResourceNotFoundException, ParseErrorException, Exception {
        Map<String, Object> _context = ContextBuilder.buildContext(request, this.platformType);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            _context.put("message", message);
        }
        if (context != null) {
            _context.putAll(context);
        }
        String templatePath = "/views" + viewName + ".vm";
        response.setContentType("text/html;charset=UTF-8");
        switch (this.platformType) {
            case CLOUD: {
                Template t2 = this.velocityEngine.getTemplate(templatePath);
                VelocityContext vc = ViewRenderer.buildVelocityContext(_context);
                vc.put("serverTime", (Object)new Date().getTime());
                StringWriter writer = new StringWriter();
                t2.merge((Context)vc, (Writer)writer);
                response.getWriter().print(writer.toString());
                break;
            }
            case HOSTED: {
                _context.put("serverTime", new Date().getTime());
                this.templateRenderer.render(templatePath, _context, (Writer)response.getWriter());
            }
        }
    }

    private static VelocityContext buildVelocityContext(Map<String, Object> context) {
        VelocityContext vc = new VelocityContext();
        for (String key : context.keySet()) {
            vc.put(key, context.get(key));
        }
        return vc;
    }

    public PlatformTypeEnum getPlatformType() {
        return this.platformType;
    }
}

