/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.kaanha.reports.connect.AtlassianConnectContextParams;
import com.kaanha.reports.connect.ConnectUtils;
import com.kaanha.reports.connect.JWT;
import com.kaanha.reports.connect.JWTHandler;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestPopulationFilterCloud
implements Filter {
    private JWTHandler jwtHandler = new JWTHandler();
    private TenantPersistenceService tenantService;
    private ViewRenderer viewRenderer;
    private UserPersistenceService userService;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.tenantService = new TenantPersistenceService();
            this.userService = new UserPersistenceService();
            this.viewRenderer = new ViewRenderer(PlatformTypeEnum.CLOUD, null);
        }
        catch (Exception e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            AtlassianConnectContextParams contextParams = ConnectUtils.extractAtlassianParamsFromRequest((HttpServletRequest)request);
            JWT jwt = this.jwtHandler.toObject(contextParams.getJwt());
            AioTenant tenant = this.tenantService.findByClientKeyAndAddOnKey(jwt.getIss(), contextParams.getAok() + "");
            AioUser loggedInUser = this.userService.findByUserkeyAndTenant(jwt.getUser().getUserKey(), tenant);
            request.setAttribute("loggedInUser", (Object)loggedInUser);
            chain.doFilter(request, response);
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void destroy() {
    }
}

