/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.servlet.ViewRenderer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PublicAjaxExceptionFilterHosted
implements Filter {
    static Logger logger = Logger.getLogger(PublicAjaxExceptionFilterHosted.class);
    private ViewRenderer viewRenderer;
    private UserManager userManager;
    private UserPersistenceService userService;

    public PublicAjaxExceptionFilterHosted(UserManager userManager, ActiveObjects ao2) throws Exception {
        System.out.println(userManager);
        PersistenceService.createHostedInstance(ao2);
        this.userManager = userManager;
        this.userService = new UserPersistenceService();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            UserProfile user = this.userManager.getRemoteUser();
            if (user != null) {
                request.setAttribute("loggedInUser", (Object)this.userService.findByUserkey(user.getUserKey().getStringValue()));
            } else {
                request.setAttribute("loggedInUser", null);
            }
            chain.doFilter(request, response);
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

