/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.CloudToServerMigrationService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import com.kaanha.reports.servlet.ViewServletUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HostedServlet
extends HttpServlet {
    private static final long serialVersionUID = 2421495792157233074L;
    private final PlatformTypeEnum platformType = PlatformTypeEnum.HOSTED;
    private ViewRenderer viewRenderer;
    private UserPersistenceService userService;
    private ReportPersistenceService reportService;
    private AdminPersistenceService adminService;
    private String addOnKey;

    public HostedServlet(TemplateRenderer templateRenderer, ActiveObjects ao2) throws Exception {
        this.viewRenderer = new ViewRenderer(this.platformType, templateRenderer);
        PersistenceService.createHostedInstance(ao2);
        this.userService = new UserPersistenceService();
        this.reportService = new ReportPersistenceService();
        this.adminService = new AdminPersistenceService();
    }

    public void init(ServletConfig config) throws ServletException {
        this.addOnKey = config.getInitParameter("addOnKey");
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setAttribute("addOnKey", (Object)this.addOnKey);
            ViewServletUtils.processRequest(request, response, this.userService, this.viewRenderer, this.reportService, this.adminService);
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String action = request.getPathInfo();
            if ("/migrate".equals(action)) {
                CloudToServerMigrationService s2 = new CloudToServerMigrationService();
                s2.migrate(request.getParameter("tenantReports"));
            }
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, request, response);
        }
    }
}

