/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioPermissions;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import java.util.Map;

public class GroupCanCreatePermission
implements Condition {
    private AdminPersistenceService pps;
    private UserPersistenceService ups;
    private UserManager userManager;

    public GroupCanCreatePermission(UserManager userManager, ActiveObjects ao2) throws Exception {
        PersistenceService.createHostedInstance(ao2);
        this.pps = new AdminPersistenceService();
        this.ups = new UserPersistenceService();
        this.userManager = userManager;
    }

    public void init(Map<String, String> arg0) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        try {
            if (this.userManager.getRemoteUser() == null) {
                return false;
            }
            UserKey userKey = this.userManager.getRemoteUser().getUserKey();
            AioPermissions p2 = this.pps.getAddOnPermissions(this.ups.findByUserkey(userKey.getStringValue()));
            if (p2 == null) {
                return true;
            }
            JsonNode createGroups = JsonUtils.stringToJsonNode(p2.getCreateGroups());
            if (createGroups == null) {
                return true;
            }
            for (JsonNode grp : createGroups) {
                if (!this.userManager.isUserInGroup(userKey, grp.asText())) continue;
                return true;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return false;
    }
}

