/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.Constants;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ContextBuilder {
    public static Map<String, Object> buildContext(HttpServletRequest request, PlatformTypeEnum platformType) throws JsonProcessingException {
        HashMap context = Maps.newHashMap();
        context.put("request", request);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MMM dd, yyyy hh:mm a z");
        context.put("dateFormatter", dateFormatter);
        AioUser loggedInUser = (AioUser)request.getAttribute("loggedInUser");
        if (loggedInUser != null) {
            TimeZone timeZone = TimeZone.getTimeZone(loggedInUser.getTimeZone());
            String _userkey = loggedInUser.getUserkey();
            _userkey = StringUtils.replace((String)_userkey, (String)"'", (String)"\\'");
            loggedInUser.setUserkey(_userkey);
            String _username = loggedInUser.getUsername();
            _username = StringUtils.replace((String)_username, (String)"'", (String)"\\'");
            loggedInUser.setUsername(_username);
            try {
                dateFormatter.setTimeZone(timeZone);
            }
            catch (Exception exception) {
                // empty catch block
            }
            context.put("tzOffsetRaw", timeZone.getRawOffset());
        }
        context.put("loggedInUser", loggedInUser);
        switch (platformType) {
            case CLOUD: {
                if ("DEV".equals(Utils.getEnvironment())) {
                    context.put("resourcePath", request.getContextPath());
                } else {
                    context.put("resourcePath", "//aioreports-689b.kxcdn.com/jr");
                }
                context.put("cloud", true);
                context.put("baseUrl", HttpUtils.getBaseUrl(request));
                if (loggedInUser != null) {
                    context.put("jiraBaseUrl", loggedInUser.getTenant().getBaseUrl());
                    context.put("addOnSuffix", "_" + StringUtils.replace((String)loggedInUser.getTenant().getAddOnKey(), (String)".", (String)"_"));
                    context.put("addOnKey", loggedInUser.getTenant().getAddOnKey());
                    context.put("addOnName", Constants.addOnName(loggedInUser.getTenant().getAddOnKey()));
                }
                context.put("showTrialMessage", request.getAttribute("showTrialMessage"));
                context.put("trialExpirationDays", request.getAttribute("trialExpirationDays"));
                context.put("src", request.getParameter("src"));
                context.put("addOnUrlPrefix", "/aio");
                break;
            }
            case HOSTED: {
                Object addOnKey = request.getAttribute("addOnKey");
                if (addOnKey == null) {
                    addOnKey = "com.kaanha.reports";
                }
                String addOnKeyStr = addOnKey.toString();
                context.put("addOnSuffix", "_" + StringUtils.replace((String)addOnKeyStr, (String)".", (String)"_"));
                context.put("addOnKey", addOnKeyStr);
                context.put("addOnName", Constants.addOnName(addOnKeyStr));
                context.put("resourcePath", request.getContextPath() + "/download/resources/" + addOnKeyStr + ":aio-jira-reports-resources");
                context.put("cloud", false);
                context.put("baseUrl", HttpUtils.getBaseUrl(request) + "/plugins/servlet");
                context.put("jiraBaseUrl", HttpUtils.getBaseUrl(request));
                context.put("src", request.getParameter("src"));
                if ("com.kaanha.timesheets".equals(addOnKeyStr)) {
                    context.put("addOnUrlPrefix", "/aio-ts");
                    break;
                }
                if ("com.kaanha.jira.tableau".equals(addOnKeyStr)) {
                    context.put("addOnUrlPrefix", "/aio-tb");
                    break;
                }
                context.put("addOnUrlPrefix", "/aio");
            }
        }
        return context;
    }
}

