/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.LifecycleEventType;
import com.kaanha.reports.model.TenantDTO;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import com.kaanha.reports.servlet.ViewServletUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CloudServlet
extends HttpServlet {
    private static final long serialVersionUID = 2421495792157233074L;
    private final PlatformTypeEnum platformType = PlatformTypeEnum.CLOUD;
    private ViewRenderer viewRenderer = new ViewRenderer(this.platformType, null);
    private UserPersistenceService userService = new UserPersistenceService();
    private ReportPersistenceService reportService = new ReportPersistenceService();
    private AdminPersistenceService adminService = new AdminPersistenceService();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ViewServletUtils.processRequest(request, response, this.userService, this.viewRenderer, this.reportService, this.adminService);
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getServletPath().endsWith("/lifecycle")) {
                this.handleLifecycleEvent(request.getPathInfo().substring(1), request);
            }
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, request, response);
        }
    }

    private void handleLifecycleEvent(String lifecycleEvent, HttpServletRequest request) throws JsonParseException, JsonMappingException, IOException, Exception {
        LifecycleEventType lifecycleEventType = LifecycleEventType.valueOf(lifecycleEvent.toUpperCase());
        this.registerLifecycleEvent(lifecycleEventType, JsonUtils.stringToType(HttpUtils.postData(request), new TypeReference<TenantDTO>(){}), request);
    }

    private AioTenant registerLifecycleEvent(LifecycleEventType lifecycleEvent, TenantDTO tenant, HttpServletRequest request) throws Exception {
        return new TenantPersistenceService().registerLifecycleEvent(lifecycleEvent, tenant, request);
    }
}

