/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.exception.UserNotLoggedInException;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilterHosted
implements Filter {
    private UserManager userManager;
    private String addOnKey;
    private ViewRenderer viewRenderer;
    private TemplateRenderer templateRenderer;
    private UserPersistenceService userService;
    private TimeZoneManager timeZoneManager;
    private final WebSudoManager webSudoManager;

    public AuthenticationFilterHosted(UserManager userManager, TemplateRenderer templateRenderer, ActiveObjects ao2, TimeZoneManager timeZoneManager, WebSudoManager webSudoManager) throws Exception {
        PersistenceService.createHostedInstance(ao2);
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
        this.timeZoneManager = timeZoneManager;
        this.userService = new UserPersistenceService();
        this.webSudoManager = webSudoManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.addOnKey = filterConfig.getInitParameter("addOnKey");
        try {
            this.viewRenderer = new ViewRenderer(PlatformTypeEnum.HOSTED, this.templateRenderer);
        }
        catch (Exception e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            AioUser loggedInUser = null;
            UserProfile user = this.userManager.getRemoteUser();
            if (user == null) {
                throw new UserNotLoggedInException(this.addOnKey);
            }
            String action = ((HttpServletRequest)request).getPathInfo();
            if (action.endsWith("/view/admin_access_groups")) {
                try {
                    this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)request);
                }
                catch (WebSudoSessionException wes) {
                    this.webSudoManager.enforceWebSudoProtection((HttpServletRequest)request, (HttpServletResponse)response);
                }
            }
            if ((loggedInUser = this.userService.findByUserkey(user.getUserKey().getStringValue())) == null) {
                loggedInUser = this.userService.createUserForHosted(user, this.timeZoneManager);
            }
            request.setAttribute("loggedInUser", (Object)loggedInUser);
            request.setAttribute("addOnKey", (Object)this.addOnKey);
            chain.doFilter(request, response);
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void destroy() {
    }
}

