/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.kaanha.reports.connect.AtlassianConnectContextParams;
import com.kaanha.reports.connect.ConnectUtils;
import com.kaanha.reports.connect.JWT;
import com.kaanha.reports.connect.JWTHandler;
import com.kaanha.reports.exception.ExceptionHandler;
import com.kaanha.reports.exception.LicenseExpiredException;
import com.kaanha.reports.exception.UserNotLoggedInException;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AuthenticationFilterCloud
implements Filter {
    private JWTHandler jwtHandler = new JWTHandler();
    private TenantPersistenceService tenantService;
    private ViewRenderer viewRenderer;
    private UserPersistenceService userService;
    static Logger logger = Logger.getLogger(AuthenticationFilterCloud.class);

    public AuthenticationFilterCloud() throws Exception {
        PersistenceService.createCloudInstance();
        this.tenantService = new TenantPersistenceService();
        this.userService = new UserPersistenceService();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.viewRenderer = new ViewRenderer(PlatformTypeEnum.CLOUD, null);
        }
        catch (Exception e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            boolean active;
            AioUser loggedInUser = null;
            AtlassianConnectContextParams contextParams = ConnectUtils.extractAtlassianParamsFromRequest((HttpServletRequest)request);
            JWT jwt = this.jwtHandler.toObject(contextParams.getJwt());
            if (jwt.getUser() == null) {
                throw new UserNotLoggedInException(contextParams.getAok());
            }
            AioTenant tenant = this.tenantService.findByClientKeyAndAddOnKey(jwt.getIss(), contextParams.getAok() + "");
            boolean proceed = this.setDatesAndFlags(tenant, contextParams, active = this.isLicenseActive(tenant, contextParams));
            if (!proceed) {
                throw new LicenseExpiredException(contextParams.getAok());
            }
            loggedInUser = this.userService.findByUserkeyAndTenant(jwt.getUser().getUserKey(), tenant);
            if (loggedInUser == null) {
                loggedInUser = this.userService.createUserForCloud(jwt.getUser(), tenant, contextParams.getTz(), contextParams.getLoc());
            }
            loggedInUser = this.userService.login(loggedInUser, jwt.getUser(), contextParams.getTz());
            request.setAttribute("loggedInUser", (Object)loggedInUser);
            request.setAttribute("showTrialMessage", (Object)contextParams.isShowTrialMessage());
            request.setAttribute("trialExpirationDays", (Object)contextParams.getTrialExpirationDays());
            chain.doFilter(request, response);
        }
        catch (Exception e2) {
            ExceptionHandler.showErrorPage(e2, this.viewRenderer, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void destroy() {
    }

    private boolean setDatesAndFlags(AioTenant tenant, AtlassianConnectContextParams contextParams, boolean active) throws Exception {
        boolean proceed = active;
        tenant.setLastUseDate(new Date());
        tenant.setLicense(contextParams.getLic());
        contextParams.setShowTrialMessage(false);
        Date newTrialEnd = DateUtils.addDays(new Date(), 11);
        boolean licenseMismatch = false;
        if (active && !(proceed = tenant.getLicenseActive().booleanValue())) {
            licenseMismatch = true;
        }
        if (tenant.getTrialStarted() == null) {
            tenant.setTrialStarted(new Date());
        }
        if (proceed) {
            if (tenant.getTrialEnd() == null || newTrialEnd.after(tenant.getTrialEnd())) {
                tenant.setTrialEnd(newTrialEnd);
            }
        } else if (tenant.getTrialEnd() == null) {
            tenant.setTrialEnd(newTrialEnd);
            proceed = true;
        } else if (tenant.getTrialEnd().after(new Date())) {
            contextParams.setTrialExpirationDays(tenant.getTrialEnd());
            if (contextParams.getTrialExpirationDays() <= 10) {
                contextParams.setShowTrialMessage(true);
            }
            proceed = true;
        } else {
            proceed = false;
        }
        if (proceed) {
            tenant.setLastAllowedDate(new Date());
        }
        tenant.setLicenseMismatch(licenseMismatch);
        this.tenantService.save(tenant);
        return proceed;
    }

    private boolean isLicenseActive(AioTenant tenant, AtlassianConnectContextParams contextParams) throws Exception {
        return "active".equalsIgnoreCase(contextParams.getLic());
    }
}

