/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.servlet;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.exception.AjaxException;
import com.kaanha.reports.exception.ReportNotFoundException;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.ResourceLoader;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioMetrics;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.MetricsPersistenceService;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.TeamPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.ExportService;
import com.kaanha.reports.service.OAuthService;
import com.kaanha.reports.service.ReportingService;
import com.kaanha.reports.service.SchemaBuilder;
import com.kaanha.reports.service.TableauService;
import com.kaanha.reports.service.TrendReportingService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AjaxServlet
extends HttpServlet {
    private static final long serialVersionUID = 2421495792157233074L;
    static Logger logger = Logger.getLogger(AjaxServlet.class);
    private PlatformTypeEnum platformType;
    private String addOnKey = null;

    public void init(ServletConfig config) throws ServletException {
        if ("CLOUD".equals(config.getInitParameter("platformType"))) {
            this.platformType = PlatformTypeEnum.CLOUD;
        }
        if ("HOSTED".equals(config.getInitParameter("platformType"))) {
            this.platformType = PlatformTypeEnum.HOSTED;
            this.addOnKey = config.getInitParameter("addOnKey");
        }
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (AjaxException ae2) {
            throw ae2;
        }
        catch (Exception e2) {
            throw new AjaxException(e2, null);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (AjaxException ae2) {
            throw ae2;
        }
        catch (Exception e2) {
            throw new AjaxException(e2, null);
        }
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = new Date().getTime();
        request.setCharacterEncoding("UTF-8");
        String action = request.getPathInfo().substring(1);
        Map<Integer, Map<String, Object>> out = null;
        AioUser loggedInUser = (AioUser)request.getAttribute("loggedInUser");
        if (PlatformTypeEnum.HOSTED.equals((Object)this.platformType)) {
            request.setAttribute("addOnKey", (Object)this.addOnKey);
        }
        String postData = null;
        try {
            if ("export".equals(action)) {
                this.export(request, response);
            } else {
                response.setContentType("application/json; charset=utf-8");
                postData = HttpUtils.postData(request);
                JsonNode postDataNode = JsonUtils.stringToJsonNode(postData);
                JsonNode metrics = null;
                if (JsonUtils.isNotJsonNull(postDataNode)) {
                    postData = JsonUtils.objectToJsonString(postDataNode.get("data"));
                    metrics = postDataNode.get("metrics");
                }
                if ("schema".equals(action)) {
                    out = this.schema(postData, loggedInUser, request);
                }
                if ("queryFields".equals(action)) {
                    out = this.queryFields(postData, loggedInUser, request);
                }
                if ("processIssues".equals(action)) {
                    out = this.processIssues(postData, loggedInUser, request);
                }
                if ("save".equals(action)) {
                    out = this.save(postData, loggedInUser, request);
                }
                if ("open".equals(action)) {
                    out = this.open(postData, loggedInUser, request);
                }
                if ("share".equals(action)) {
                    this.share(postData, loggedInUser, request);
                    out = this.successMessage();
                }
                if ("shareUsers".equals(action)) {
                    out = this.shareUsers(request.getParameter("aioReportId"), loggedInUser);
                }
                if ("shareTeam".equals(action)) {
                    this.shareTeam(postData, loggedInUser, request);
                    out = this.successMessage();
                }
                if ("shareTeamUsers".equals(action)) {
                    out = this.shareTeamUsers(request.getParameter("aioTeamId"), loggedInUser);
                }
                if ("subscribe".equals(action)) {
                    this.subscribe(postData, loggedInUser, request);
                    out = this.successMessage();
                }
                if ("scheduledReport".equals(action)) {
                    out = this.scheduledReport(request.getParameter("aioReportId"), loggedInUser, request);
                }
                if ("delete".equals(action)) {
                    this.delete(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("unpublish".equals(action)) {
                    this.unpublish(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("copy".equals(action)) {
                    this.copy(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("runNow".equals(action)) {
                    this.runNow(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("trendJqls".equals(action)) {
                    out = this.trendJqls(postData, loggedInUser, request);
                }
                if ("publish".equals(action)) {
                    out = this.publish(postData, loggedInUser);
                }
                if ("published".equals(action)) {
                    out = this.published(request);
                }
                if ("validateJql".equals(action)) {
                    out = this.validateJql(postData, request);
                }
                if ("tableau_schema".equals(action)) {
                    out = this.tableauSchema(request);
                }
                if ("tableau_issues".equals(action)) {
                    out = this.tableauIssues(postData, request);
                }
                if ("tableau_issue_worklogs".equals(action)) {
                    out = this.tableauIssueWorklogs(postData, request);
                }
                if ("tableau_issue_history".equals(action)) {
                    out = this.tableauIssueHistory(postData, request);
                }
                if ("saveTeam".equals(action)) {
                    this.saveTeam(postData, loggedInUser, request);
                    out = this.successMessage();
                }
                if ("deleteTeam".equals(action)) {
                    this.deleteTeam(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("login".equals(action)) {
                    this.login(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("savePermissions".equals(action)) {
                    this.savePermissions(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("saveAddOnPreferences".equals(action)) {
                    this.saveAddOnPreferences(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("saveMyPreferences".equals(action)) {
                    this.saveMyPreferences(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("getPermissions".equals(action)) {
                    out = this.getPermissions(loggedInUser);
                }
                if ("tableauAccessCode".equals(action)) {
                    this.saveTableauAccessCode(postData, loggedInUser);
                    out = this.successMessage();
                }
                if ("checkSession".equals(action)) {
                    out = request.getSession().getAttribute("data") != null;
                }
                if ("myTeams".equals(action)) {
                    out = this.myTeamsJson(loggedInUser);
                }
                long endTime = new Date().getTime();
                HashMap outMap = Maps.newHashMap();
                outMap.put("results", out);
                outMap.put("metrics", this.calculateMetrics(startTime, endTime, request, postData, metrics, loggedInUser, this.platformType));
                response.getWriter().print(JsonUtils.objectToJsonString(outMap));
            }
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new AjaxException(e2, postData);
        }
    }

    private void saveTableauAccessCode(String postData, AioUser loggedInUser) throws SQLException, Exception {
        new UserPersistenceService().saveTableauAccessCode(loggedInUser, postData);
    }

    private void saveAddOnPreferences(String postData, AioUser loggedInUser) throws JsonParseException, JsonMappingException, SQLException, IOException, Exception {
        new AdminPersistenceService().saveAddOnPreferences(loggedInUser, postData);
    }

    private void saveMyPreferences(String postData, AioUser loggedInUser) throws JsonParseException, JsonMappingException, SQLException, IOException, Exception {
        new UserPersistenceService().setMyPreferences(loggedInUser, postData);
    }

    private void login(String postData, AioUser loggedInUser) throws JsonParseException, JsonMappingException, IOException, Exception {
        new UserPersistenceService().login(loggedInUser, postData);
    }

    private void savePermissions(String postData, AioUser loggedInUser) throws JsonParseException, JsonMappingException, IOException, Exception {
        new AdminPersistenceService().saveAddOnPermissions(loggedInUser, postData);
    }

    private Map<String, JsonNode> getPermissions(AioUser loggedInUser) throws JsonParseException, JsonMappingException, IOException, Exception {
        return new AdminPersistenceService().fetchAddOnPermissions(loggedInUser);
    }

    private DTO published(HttpServletRequest request) throws JsonParseException, JsonMappingException, ReportNotFoundException, SQLException, ParseException, IOException, Exception {
        DTO dto = new ReportPersistenceService().findPublishedResultsByLink(request.getParameter("link"), request.getAttribute("loggedInUser"));
        request.getSession().setAttribute("data", (Object)JsonUtils.objectToJsonString(dto.getPublishedResults()));
        request.getSession().setAttribute("dto", (Object)dto);
        return dto;
    }

    private Object publish(String postData, AioUser loggedInUser) throws NumberFormatException, ReportNotFoundException, SQLException, Exception {
        Map<String, Object> m2 = JsonUtils.stringToType(postData, new TypeReference<Map<String, Object>>(){});
        return new ReportPersistenceService().publish(Integer.parseInt(m2.get("aioReportId").toString()), JsonUtils.objectToJsonString(m2.get("data")), loggedInUser);
    }

    private Object trendJqls(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, IOException, ParseException {
        return new TrendReportingService().trendJqls(this.postDataToDTO(postData, loggedInUser, request));
    }

    private void export(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String data = null;
        DTO dto = null;
        if (request.getSession().getAttribute("data") == null) {
            data = request.getParameter("data");
            dto = JsonUtils.stringToType(request.getParameter("dto"), new TypeReference<DTO>(){});
        } else {
            data = (String)request.getSession().getAttribute("data");
            dto = (DTO)request.getSession().getAttribute("dto");
        }
        ExportService exportService = new ExportService();
        exportService.export(dto, data);
        HttpUtils.exportToResponse(response, exportService, dto, "xlsx");
    }

    private void delete(String aioReportId, AioUser loggedInUser) throws NumberFormatException, Exception {
        new ReportPersistenceService().delete(Integer.parseInt(aioReportId), loggedInUser);
    }

    private void deleteTeam(String teamId, AioUser loggedInUser) throws NumberFormatException, Exception {
        new TeamPersistenceService().delete(teamId, loggedInUser);
    }

    private void unpublish(String aioReportId, AioUser loggedInUser) throws NumberFormatException, ReportNotFoundException, SQLException, Exception {
        new ReportPersistenceService().unpublish(Integer.parseInt(aioReportId), loggedInUser);
    }

    private void copy(String aioReportId, AioUser loggedInUser) throws NumberFormatException, Exception {
        new ReportPersistenceService().copy(Integer.parseInt(aioReportId), loggedInUser);
    }

    private void runNow(String aioReportId, AioUser loggedInUser) throws NumberFormatException, Exception {
        new ReportPersistenceService().runNow(Integer.parseInt(aioReportId), loggedInUser);
    }

    private List<Map<String, String>> shareUsers(String aioReportId, AioUser loggedInUser) throws NumberFormatException, ReportNotFoundException, SQLException, Exception {
        return new ReportPersistenceService().shareUsers(Integer.parseInt(aioReportId), loggedInUser);
    }

    private List<Map<String, String>> shareTeamUsers(String teamId, AioUser loggedInUser) throws NumberFormatException, ReportNotFoundException, SQLException, Exception {
        return new TeamPersistenceService().shareTeamUsers(teamId, loggedInUser);
    }

    private void share(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, ReportNotFoundException, SQLException, IOException, Exception {
        new ReportPersistenceService().share(this.postDataToDTO(postData, loggedInUser, request), loggedInUser);
    }

    private void shareTeam(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, ReportNotFoundException, SQLException, IOException, Exception {
        new TeamPersistenceService().shareTeam(JsonUtils.stringToJsonNode(postData), loggedInUser);
    }

    private void saveTeam(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, ReportNotFoundException, SQLException, IOException, Exception {
        new TeamPersistenceService().createOrUpdate(this.postDataToDTO(postData, loggedInUser, request), loggedInUser);
    }

    private Map<String, Object> scheduledReport(String aioReportId, AioUser loggedInUser, HttpServletRequest request) throws NumberFormatException, ReportNotFoundException, SQLException, Exception {
        HashMap out = Maps.newHashMap();
        boolean valid = OAuthService.getInstance().initOAuth(OAuthParams.build(this.platformType, request, loggedInUser, null), out);
        if (valid) {
            out.put("schedule", new ReportPersistenceService().scheduledReport(Integer.parseInt(aioReportId), loggedInUser));
        }
        return out;
    }

    private void subscribe(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, ReportNotFoundException, SQLException, IOException, Exception {
        new ReportPersistenceService().subscribe(this.postDataToDTO(postData, loggedInUser, request), loggedInUser);
    }

    private DTO open(String postData, AioUser loggedInUser, HttpServletRequest request) throws Exception {
        DTO dto = this.postDataToDTO(postData, loggedInUser, request);
        return new ReportPersistenceService().open(dto, loggedInUser, dto.getSchema());
    }

    private Object save(String postData, AioUser loggedInUser, HttpServletRequest request) throws Exception {
        return new ReportPersistenceService().save(this.postDataToDTO(postData, loggedInUser, request), loggedInUser);
    }

    private Map<String, Object> schema(String postData, AioUser loggedInUser, HttpServletRequest request) throws Exception {
        return new SchemaBuilder().build(JsonUtils.stringToType(postData, new TypeReference<JsonNode>(){}), loggedInUser, new AdminPersistenceService());
    }

    private Map<String, Object> queryFields(String postData, AioUser loggedInUser, HttpServletRequest request) throws JsonParseException, JsonMappingException, IOException {
        return SchemaBuilder.queryFields(this.postDataToDTO(postData, loggedInUser, request));
    }

    private Map<String, Object> processIssues(String postData, AioUser loggedInUser, HttpServletRequest request) throws Exception {
        Map<String, Object> map = new ReportingService().process(this.postDataToDTO(postData, loggedInUser, request), false, loggedInUser);
        request.getSession().setAttribute("data", (Object)JsonUtils.objectToJsonString(map.get("viewData")));
        request.getSession().setAttribute("dto", map.get("dto"));
        return map;
    }

    public String debugPostData(String postData) throws IOException {
        if ("DEV".equals(Utils.getEnvironment())) {
            return IOUtils.toString(ResourceLoader.getClasspathResourceInputStream("postdata"), "UTF-8");
        }
        return postData;
    }

    private Object validateJql(String postData, HttpServletRequest request) throws Exception {
        String jql = "";
        String tableauAccessCode = null;
        JsonNode postDataNode = JsonUtils.stringToJsonNode(postData);
        if (JsonUtils.isNotJsonNull(postDataNode.get("jql"))) {
            jql = postDataNode.get("jql").asText();
        }
        if (postDataNode.has("tableauAccessCode") && JsonUtils.isNotJsonNull(postDataNode.get("tableauAccessCode"))) {
            tableauAccessCode = postDataNode.get("tableauAccessCode").asText();
        }
        return new TableauService().validateJql(jql, tableauAccessCode, request.getParameter("link"), this.platformType, request);
    }

    private Object tableauSchema(HttpServletRequest request) throws Exception {
        return new TableauService().schema(request.getParameter("link"), this.platformType, request);
    }

    private Object tableauIssues(String postData, HttpServletRequest request) throws Exception {
        return new TableauService().issues(JsonUtils.stringToJsonNode(postData), request.getParameter("link"), this.platformType, request);
    }

    private Object tableauIssueWorklogs(String postData, HttpServletRequest request) throws Exception {
        return new TableauService().issueWorklogs(JsonUtils.stringToJsonNode(postData), request.getParameter("link"), this.platformType, request);
    }

    private Object tableauIssueHistory(String postData, HttpServletRequest request) throws Exception {
        return new TableauService().issueHistory(JsonUtils.stringToJsonNode(postData), request.getParameter("link"), this.platformType, request);
    }

    private Map<Integer, Map<String, Object>> myTeamsJson(AioUser loggedInUser) throws Exception {
        HashMap m2 = Maps.newHashMap();
        for (AioTeam t2 : new TeamPersistenceService().getUserTeams(loggedInUser)) {
            HashMap _m = Maps.newHashMap();
            _m.put("name", t2.getName());
            ArrayList memberKeys = Lists.newArrayList();
            for (AioTeamMember tm : t2.getMembers()) {
                HashMap u2 = Maps.newHashMap();
                u2.put("username", tm.getUser().getUsername());
                u2.put("userkey", tm.getUser().getUserkey());
                memberKeys.add(u2);
            }
            _m.put("members", memberKeys);
            m2.put(t2.getID(), _m);
        }
        return m2;
    }

    private DTO postDataToDTO(String postData, AioUser loggedInUser, HttpServletRequest request) throws IOException, JsonParseException, JsonMappingException {
        DTO dto = JsonUtils.stringToType(postData, new TypeReference<DTO>(){});
        if (loggedInUser != null) {
            dto.setTimezone(loggedInUser.getTimeZone());
        }
        try {
            logger.debug((Object)(loggedInUser.getTenant().getBaseUrl() + ", " + loggedInUser.getUserkey() + ", " + loggedInUser.getTenant().getAddOnKey() + ", " + loggedInUser.getTenant().getLicense() + ", " + dto.getAioReportId() + ", " + dto.getIssues().size() + ", " + loggedInUser.getTimeZone()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dto;
    }

    private Map<String, Object> calculateMetrics(long startTime, long endTime, HttpServletRequest request, String postData, JsonNode metrics, AioUser loggedInUser, PlatformTypeEnum platformType) {
        HashMap out = Maps.newHashMap();
        if (PlatformTypeEnum.CLOUD.equals((Object)platformType)) {
            try {
                if (metrics != null) {
                    this.logMetrics(postData, loggedInUser, request, metrics);
                }
                out.put("path", request.getRequestURI());
                String browserStartTime = request.getParameter("_");
                out.put("st", browserStartTime);
                out.put("pt", endTime - startTime);
                if (StringUtils.isNotBlank((CharSequence)postData)) {
                    out.put("sz", postData.getBytes().length / 1000);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    private void logMetrics(String postData, AioUser loggedInUser, HttpServletRequest request, JsonNode metrics) {
        try {
            MetricsPersistenceService mps = new MetricsPersistenceService();
            Long startTime = Long.parseLong(metrics.get("st").asText());
            Long endTime = Long.parseLong(metrics.get("et").asText());
            Long processingTime = Long.parseLong(metrics.get("pt").asText());
            AioMetrics am2 = mps.createStub();
            am2.setTimeZone(loggedInUser.getTimeZone());
            am2.setTransitTime(endTime - startTime - processingTime);
            am2.setProcessingTime(processingTime);
            am2.setDataSizeKb(metrics.get("sz").asLong());
            am2.setPath(metrics.get("path").asText());
            am2.setRequestDate(new Date());
            am2.setServer(Utils.getEnvironment());
            am2.setBaseUrl(loggedInUser.getTenant().getBaseUrl());
            am2.setUsername(loggedInUser.getUsername());
            mps.save(am2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object successMessage() {
        HashMap _out = Maps.newHashMap();
        _out.put("message", "success");
        HashMap out = _out;
        return out;
    }
}

