/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.kaanha.reports.helper.Constants;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.service.Comment;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValueExtractor {
    public static String value(Field field, JsonNode issue, String timezone) throws Exception {
        String fieldName = field.getId();
        if (field.getId().equals(Constants.COMMENT_FIELD_ID)) {
            return ValueExtractor.commentValue(issue, timezone);
        }
        JsonNode valueNode = issue.get(fieldName);
        if (JsonUtils.isNotJsonNull(valueNode)) {
            if (valueNode.isValueNode()) {
                return valueNode.asText();
            }
            if (valueNode.isContainerNode()) {
                if (valueNode.isObject()) {
                    if (Fielder.isArray(field)) {
                        return ValueExtractor.getArrayValue(issue, fieldName, valueNode, field);
                    }
                    return ValueExtractor.getObjectValue(valueNode, fieldName);
                }
                if (valueNode.isArray()) {
                    return ValueExtractor.getArrayValues(valueNode, fieldName, field);
                }
            }
        } else {
            return null;
        }
        throw new Exception("Unable to determine value: [" + fieldName + "][" + issue + "]");
    }

    private static String getObjectValue(JsonNode valueNode, String fieldName) throws Exception {
        if (valueNode.has("displayName")) {
            return valueNode.get("displayName").asText();
        }
        if (valueNode.has("value")) {
            String out = valueNode.get("value").asText();
            if (valueNode.has("child")) {
                String child = valueNode.get("child").get("value").asText();
                out = out + " - " + child;
            }
            return out;
        }
        if (valueNode.has("name")) {
            return valueNode.get("name").asText();
        }
        if (valueNode.has("key")) {
            return valueNode.get("key").asText();
        }
        if (valueNode.has("body")) {
            return valueNode.get("body").asText();
        }
        if (valueNode.has(fieldName)) {
            return valueNode.get(fieldName).asText();
        }
        try {
            return valueNode.asText();
        }
        catch (Exception e2) {
            return valueNode.toString();
        }
    }

    private static String getArrayValue(JsonNode node, String fieldName, JsonNode valueNode, Field field) throws Exception {
        JsonNode childNode = null;
        if (valueNode.has(fieldName + "s")) {
            childNode = valueNode.get(fieldName + "s");
        } else if (valueNode.has(fieldName)) {
            childNode = valueNode.get(fieldName);
        }
        if (childNode == null) {
            return ValueExtractor.getObjectValue(node, fieldName);
        }
        if (childNode.isNull()) {
            return null;
        }
        if (childNode.isObject()) {
            return childNode.asText();
        }
        if (childNode.isArray()) {
            return ValueExtractor.getArrayValues(childNode, fieldName, field);
        }
        return null;
    }

    private static String getArrayValues(JsonNode valueNode, String fieldName, Field field) throws Exception {
        ArrayList<String> arr = new ArrayList<String>();
        Iterator<JsonNode> nodes = valueNode.elements();
        while (nodes.hasNext()) {
            arr.add(ValueExtractor.getObjectValue(nodes.next(), fieldName));
        }
        if (arr.size() > 0) {
            if ("Sprint".equalsIgnoreCase(field.getName())) {
                return Joiner.on((String)"~@~").join(arr);
            }
            return Joiner.on((String)"\n").join(arr);
        }
        return null;
    }

    public static List<String> worklogs(Field field, JsonNode issue, boolean hasWlAioTeam, Map<String, String> userToTeamMapping, boolean timeEntry) {
        String fieldName = field.getId();
        JsonNode valueNode = issue.get(fieldName);
        JsonNode workLogsNode = valueNode.get("worklogs");
        ArrayList workLogs = Lists.newArrayList();
        for (JsonNode worklog : workLogsNode) {
            if (hasWlAioTeam) {
                String teamName = "";
                if (worklog.has("author") && worklog.get("author").has("name")) {
                    String authorKey = worklog.get("author").get("name").asText();
                    teamName = userToTeamMapping.get(authorKey);
                }
                if (StringUtils.isBlank((CharSequence)teamName)) {
                    teamName = "-";
                }
                ((ObjectNode)worklog).put("wlAioTeam", teamName);
            }
            workLogs.add(worklog.toString());
        }
        if (timeEntry) {
            workLogs.add("{}");
        }
        return workLogs;
    }

    public static List<String> history(Field field, JsonNode issue) {
        String fieldName = field.getId();
        JsonNode historyNode = issue.get(fieldName);
        ArrayList history = Lists.newArrayList();
        for (JsonNode h2 : historyNode) {
            history.add(h2.toString());
        }
        return history;
    }

    private static String commentValue(JsonNode node, String timezone) throws ParseException {
        JsonNode comments;
        StringBuffer out = new StringBuffer();
        JsonNode comment = node.get("comment");
        if (comment != null && (comments = comment.get("comments")) != null) {
            ArrayList sortedComments = Lists.newArrayList();
            for (JsonNode _c : comments) {
                String author = _c.get("author").get("displayName").asText();
                String created = DateUtils.format(DateUtils.applyTimezone(_c.get("created").asText(), timezone), "MMM-dd-yyyy HH:mm:ss");
                String body = _c.get("body").asText();
                Comment c2 = new Comment();
                c2.setAuthor(author);
                c2.setCreated(created);
                c2.setBody(body);
                sortedComments.add(c2);
            }
            Collections.sort(sortedComments);
            for (Comment c3 : sortedComments) {
                out.append(StringUtils.rightPad((String)c3.getAuthor(), (int)40, (String)" ") + StringUtils.rightPad((String)c3.getCreated(), (int)25, (String)" ") + "\n" + StringUtils.rightPad((String)"-", (int)70, (String)"-") + "\n" + c3.getBody() + "\n\n");
            }
        }
        return out.toString();
    }
}

