/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.service.OfflineReportService;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TrendReportingService {
    public List<List<Object>> trendJqls(DTO dto) throws ParseException, JsonParseException, JsonMappingException, IOException {
        OfflineReportService.setReportStartEndDates(dto);
        ArrayList out = Lists.newArrayList();
        List<Map<String, Date>> buckets = this.buckets(dto);
        int i2 = 0;
        for (Map<String, Date> bucket : buckets) {
            for (String trendValue : dto.getTrendValues()) {
                if (dto.isBreakByIssueType()) {
                    for (String issueType : dto.getIssueTypes()) {
                        out.add(Lists.newArrayList((Object[])new Object[]{this.trendJql(trendValue, bucket, issueType, dto), this.trendIssue(dto, trendValue, bucket, i2, issueType)}));
                    }
                    continue;
                }
                out.add(Lists.newArrayList((Object[])new Object[]{this.trendJql(trendValue, bucket, null, dto), this.trendIssue(dto, trendValue, bucket, i2, null)}));
            }
            ++i2;
        }
        return out;
    }

    private Map<String, Object> trendIssue(DTO dto, String trendValue, Map<String, Date> bucket, int i2, String issueType) throws JsonParseException, JsonMappingException, IOException {
        HashMap issue = Maps.newHashMap();
        if (dto.getTrendField().equals("created_resolved")) {
            issue.put("aio_event", trendValue);
        } else if (dto.getTrendField().equals("status")) {
            issue.put(dto.getTrendField(), JsonUtils.stringToJsonNode("{\"name\":\"" + trendValue + "\"}"));
        } else {
            issue.put(dto.getTrendField(), trendValue);
        }
        String interval = this.interval(dto.getTrendInterval(), bucket, i2);
        issue.put("aio_interval", interval);
        if (StringUtils.isNotBlank((CharSequence)issueType)) {
            issue.put("issuetype", issueType);
        }
        return issue;
    }

    private String interval(String interval, Map<String, Date> bucket, int i2) {
        String intervalStartDate = "";
        String intervalEndDate = "";
        String sortHelper = StringUtils.leftPad((String)("" + i2), (int)3, (String)"0") + ":";
        if ("yearly".equalsIgnoreCase(interval)) {
            intervalStartDate = DateUtils.format(bucket.get("startDate"), "MMM-dd-yyyy");
            intervalEndDate = DateUtils.format(DateUtils.addDays(bucket.get("endDate"), -1), "MMM-dd-yyyy");
        } else {
            intervalStartDate = DateUtils.format(bucket.get("startDate"), "MMM-dd");
            intervalEndDate = DateUtils.format(DateUtils.addDays(bucket.get("endDate"), -1), "MMM-dd");
        }
        if ("daily".equalsIgnoreCase(interval)) {
            return sortHelper + intervalStartDate;
        }
        return sortHelper + intervalStartDate + " to " + intervalEndDate;
    }

    private String trendJql(String trendValue, Map<String, Date> bucket, String issueType, DTO dto) throws ParseException {
        StringBuffer jql = new StringBuffer();
        String trendField = dto.getTrendField();
        String intervalStartDate = DateUtils.format(bucket.get("startDate"), "yyyy-MM-dd");
        String intervalEndDate = DateUtils.format(bucket.get("endDate"), "yyyy-MM-dd");
        String reportStartDate = DateUtils.format(DateUtils.jsToJava(dto.getStartDate()), "yyyy-MM-dd");
        if (trendField.equalsIgnoreCase("status") || trendField.equalsIgnoreCase("priority") || trendField.equalsIgnoreCase("resolution")) {
            jql.append("(" + trendField + " was '" + StringUtils.replace((String)trendValue, (String)"'", (String)"\\'") + "' during ('");
            if (dto.isShowCumulative()) {
                jql.append(reportStartDate);
            } else {
                jql.append(intervalStartDate);
            }
            jql.append("','" + intervalEndDate + "'))");
        } else {
            jql.append("(" + trendValue + ">='");
            if (dto.isShowCumulative()) {
                jql.append(reportStartDate);
            } else {
                jql.append(intervalStartDate);
            }
            jql.append("' and " + trendValue + "<'" + intervalEndDate + "')");
        }
        if (StringUtils.isNotBlank((CharSequence)issueType)) {
            jql.append(" and issuetype='" + issueType + "'");
        }
        return jql.toString();
    }

    private List<Map<String, Date>> buckets(DTO dto) throws ParseException {
        Date today;
        ArrayList buckets = Lists.newArrayList();
        Date startDate = DateUtils.jsToJava(dto.getStartDate());
        Date endDate = DateUtils.jsToJava(dto.getEndDate());
        if (endDate.after(today = new Date())) {
            endDate = today;
        }
        String interval = dto.getTrendInterval();
        Date compareDate = DateUtils.addDays(endDate, 1);
        while (startDate.before(compareDate)) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(startDate);
            Date intervalEndDate = null;
            if ("daily".equalsIgnoreCase(interval)) {
                c2.add(5, 1);
            }
            if ("weekly".equalsIgnoreCase(interval)) {
                if (c2.get(7) == 1) {
                    c2.add(5, 1);
                } else {
                    c2.add(5, 9 - c2.get(7));
                }
            }
            if ("monthly".equalsIgnoreCase(interval)) {
                c2.add(2, 1);
                c2.set(5, c2.getActualMinimum(5));
            }
            if ("yearly".equalsIgnoreCase(interval)) {
                c2.add(1, 1);
                c2.set(5, c2.getActualMinimum(6));
            }
            if ((intervalEndDate = c2.getTime()).after(endDate)) {
                intervalEndDate = compareDate;
            }
            HashMap m2 = Maps.newHashMap();
            m2.put("startDate", startDate);
            m2.put("endDate", intervalEndDate);
            startDate = intervalEndDate;
            buckets.add(m2);
        }
        return buckets;
    }

    public List<String> getIntervals(DTO dto) throws ParseException {
        List<Map<String, Date>> buckets = this.buckets(dto);
        ArrayList intervals = Lists.newArrayList();
        int i2 = 0;
        for (Map<String, Date> bucket : buckets) {
            intervals.add(this.interval(dto.getTrendInterval(), bucket, i2));
            ++i2;
        }
        return intervals;
    }

    public List<String> getQueryFields(DTO dto) {
        ArrayList queryFields = Lists.newArrayList();
        if (dto.getTrendField().equals("created_resolved")) {
            queryFields.add("aio_event");
        } else {
            queryFields.add(dto.getTrendField());
        }
        if (dto.isBreakByIssueType()) {
            queryFields.add("issuetype");
        }
        queryFields.add("aio_interval");
        queryFields.add("aio_total");
        queryFields.add("aio_total_percent");
        return queryFields;
    }

    public static void trendValuesToData(DTO dto) {
        dto.getData().clear();
        for (String trendValue : dto.getTrendValues()) {
            Field f2 = new Field();
            f2.setName(trendValue);
            dto.getData().add(f2);
        }
    }
}

