/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.exception.InvalidAccessCodeException;
import com.kaanha.reports.exception.InvalidJQLException;
import com.kaanha.reports.exception.InvalidTableauURLException;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.DataSet;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.model.ReportType;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.DBEngine;
import com.kaanha.reports.service.Normalizer;
import com.kaanha.reports.service.OAuthService;
import com.kaanha.reports.service.OfflineReportService;
import com.kaanha.reports.service.SearchService;
import com.kaanha.reports.service.TableauSchemaBuilder;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.nimbusds.jose.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TableauService {
    public static String[] REMOVABLE_ATTRIBUTES = new String[]{"expand", "self", "avatarUrls", "iconUrl", "viewUrl", "searchUrl"};
    static Logger logger = Logger.getLogger(TableauService.class);

    public Object validateJql(String jql, String tableauAccessCode, String tableauKey, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception {
        AioUser user = this.fetchUser(tableauKey);
        if (StringUtils.isNotBlank((CharSequence)user.getTableauAccessCode()) && tableauAccessCode != null && !StringUtils.equals((CharSequence)user.getTableauAccessCode(), (CharSequence)tableauAccessCode)) {
            throw new InvalidAccessCodeException();
        }
        OAuthParams oAuthParams = OAuthParams.build(platformType, request, user, null);
        SearchService searchService = new SearchService();
        try {
            int size = searchService.size(oAuthParams, jql);
            return size;
        }
        catch (Exception e2) {
            if (StringUtils.isNotBlank((CharSequence)e2.getMessage())) {
                if (e2.getMessage().contains("errorMessages")) {
                    throw new InvalidJQLException(JsonUtils.stringToJsonNode(e2.getMessage()).get("errorMessages").get(0).asText());
                }
                throw e2;
            }
            throw new Exception("Unable to validate JQL. Please try again later.");
        }
    }

    public List<Field> schema(String tableauKey, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception {
        AioUser user = this.fetchUser(tableauKey);
        OAuthParams oAuthParams = OAuthParams.build(platformType, request, user, null);
        OAuthService authService = OAuthService.getInstance();
        String jiraFields = authService.get(oAuthParams, "/rest/api/latest/field");
        TableauSchemaBuilder schemaBuilder = new TableauSchemaBuilder();
        return schemaBuilder.build(JsonUtils.stringToJsonNode(jiraFields), user);
    }

    public AioUser fetchUser(String tableauKey) throws Exception {
        UserPersistenceService ups = new UserPersistenceService();
        AioUser user = ups.findByTableauKey(new Base64(tableauKey).decodeToString());
        if (user == null) {
            throw new InvalidTableauURLException();
        }
        return user;
    }

    private Object fetch(JsonNode postDataNode, String tableauKey, boolean worklog, PlatformTypeEnum platformType, HttpServletRequest request, boolean history) throws Exception {
        String jql = JsonUtils.isJsonNull(postDataNode.get("jql")) ? "" : postDataNode.get("jql").asText();
        JsonNode idNodes = postDataNode.get("selectedFieldIds");
        JsonNode schema = postDataNode.get("schema");
        int start = postDataNode.get("start").asInt();
        AioUser user = this.fetchUser(tableauKey);
        OAuthParams oAuthParams = OAuthParams.build(platformType, request, user, null);
        List<Field> schemaFields = JsonUtils.stringToType(JsonUtils.objectToJsonString(schema), new TypeReference<List<Field>>(){});
        DTO dto = new DTO();
        dto.setSchema(schemaFields);
        dto.setType(ReportType.list);
        Collection<Object> fieldsToFetch = Lists.newArrayList();
        for (Object idNode : idNodes) {
            Field field = Fielder.findInFields(((JsonNode)idNode).asText(), schemaFields);
            if (field == null) continue;
            fieldsToFetch.add(field);
        }
        if (worklog) {
            fieldsToFetch = Fielder.worklogFields((Collection<Field>)fieldsToFetch);
            fieldsToFetch.add(Fielder.findInFields("issuekey", schemaFields));
        } else {
            fieldsToFetch = Fielder.nonWorklogFields((Collection<Field>)fieldsToFetch);
            if (history) {
                fieldsToFetch = Fielder.historyFields((Collection<Field>)fieldsToFetch);
                fieldsToFetch.add(Fielder.findInFields("issuekey", schemaFields));
            } else {
                fieldsToFetch = Fielder.nonHistoryFields((Collection<Field>)fieldsToFetch);
            }
        }
        ArrayList reportable = Lists.newArrayList();
        for (Field field : fieldsToFetch) {
            if (!field.isReportable()) continue;
            reportable.add(field);
        }
        dto.setRow(reportable);
        dto.setColumn(Lists.newArrayList());
        dto.setData(Lists.newArrayList());
        dto.setTimezone(user.getTimeZone());
        dto.setTableau(true);
        OfflineReportService offlineReportService = new OfflineReportService();
        HashMap hashMap = Maps.newHashMap();
        try {
            int fetched = offlineReportService.fetchIssues(oAuthParams, dto, jql, false, start, "Tableau: " + user.getUsername());
            hashMap.put("fetched", fetched);
        }
        catch (Exception e2) {
            logger.debug((Object)("Tableau start: " + start));
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            hashMap.put("fetched", start + SearchService.PAGESIZE);
            hashMap.put("results", Lists.newArrayList());
            return hashMap;
        }
        DataSet dataSet = Normalizer.extract(dto, user);
        DBEngine dbEngine = DBEngine.getInstance();
        String datamartID = dbEngine.createMartNew(dataSet, dto);
        hashMap.put("results", dbEngine.queryMartForMap(datamartID, dto));
        dbEngine.dropMart(datamartID);
        return hashMap;
    }

    public Object issueWorklogs(JsonNode postDataNode, String tableauKey, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception {
        return this.fetch(postDataNode, tableauKey, true, platformType, request, false);
    }

    public Object issueHistory(JsonNode postDataNode, String tableauKey, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception {
        return this.fetch(postDataNode, tableauKey, false, platformType, request, true);
    }

    public Object issues(JsonNode postDataNode, String tableauKey, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception {
        return this.fetch(postDataNode, tableauKey, false, platformType, request, false);
    }
}

