/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kaanha.reports.helper.Constants;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.FieldType;
import com.kaanha.reports.model.Filter;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.service.FieldComparator;
import com.kaanha.reports.service.GroupComparator;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableauSchemaBuilder {
    List<Field> fields = Lists.newArrayList();
    List<Filter> filters = Lists.newArrayList();
    private static Map<String, String> values = Maps.newHashMap();
    private static Map<String, String> names = Maps.newHashMap();
    private static Map<String, List<String>> groupExclusion;
    private static List<String> convertToHour;
    private static List<String> convertToDay;

    public List<Field> build(JsonNode jiraFields, AioUser user) throws ParseException {
        for (JsonNode f2 : jiraFields) {
            Field field = this.newField(f2, false);
            if (this.excluded(field)) continue;
            this.fields.add(field);
        }
        this.parent();
        this.sprint();
        this.storyPoints();
        this.worklog();
        this.history(user.getTimeZone(), 8.0);
        this.project();
        this.statusCategory();
        this.watchCount();
        this.fixVersions();
        this.customerRequestType();
        this.sla();
        this.values();
        this.dependencies();
        this.operations();
        Collections.sort(this.fields, new FieldComparator());
        Collections.sort(this.fields, new GroupComparator());
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            this.fields.get(i2).setColumnName("C" + i2);
        }
        return this.fields;
    }

    private boolean excluded(Field field) {
        return Constants.excluded.contains(field.getId()) || Constants.excluded.contains(field.getName()) || groupExclusion.containsKey(field.getGroup()) && groupExclusion.get(field.getGroup()).contains(field.getName());
    }

    private void parent() {
        Field parent = new Field();
        parent.setId("parent");
        parent.setName("Parent Issue Key");
        parent.setType(FieldType.VARCHAR);
        parent.setExpression("ParentValue(parent, 'key')");
        parent.setAggregate(false);
        parent.setGroup("Parent Issue");
        parent.setDerived(false);
        parent.setRaw(true);
        this.fields.add(parent);
        Field parentSummary = new Field();
        parentSummary.setId("parent.summary");
        parentSummary.setName("Parent Issue Summary");
        parentSummary.setType(FieldType.VARCHAR);
        parentSummary.setExpression("ParentValue(parent, 'summary')");
        parentSummary.setAggregate(false);
        parentSummary.setGroup("Parent Issue");
        parentSummary.setDerived(false);
        parentSummary.getDependsOn().add(parent);
        this.fields.add(parentSummary);
        Field parentStatus = new Field();
        parentStatus.setId("parent.status");
        parentStatus.setName("Parent Issue Status");
        parentStatus.setType(FieldType.VARCHAR);
        parentStatus.setExpression("ParentValue(parent, 'status')");
        parentStatus.setAggregate(false);
        parentStatus.setGroup("Parent Issue");
        parentStatus.setDerived(false);
        parentStatus.getDependsOn().add(parent);
        this.fields.add(parentStatus);
        Field parentPriority = new Field();
        parentPriority.setId("parent.priority");
        parentPriority.setName("Parent Issue Priority");
        parentPriority.setType(FieldType.VARCHAR);
        parentPriority.setExpression("ParentValue(parent, 'priority')");
        parentPriority.setAggregate(false);
        parentPriority.setGroup("Parent Issue");
        parentPriority.setDerived(false);
        parentPriority.getDependsOn().add(parent);
        this.fields.add(parentPriority);
        Field parentIssueType = new Field();
        parentIssueType.setId("parent.issuetype");
        parentIssueType.setName("Parent Issue Type");
        parentIssueType.setType(FieldType.VARCHAR);
        parentIssueType.setExpression("ParentValue(parent, 'issuetype')");
        parentIssueType.setAggregate(false);
        parentIssueType.setGroup("Parent Issue");
        parentIssueType.setDerived(false);
        parentIssueType.getDependsOn().add(parent);
        this.fields.add(parentIssueType);
    }

    private void sprint() {
        Field sprintField = Fielder.findInFieldsByName("Sprint", this.fields);
        if (sprintField != null) {
            String sprintFieldId = sprintField.getId();
            ArrayList sprint = Lists.newArrayList();
            sprint.add(Lists.newArrayList((Object[])new Object[]{"name", "Sprint Name", FieldType.VARCHAR}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"startDate", "Sprint Start Date", FieldType.TIMESTAMP}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"endDate", "Sprint End Date", FieldType.TIMESTAMP}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"completeDate", "Sprint Complete Date", FieldType.TIMESTAMP}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"state", "Sprint State", FieldType.VARCHAR}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"sequence", "Sprint Sequence", FieldType.VARCHAR}));
            sprint.add(Lists.newArrayList((Object[])new Object[]{"id", "Sprint Id", FieldType.VARCHAR}));
            for (List sf : sprint) {
                Field f2 = new Field();
                String fieldId = sprintFieldId + "_" + sf.get(0);
                f2.setId(fieldId);
                f2.setName(sf.get(1).toString());
                f2.setType((FieldType)((Object)sf.get(2)));
                f2.getDependsOn().add(Fielder.findInFields(sprintFieldId, this.fields));
                f2.setGroup("Sprint");
                String exp = "SprintFieldValue('<<DATAMART_ID>>','" + sprintFieldId + "','" + fieldId + "'," + sprintFieldId + ")";
                f2.setExpression(exp);
                f2.setDerived(true);
                this.fields.add(f2);
            }
        }
    }

    private void storyPoints() {
        Field storyPointsField = Fielder.findInFieldsByName("Story Points", this.fields);
        if (storyPointsField != null) {
            String storyPointsFieldId = storyPointsField.getId();
            ArrayList storyPoints = Lists.newArrayList();
            storyPoints.add(Lists.newArrayList((Object[])new Object[]{"completed", "Story Points Completed", FieldType.NUMBER}));
            storyPoints.add(Lists.newArrayList((Object[])new Object[]{"remaining", "Story Points Remaining", FieldType.NUMBER}));
            for (List sf : storyPoints) {
                Field f2 = new Field();
                String fieldId = storyPointsFieldId + "_" + sf.get(0);
                f2.setId(fieldId);
                f2.setName(sf.get(1).toString());
                f2.setType((FieldType)((Object)sf.get(2)));
                f2.getDependsOn().add(Fielder.findInFields("resolutiondate", this.fields));
                f2.getDependsOn().add(Fielder.findInFieldsByName("Story Points", this.fields));
                f2.setGroup("Story Points");
                String exp = "StoryPointsValue('<<DATAMART_ID>>','" + sf.get(0) + "'," + storyPointsFieldId + ",resolutiondate)";
                f2.setExpression(exp);
                f2.setDerived(true);
                this.fields.add(f2);
            }
        }
    }

    private void worklog() {
        ArrayList derivedFields = Lists.newArrayList();
        Field worklogField = Fielder.findInFields("worklog", this.fields);
        if (worklogField != null) {
            worklogField.getDependsOn().add(Fielder.findInFields("issuekey", this.fields));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"author.displayName", "Time Entry User", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"author.name", "Time Entry Username", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"author.key", "Time Entry Userkey", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"started", "Time Entry Date", FieldType.TIMESTAMP}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"timeSpentSeconds", "Time Entry Hours", FieldType.NUMBER}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"id", "Worklog ID", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"comment", "Time Entry Description", FieldType.VARCHAR}));
            this.addDeepValueDerivedField(derivedFields, worklogField, "Worklogs");
        }
    }

    private void history(String timezone, double businessHrsPerDay) {
        ArrayList derivedFields = Lists.newArrayList();
        String groupId = "History";
        Field historyField = new Field();
        String fieldId = "changelog";
        historyField.setId(fieldId);
        historyField.setName("History");
        historyField.setType(FieldType.VARCHAR);
        historyField.setGroup(groupId);
        String exp = "Changelog(" + fieldId + ")";
        historyField.setExpression(exp);
        historyField.getDependsOn().add(Fielder.findInFields("issuekey", this.fields));
        historyField.getDependsOn().add(Fielder.findInFields("created", this.fields));
        historyField.setReportable(false);
        this.fields.add(historyField);
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"field_name", "History Field", FieldType.VARCHAR, "field", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"field_current_value", "History New Value", FieldType.VARCHAR, "value", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"field_current_value_start", "History Value Start", FieldType.TIMESTAMP, "start", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"field_current_value_end", "History Value End", FieldType.TIMESTAMP, "end", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"change_author", "History Author", FieldType.VARCHAR, "author", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"field_old_value", "History Old Value", FieldType.VARCHAR, "from", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"order", "Sequence", FieldType.VARCHAR, "order", ""}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status", "History Status", FieldType.VARCHAR, "value", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_start", "Status start", FieldType.TIMESTAMP, "start", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_end", "Status end", FieldType.TIMESTAMP, "end", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_time", "Time in status (hrs)", FieldType.NUMBER, "time_hrs", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_time_business", "Time in status (business hrs)", FieldType.NUMBER, "time_hrs_business", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_time_days", "Time in status (days)", FieldType.NUMBER, "time_days", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_time_days_business", "Time in status (business days)", FieldType.NUMBER, "time_days_business", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_order", "Status sequence", FieldType.VARCHAR, "order_field", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"status_order_combo", "Status with sequence", FieldType.VARCHAR, "order_combo", "status"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee", "History Assignee", FieldType.VARCHAR, "value", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_start", "Assignee start", FieldType.TIMESTAMP, "start", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_end", "Assignee end", FieldType.TIMESTAMP, "end", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_time", "Time with assignee (hrs)", FieldType.NUMBER, "time_hrs", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_time_business", "Time with assignee (business hrs)", FieldType.NUMBER, "time_hrs_business", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_time_days", "Time with assignee (days)", FieldType.NUMBER, "time_days", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_time_days_business", "Time with assignee (business days)", FieldType.NUMBER, "time_days_business", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_order", "Assignee sequence", FieldType.VARCHAR, "order_field", "assignee"}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"assignee_order_combo", "Assignee with sequence", FieldType.VARCHAR, "order_combo", "assignee"}));
        for (List sf : derivedFields) {
            Field f2 = new Field();
            String parentId = historyField.getId();
            String derivedFieldId = TableauSchemaBuilder.derivedFieldId(parentId, sf.get(0).toString());
            f2.setId(derivedFieldId);
            f2.setName(sf.get(1).toString());
            f2.setType((FieldType)((Object)sf.get(2)));
            f2.getDependsOn().add(historyField);
            if (f2.getId().startsWith("changelog_status")) {
                f2.setGroup("Time in Status");
            } else if (f2.getId().startsWith("changelog_assignee")) {
                f2.setGroup("Time with Assignee");
            } else {
                f2.setGroup(groupId);
            }
            exp = "HistoryValue('" + sf.get(3) + "','" + sf.get(4) + "'," + parentId + ",'" + timezone + "'," + businessHrsPerDay + ")";
            f2.setExpression(exp);
            f2.setDerived(true);
            if (f2.isNumber()) {
                f2.setAggregate(true);
                f2.setAggregateFunction("AVG");
            }
            if (f2.isDate()) {
                f2.setPattern("MMM dd, yyyy hh:mm a");
            }
            this.fields.add(f2);
        }
    }

    private void project() {
        ArrayList derivedFields = Lists.newArrayList();
        Field projectField = Fielder.findInFields("project", this.fields);
        String groupId = "Project";
        projectField.setRaw(true);
        projectField.setReportable(false);
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"key", "Project Key", FieldType.VARCHAR}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"name", "Project Name", FieldType.VARCHAR}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"projectType", "Project Type", FieldType.VARCHAR}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"projectDesc", "Project Description", FieldType.VARCHAR}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"projectLead", "Project Lead", FieldType.VARCHAR}));
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"projectCategory.name", "Project Category", FieldType.VARCHAR}));
        this.addDeepValueDerivedField(derivedFields, projectField, groupId);
    }

    private void statusCategory() {
        ArrayList derivedFields = Lists.newArrayList();
        Field statusField = Fielder.findInFields("status", this.fields);
        String groupId = "Common";
        statusField.setRaw(true);
        statusField.setExpression("DeepValue('" + statusField.getId() + "','" + statusField.getId() + "_name'," + statusField.getId() + ")");
        derivedFields.add(Lists.newArrayList((Object[])new Object[]{"statusCategory.name", "Status Category", FieldType.VARCHAR}));
        this.addDeepValueDerivedField(derivedFields, statusField, groupId);
    }

    private void watchCount() {
        ArrayList derivedFields = Lists.newArrayList();
        Field watchField = Fielder.findInFields("watches", this.fields);
        if (watchField != null) {
            String groupId = "Other";
            watchField.setRaw(true);
            watchField.setReportable(false);
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"watchCount", "Watchers", FieldType.NUMBER}));
            this.addDeepValueDerivedField(derivedFields, watchField, groupId);
        }
    }

    private void fixVersions() {
        ArrayList derivedFields = Lists.newArrayList();
        Field fixVersionsField = Fielder.findInFields("fixVersions", this.fields);
        if (fixVersionsField != null) {
            String groupId = "Fix Version";
            fixVersionsField.setRaw(true);
            fixVersionsField.setReportable(false);
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"name", "Fix Version Name", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"description", "Fix Version Description", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"releaseDate", "Fix Version Release Date", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"startDate", "Fix Version Start Date", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"archived", "Fix Version Archived", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"released", "Fix Version Released", FieldType.VARCHAR}));
            this.addDeepValueDerivedField(derivedFields, fixVersionsField, groupId);
        }
    }

    private void customerRequestType() {
        ArrayList derivedFields = Lists.newArrayList();
        Field crtField = Fielder.findInFieldsByName("Customer Request Type", this.fields);
        if (crtField != null) {
            crtField.setName("SD Request Type");
            String groupId = "Service Desk";
            crtField.setRaw(true);
            crtField.setReportable(false);
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"requestType.name", "Customer Request Type", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"currentStatus.status", "Request Status", FieldType.VARCHAR}));
            derivedFields.add(Lists.newArrayList((Object[])new Object[]{"currentStatus.statusDate.friendly", "Request Status Date", FieldType.VARCHAR}));
            this.addDeepValueDerivedField(derivedFields, crtField, groupId);
        }
    }

    private void sla() {
        ArrayList slaMillis = Lists.newArrayList();
        for (Field f2 : this.fields) {
            if (!Fielder.isSLA(f2)) continue;
            try {
                f2.setRaw(true);
                f2.setExpression("SLA_VALUE(" + f2.getId() + ",'friendly')");
                Field clone = Fielder.clone(f2);
                clone.setId(clone.getId() + "_millis");
                clone.setName(clone.getName() + " (millis)");
                clone.setDerived(true);
                clone.getDependsOn().add(f2);
                clone.setExpression("SLA_VALUE(" + f2.getId() + ",'millis')");
                clone.setType(FieldType.NUMBER);
                slaMillis.add(clone);
                Field clone2 = Fielder.clone(f2);
                clone2.setId(clone2.getId() + "_target_millis");
                clone2.setName(clone2.getName() + " Target (millis)");
                clone2.setDerived(true);
                clone2.getDependsOn().add(f2);
                clone2.setExpression("SLA_TARGET(" + f2.getId() + ",'millis')");
                clone2.setType(FieldType.NUMBER);
                slaMillis.add(clone2);
            }
            catch (IOException iOException) {}
        }
        this.fields.addAll(slaMillis);
    }

    private void values() {
        for (String key : values.keySet()) {
            Field f2 = Fielder.findInFields(key, this.fields);
            if (f2 == null) continue;
            f2.setExpression(values.get(key));
            f2.setRaw(true);
        }
    }

    private void dependencies() {
        for (Field f2 : this.fields) {
            Field epicLinkField;
            if (!"Epic Name".equals(f2.getName()) || (epicLinkField = Fielder.findInFieldsByName("Epic Link", this.fields)) == null) continue;
            String epicLinkFieldId = epicLinkField.getId();
            f2.getDependsOn().add(Fielder.findInFields(epicLinkFieldId, this.fields));
        }
    }

    private Field newField(JsonNode f2, boolean quickTimesheet) {
        Field field = new Field();
        String id2 = Fielder.id(f2);
        String name = Fielder.name(f2);
        if (names.containsKey(id2)) {
            name = names.get(id2);
        }
        field.setId(id2);
        field.setName(name);
        field.setJiraType(this.jiraType(f2));
        field.setType(this.type(f2));
        if (field.isDate()) {
            field.setPattern("yyyy-MM-dd HH:mm:ss.SSS");
        }
        field.setGroup(this.group(f2));
        if (quickTimesheet && field.isMeasure() && "Custom".equals(field.getGroup())) {
            field.setType(FieldType.VARCHAR);
        }
        field.setReportable(this.reportable(name));
        field.setClauseNames(f2.get("clauseNames"));
        return field;
    }

    private void addDeepValueDerivedField(List<List<Object>> derivedFields, Field parentField, String groupName) {
        for (List<Object> sf : derivedFields) {
            Field f2 = new Field();
            String parentId = parentField.getId();
            String fieldId = TableauSchemaBuilder.derivedFieldId(parentId, sf.get(0).toString());
            f2.setId(fieldId);
            f2.setName(sf.get(1).toString());
            f2.setType((FieldType)((Object)sf.get(2)));
            f2.getDependsOn().add(parentField);
            f2.setGroup(groupName);
            String exp = "DeepValue('" + parentId + "','" + fieldId + "'," + parentId + ")";
            f2.setExpression(exp);
            f2.setDerived(true);
            if (convertToHour.contains(fieldId)) {
                f2.setOperation("/86400");
            }
            if (convertToDay.contains(fieldId)) {
                f2.setOperation("/3600");
            }
            if (f2.isDate()) {
                f2.setPattern("yyyy-MM-dd HH:mm:ss.SSS");
            }
            this.fields.add(f2);
        }
    }

    private FieldType type(JsonNode f2) {
        String jiratype = this.jiraType(f2);
        if (this.isNumber(jiratype)) {
            return FieldType.NUMBER;
        }
        if (this.isDate(jiratype)) {
            return FieldType.TIMESTAMP;
        }
        return FieldType.VARCHAR;
    }

    private boolean isDate(String jiratype) {
        return "date".equalsIgnoreCase(jiratype) || "datetime".equalsIgnoreCase(jiratype);
    }

    private boolean isNumber(String jiratype) {
        return "number".equalsIgnoreCase(jiratype) || "votes".equalsIgnoreCase(jiratype);
    }

    private String jiraType(JsonNode f2) {
        if (f2.has("schema")) {
            String jiratype = JsonUtils.text(f2.get("schema"), "type");
            if ("comments-page".equalsIgnoreCase(jiratype)) {
                return "array";
            }
            if ("sd-servicelevelagreement".equalsIgnoreCase(jiratype)) {
                return "sla";
            }
            return jiratype;
        }
        return "unknown";
    }

    public static Map<String, Object> queryFields(DTO dto) throws JsonProcessingException {
        Field epicLinkField;
        List<Field> fields = dto.getAllFields();
        List<Field> schema = dto.getSchema();
        HashMap out = Maps.newHashMap();
        LinkedHashSet queryFields = Sets.newLinkedHashSet();
        for (Field field : fields) {
            if (!field.isDerived()) {
                queryFields.add(field.getId());
            }
            TableauSchemaBuilder.dependsOnQueryFields(queryFields, field);
        }
        Field epicNameField = Fielder.findInFieldsByName("Epic Name", schema);
        if (epicNameField != null) {
            String epicNameFieldId = epicNameField.getId();
            out.put("epicNameFieldId", epicNameFieldId);
            out.put("fetchEpic", Fielder.containsField(queryFields, epicNameFieldId));
        }
        if ((epicLinkField = Fielder.findInFieldsByName("Epic Link", schema)) != null) {
            String epicLinkFieldId = epicLinkField.getId();
            out.put("epicLinkFieldId", epicLinkFieldId);
            out.put("fetchEpic", Fielder.containsField(queryFields, epicLinkFieldId));
            out.put("epicLinkOnly", epicNameField == null || Fielder.findInFields(epicNameField.getId(), fields) == null);
        }
        Field projectTypeField = Fielder.findInFields(TableauSchemaBuilder.derivedFieldId("project", "projectType"), fields);
        Field projectDescField = Fielder.findInFields(TableauSchemaBuilder.derivedFieldId("project", "projectDesc"), fields);
        Field projectLeadField = Fielder.findInFields(TableauSchemaBuilder.derivedFieldId("project", "projectLead"), fields);
        out.put("fetchProject", projectTypeField != null || projectDescField != null || projectLeadField != null);
        queryFields.add("issuekey");
        queryFields.add("issuetype");
        queryFields.add("parent");
        out.put("queryFields", queryFields);
        out.put("fetchWorklog", Fielder.containsField(queryFields, "worklog"));
        out.put("fetchHistory", Fielder.containsField(queryFields, "changelog"));
        return out;
    }

    private static void dependsOnQueryFields(Set<String> queryFields, Field field) {
        if (field.getDependsOn() != null) {
            for (Field _d : field.getDependsOn()) {
                queryFields.add(_d.getId());
                TableauSchemaBuilder.dependsOnQueryFields(queryFields, _d);
            }
        }
    }

    public static String derivedFieldId(String parentId, String fieldId) {
        return parentId + "_" + fieldId;
    }

    private String group(JsonNode f2) {
        String jiratype = this.jiraType(f2);
        if (this.isDate(jiratype)) {
            return "Dates";
        }
        if (this.isUser(jiratype)) {
            return "Users";
        }
        if (f2.has("name") && JsonUtils.text(f2, "name").startsWith("Epic")) {
            return "Epic";
        }
        if (f2.has("name") && JsonUtils.text(f2, "name").startsWith("Story Points")) {
            return "Story Points";
        }
        if (f2.has("schema") && f2.get("schema").has("custom") && JsonUtils.text(f2.get("schema"), "custom").startsWith("com.thed.zephyr.je")) {
            return "Zephyr";
        }
        if (f2.has("schema") && f2.get("schema").has("custom") && JsonUtils.text(f2.get("schema"), "custom").startsWith("com.atlassian.bonfire.plugin")) {
            return "JIRA Capture";
        }
        if (f2.has("schema") && f2.get("schema").has("custom") && JsonUtils.text(f2.get("schema"), "custom").startsWith("com.atlassian.servicedesk")) {
            return "Service Desk";
        }
        if (f2.has("schema") && f2.get("schema").has("custom") && JsonUtils.text(f2.get("schema"), "custom").startsWith("com.tempoplugin")) {
            return "Tempo";
        }
        if (f2.has("custom") && f2.get("custom").asBoolean()) {
            return "Custom";
        }
        if (this.isCore(f2)) {
            return "Common";
        }
        if (Fielder.id(f2).contains("timeestimate") || Fielder.id(f2).contains("timeoriginalestimate") || Fielder.id(f2).contains("timespent")) {
            return "Issue Effort";
        }
        return "Other";
    }

    private boolean isCore(JsonNode f2) {
        ArrayList coreFields = Lists.newArrayList((Object[])new String[]{"issuekey", "summary", "description", "status", "priority", "issuetype", "labels", "resolution", "fixVersions", "project"});
        return coreFields.contains(Fielder.id(f2));
    }

    private boolean isUser(String jiratype) {
        return "user".equalsIgnoreCase(jiratype);
    }

    private boolean reportable(String name) {
        ArrayList excluded = Lists.newArrayList((Object[])new String[]{"Sprint", "Log Work"});
        return !excluded.contains(name);
    }

    private void operations() {
        for (Field field : this.fields) {
            if (convertToHour.contains(field.getId())) {
                field.setOperation("/3600");
                field.setName(field.getName() + " (hrs)");
            }
            if (!convertToDay.contains(field.getId())) continue;
            field.setOperation("/86400");
            field.setName(field.getName() + " (days)");
        }
    }

    static {
        convertToHour = Lists.newArrayList((Object[])new String[]{"timeoriginalestimate", "timeestimate", "timespent", "aggregatetimeoriginalestimate", "aggregatetimeestimate", "aggregatetimespent", "worklog_timeSpentSeconds", "changelog_status_time", "changelog_assignee_time"});
        convertToDay = Lists.newArrayList((Object[])new String[]{"changelog_status_time_days", "changelog_assignee_time_days"});
        groupExclusion = Maps.newHashMap();
        groupExclusion.put("Service Desk", Lists.newArrayList((Object[])new String[]{"Approvals", "Satisfaction"}));
        groupExclusion.put("Epic", Lists.newArrayList((Object[])new String[]{"Rank", "Epic Color"}));
        values.put("issuelinks", "DeepValue('issuelinks','" + TableauSchemaBuilder.derivedFieldId("issuelinks", "outwardIssue.key||inwardIssue.key") + "', " + "issuelinks" + ")");
        names.put("aggregatetimeoriginalestimate", "Original Estimate (Incl. Sub-tasks)");
        names.put("aggregatetimeestimate", "Remaining Estimate (Incl. Sub-tasks)");
        names.put("aggregatetimespent", "Time Spent (Incl. Sub-tasks)");
    }
}

