/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.service.OAuthService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SearchService {
    public static int PAGESIZE = 100;
    public static int PAGESIZE_Sizing = 10;
    static Logger logger = Logger.getLogger(SearchService.class);
    OAuthService authService = OAuthService.getInstance();

    public List<JsonNode> search(OAuthParams oAuthParams, Set<String> queryFields, String jql, boolean fetchAll, int start, String schedReportId) throws Exception {
        int total = 0;
        int fetched = start;
        ArrayList<JsonNode> results = new ArrayList<JsonNode>();
        do {
            String searchJson = this.buildSearchJson(queryFields, jql, fetched, PAGESIZE);
            String response = this.authService.post(oAuthParams, "/rest/api/latest/search", searchJson);
            JsonNode json = JsonUtils.stringToJsonNode(response);
            JsonNode issuesFetched = json.get("issues");
            fetched += issuesFetched.size();
            Utils.addAll(results, issuesFetched.elements());
            total = json.get("total").asInt();
            if (total <= 0) continue;
            logger.debug((Object)("Progress (" + schedReportId + "): " + fetched + "/" + total + " (" + fetched * 100 / total + "%)"));
        } while (fetchAll && fetched < total);
        return results;
    }

    private String buildSearchJson(Set<String> fieldIds, String jql, int startAt, int pageSize) throws JsonProcessingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startAt", startAt);
        map.put("maxResults", pageSize);
        if (fieldIds.contains("changelog")) {
            map.put("expand", new String[]{"changelog"});
            PAGESIZE = 10;
        } else {
            map.put("expand", new String[]{""});
            PAGESIZE = 100;
        }
        if (StringUtils.hasLength((String)jql)) {
            jql = jql.replace("\\\\", "\\");
            map.put("jql", jql);
        }
        map.put("fields", fieldIds);
        String searchJson = JsonUtils.objectToJsonString(map);
        return searchJson;
    }

    public int size(OAuthParams oAuthParams, String jql) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startAt", 0);
        map.put("maxResults", 0);
        map.put("expand", new String[]{""});
        if (StringUtils.hasLength((String)jql)) {
            jql = jql.replace("\\\\", "\\");
            map.put("jql", jql);
        }
        String searchJson = JsonUtils.objectToJsonString(map);
        String response = this.authService.post(oAuthParams, "/rest/api/latest/search", searchJson);
        JsonNode json = JsonUtils.stringToJsonNode(response);
        return json.get("total").asInt();
    }
}

