/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUserPreferences;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.persistence.UserPreferencesPersistenceService;
import com.kaanha.reports.service.EmailService;
import com.kaanha.reports.service.OfflineReportService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SchedulerService
implements Job,
JobRunner {
    ReportPersistenceService reportPersistenceService;
    OfflineReportService offlineReportService;
    EmailService emailService;
    PlatformTypeEnum platformType;
    TenantPersistenceService tenantPersistenceService;
    UserPersistenceService userPersistenceService;
    static Logger logger = Logger.getLogger(SchedulerService.class);
    ActiveObjects ao;

    @Override
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.platformType = PlatformTypeEnum.CLOUD;
        this.runBatch();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            this.platformType = PlatformTypeEnum.HOSTED;
            this.runBatch();
            return JobRunnerResponse.success();
        }
        catch (JobExecutionException e2) {
            e2.printStackTrace();
            return JobRunnerResponse.failed((String)e2.getMessage());
        }
    }

    private void runBatch() throws JobExecutionException {
        try {
            this.emailService = new EmailService();
            if (PlatformTypeEnum.CLOUD.equals((Object)this.platformType)) {
                PersistenceService.createCloudInstance();
            } else {
                PersistenceService.createHostedInstance(this.ao);
            }
            this.reportPersistenceService = new ReportPersistenceService();
            this.offlineReportService = new OfflineReportService();
            this.tenantPersistenceService = new TenantPersistenceService();
            this.userPersistenceService = new UserPersistenceService();
            Date batchStartTime = new Date();
            String baseUrl = "";
            String addOnKey = "";
            if (PlatformTypeEnum.CLOUD.equals((Object)this.platformType)) {
                baseUrl = Utils.getEnvProperty("aio_jirareports_baseurl");
            } else {
                AioTenant[] tArr = this.tenantPersistenceService.findAll();
                if (tArr != null && tArr.length > 0) {
                    AioTenant t2 = tArr[0];
                    baseUrl = t2.getBaseUrl();
                    addOnKey = t2.getAddOnKey();
                } else {
                    return;
                }
            }
            this.runScheduledReports(batchStartTime, baseUrl, addOnKey);
            this.runDailySummary(batchStartTime, baseUrl, addOnKey);
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new JobExecutionException(e2);
        }
    }

    private void runDailySummary(Date batchStartTime, String baseUrl, String addOnKey) throws Exception {
        AioUserPreferences[] aup;
        logger.debug((Object)"Daily Summary Start");
        UserPreferencesPersistenceService upps = new UserPreferencesPersistenceService();
        for (AioUserPreferences p2 : aup = upps.findByDailySummary()) {
            if (!p2.isDailySummary()) continue;
            try {
                p2 = upps.findById(p2.getID());
                Date localDate = DateUtils.convertToLocal(new Date(), p2.getUser().getTimeZone());
                Date summaryNextSendDate = p2.getSummaryNextSendDate();
                if (!localDate.after(summaryNextSendDate)) continue;
                Date nextSendDate = DateUtils.addDays(summaryNextSendDate, 1);
                p2.setSummaryNextSendDate(nextSendDate);
                p2 = upps.save(p2);
                Date today = localDate;
                DateUtils.setTimeFromDate(summaryNextSendDate, today);
                summaryNextSendDate = today;
                Date startDate = DateUtils.removeTime(summaryNextSendDate);
                Date endDate = DateUtils.addDays(startDate, 1);
                List<AioScheduledReport> myScheduledReports = this.userPersistenceService.getScheduledReports(p2.getUser());
                ArrayList srs = Lists.newArrayList();
                for (AioScheduledReport sr : myScheduledReports) {
                    if ((!sr.getNextSendDate().after(startDate) || !sr.getNextSendDate().before(endDate)) && (sr.getLastSentDate() == null || !sr.getLastSentDate().after(startDate) || !sr.getLastSentDate().before(endDate)) || !this.eligible(sr, batchStartTime, true)) continue;
                    srs.add(sr);
                }
                if (srs.size() <= 0) continue;
                this.offlineReportService.run(srs, this.platformType, null, baseUrl, addOnKey, true, p2.getUser());
            }
            catch (Exception e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        logger.debug((Object)"Daily Summary End");
    }

    private void runScheduledReports(Date batchStartTime, String baseUrl, String addOnKey) throws SQLException {
        logger.debug((Object)"runScheduledReports Start");
        List<AioScheduledReport> reportSchedules = this.reportPersistenceService.getAllReportSchedules();
        if (reportSchedules != null) {
            logger.debug((Object)("Total schedules: " + reportSchedules.size()));
            for (AioScheduledReport reportSchedule : reportSchedules) {
                try {
                    boolean result = this.runSubscription(batchStartTime, reportSchedule, baseUrl, addOnKey, false);
                    reportSchedule = this.reportPersistenceService.findReportSchedule(reportSchedule.getID());
                    if (!result) continue;
                    this.handleSuccess(reportSchedule);
                }
                catch (Exception e2) {
                    this.handleException(reportSchedule, e2);
                }
            }
        }
        logger.debug((Object)"runScheduledReports End");
    }

    private void handleSuccess(AioScheduledReport reportSchedule) throws SQLException {
        reportSchedule.setLastSentDate(new Date());
        reportSchedule.setStatus("SUCCESS");
        reportSchedule.setFailureMessage(null);
        this.reportPersistenceService.save(reportSchedule);
    }

    private void handleException(AioScheduledReport reportSchedule, Exception e2) {
        try {
            reportSchedule = this.reportPersistenceService.findReportSchedule(reportSchedule.getID());
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            reportSchedule.setStatus("FAILED");
            reportSchedule.setLastFailedDate(new Date());
            String failureMessage = this.failureMessage(e2);
            reportSchedule.setFailureMessage(failureMessage);
            this.reportPersistenceService.save(reportSchedule);
            if (PlatformTypeEnum.CLOUD.equals((Object)this.platformType)) {
                try {
                    this.emailService.sendErrorEmail(e2, "ReportScheduleId: " + reportSchedule.getID() + ", Tenant: " + reportSchedule.getReport().getOwner().getTenant().getBaseUrl() + ", failureMessage: " + failureMessage, null);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception ex2) {
            logger.error((Object)ex2.getMessage(), (Throwable)ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSubscription(Date batchStartTime, AioScheduledReport reportSchedule, String baseUrl, String addOnKey, boolean summary) throws Exception {
        boolean eligible = false;
        SchedulerService schedulerService = this;
        synchronized (schedulerService) {
            reportSchedule = this.reportPersistenceService.findReportSchedule(reportSchedule.getID());
            eligible = this.eligible(reportSchedule, batchStartTime, summary);
            if (eligible) {
                reportSchedule.setStatus("RUNNING");
                reportSchedule = this.reportPersistenceService.save(reportSchedule);
                CronExpression cron = new CronExpression(reportSchedule.getCronExpression());
                Date localDate = DateUtils.convertToLocal(new Date(), reportSchedule.getReport().getOwner().getTimeZone());
                Date nextSendDate = DateUtils.convertToUTC(cron.getNextValidTimeAfter(localDate), reportSchedule.getReport().getOwner().getTimeZone());
                reportSchedule.setNextSendDate(nextSendDate);
                reportSchedule = this.reportPersistenceService.save(reportSchedule);
            }
        }
        if (eligible) {
            try {
                if (reportSchedule.getReport().getOwner().getPreferences() != null && reportSchedule.getReport().getOwner().getPreferences().isDailySummary() && reportSchedule.getScheduledReportRecipient().length == 1 && reportSchedule.getScheduledReportRecipient()[0].getRecipient().equals(reportSchedule.getReport().getOwner())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug((Object)("Running: " + reportSchedule.getID()));
            this.offlineReportService.run(Lists.newArrayList((Object[])new AioScheduledReport[]{reportSchedule}), this.platformType, null, baseUrl, addOnKey, false, reportSchedule.getReport().getOwner());
            logger.debug((Object)("Done: " + reportSchedule.getID()));
            return true;
        }
        return false;
    }

    private boolean eligible(AioScheduledReport reportSchedule, Date batchStartTime, boolean summary) throws Exception {
        AioTenant tenant = reportSchedule.getReport().getOwner().getTenant();
        if (PlatformTypeEnum.CLOUD.equals((Object)this.platformType)) {
            boolean validLicense = tenant.getLicenseActive() != false || tenant.getTrialEnd() != null && tenant.getTrialEnd().after(new Date());
            logger.debug((Object)(reportSchedule.getID() + ", " + reportSchedule.getNextSendDate() + ", " + batchStartTime + ", ttr: " + !reportSchedule.getNextSendDate().after(batchStartTime) + ", active: " + validLicense + ", status: " + reportSchedule.getStatus() + ", rc: " + (reportSchedule.getScheduledReportRecipient() == null ? 0 : reportSchedule.getScheduledReportRecipient().length) + ", sen: " + tenant.getServiceEntitlementNumber()));
            if (!validLicense) {
                return false;
            }
        }
        if (!summary) {
            if (reportSchedule.getNextSendDate().after(batchStartTime)) {
                return false;
            }
            if (reportSchedule.getScheduledReportRecipient() == null || reportSchedule.getScheduledReportRecipient().length == 0) {
                return false;
            }
            if ("RUNNING".equalsIgnoreCase(reportSchedule.getStatus())) {
                return false;
            }
        }
        return !"FAILED".equalsIgnoreCase(reportSchedule.getStatus()) || reportSchedule.getReport().getLastModified() != null && !reportSchedule.getReport().getLastModified().before(reportSchedule.getLastFailedDate());
    }

    private String failureMessage(Exception e2) {
        try {
            String message = e2.getMessage();
            boolean known = false;
            if (StringUtils.isBlank((CharSequence)message)) {
                return e2.getClass() + " [Unknown error]";
            }
            if (StringUtils.indexOf((CharSequence)message, (CharSequence)"errorMessages") > -1) {
                try {
                    JsonNode jiraError = JsonUtils.stringToJsonNode(message);
                    message = jiraError.get("errorMessages").toString();
                    known = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            message = StringUtils.replace((String)message, (String)"\"", (String)"'");
            if (known) {
                return message;
            }
            return e2.getClass() + " [" + message + "]";
        }
        catch (Exception x2) {
            logger.error((Object)x2.getMessage(), (Throwable)x2);
            return e2.getMessage();
        }
    }

    public ActiveObjects getAo() {
        return this.ao;
    }

    public void setAo(ActiveObjects ao2) {
        this.ao = ao2;
    }
}

