/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.exception.LicenseExpiredException;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.Grid;
import com.kaanha.reports.model.GridCell;
import com.kaanha.reports.model.HeaderRow;
import com.kaanha.reports.model.MigratableReport;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.EmailService;
import com.kaanha.reports.service.ExportService;
import com.kaanha.reports.service.OfflineReportService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.nimbusds.jose.util.Base64;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;

public class RestService {
    static Logger logger = Logger.getLogger(RestService.class);
    private ReportPersistenceService reportPersistenceService = new ReportPersistenceService();
    private UserPersistenceService userPersistenceService = new UserPersistenceService();
    private TenantPersistenceService tenantPersistenceService = new TenantPersistenceService();

    public void myReports(Map<String, Object> out, UserPersistenceService userService, AioUser user, HttpServletRequest request, PlatformTypeEnum platformType) throws SQLException {
        out.put("myReports", this.JsonReadyReports(Lists.newArrayList((Object[])userService.getSavedReports(user)), request, platformType));
        out.put("reportsSharedWithMe", this.JsonReadyReports(userService.getSharedReports(user), request, platformType));
    }

    public void migrateReports(Map<String, Object> out, UserPersistenceService userService, HttpServletRequest request, PlatformTypeEnum platformType) throws SQLException {
        AioTenant[] ts;
        ArrayList reports = Lists.newArrayList();
        for (AioTenant t2 : ts = this.tenantPersistenceService.findByBaseUrl(request.getParameter("baseUrl"))) {
            AioUser[] users;
            for (AioUser u2 : users = this.userPersistenceService.findByTenant(t2)) {
                AioReport[] savedReports;
                for (AioReport r2 : savedReports = userService.getSavedReports(u2)) {
                    MigratableReport rp = new MigratableReport(r2);
                    reports.add(rp);
                }
            }
        }
        out.put("tenantReports", reports);
    }

    private List<Map<String, Object>> JsonReadyReports(List<AioReport> reports, HttpServletRequest request, PlatformTypeEnum platformType) {
        ArrayList out = Lists.newArrayList();
        for (AioReport r2 : reports) {
            String baseUrl = HttpUtils.getBaseUrl(request);
            if (PlatformTypeEnum.HOSTED.equals((Object)platformType)) {
                baseUrl = baseUrl + "/plugins/servlet";
            }
            HashMap m2 = Maps.newHashMap();
            m2.put("ID", r2.getID());
            m2.put("name", r2.getName());
            m2.put("lastModifiedDate", r2.getLastModified());
            m2.put("type", r2.getType());
            m2.put("excelExportUrl", baseUrl + "/aio/rest/report/export?ID=" + r2.getID() + "&format=excel");
            m2.put("jsonExportUrl", baseUrl + "/aio/rest/report/export?ID=" + r2.getID() + "&format=json");
            out.add(m2);
        }
        return out;
    }

    public String runReport(Map<String, Object> out, UserPersistenceService userService, AioUser user, HttpServletRequest request, HttpServletResponse response, PlatformTypeEnum platformType) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getParameter("ID"))) {
            out.put("message", "Invalid report ID");
            throw new Exception();
        }
        String format = request.getParameter("format");
        if (!(!StringUtils.isNotBlank((CharSequence)format) || "excel".equals(format) || "json".equals(format) || "pdf".equals(format) || "html".equals(format))) {
            out.put("message", "Invalid export format. Allowed values are excel, json and html.");
            throw new Exception();
        }
        OfflineReportService ors = new OfflineReportService();
        AioReport aioReport = this.reportPersistenceService.findByID(Integer.parseInt(request.getParameter("ID")), user);
        Map<String, Object> map = ors.run(aioReport, "API: " + aioReport.getID(), "json".equals(format) || "html".equals(format), platformType, request);
        if ("json".equals(format)) {
            out.put("results", map.get("viewData"));
        } else if ("html".equals(format)) {
            Map results = (Map)map.get("viewData");
            out.put("results", RestService.jsonToHtml(results));
        } else {
            DTO dto = (DTO)map.get("dto");
            ExportService exportService = new ExportService();
            exportService.export(dto, JsonUtils.objectToJsonString(map.get("viewData")));
            HttpUtils.exportToResponse(response, exportService, dto, format);
        }
        return format;
    }

    private static Object jsonToHtml(Map<String, Object> json) {
        Map columnNames = (Map)json.get("columnNames");
        List data = (List)json.get("data");
        StringBuffer out = new StringBuffer();
        out.append("<table>");
        out.append("<tr>");
        for (String columnName : columnNames.values()) {
            out.append("<th>").append(columnName).append("</th>");
        }
        out.append("</tr>");
        for (Map row : data) {
            out.append("<tr>");
            for (Object value : row.values()) {
                out.append("<td>").append(value).append("</td>");
            }
            out.append("</tr>");
        }
        out.append("</table>");
        return out.toString();
    }

    public void process(HttpServletRequest request, HttpServletResponse response, PlatformTypeEnum platformType, UserPersistenceService userService) throws IOException, JsonProcessingException {
        HashMap out = Maps.newHashMap();
        String format = "";
        boolean validAction = false;
        try {
            String action = request.getPathInfo().substring(1);
            if ("migrateReports".equalsIgnoreCase(action)) {
                this.migrateReports(out, userService, request, platformType);
                validAction = true;
            } else {
                String auth;
                String token = request.getParameter("token");
                if (StringUtils.isBlank((CharSequence)token) && StringUtils.startsWith((CharSequence)(auth = request.getHeader("Authorization")), (CharSequence)"Bearer")) {
                    token = auth.substring(7);
                }
                if (StringUtils.isBlank((CharSequence)token)) {
                    out.put("message", "No access token provided");
                    throw new Exception();
                }
                AioUser user = userService.findByRestApiToken(new Base64(token).decodeToString());
                if (user == null) {
                    out.put("message", "Invalid token");
                    throw new Exception();
                }
                if (PlatformTypeEnum.CLOUD.equals((Object)platformType)) {
                    boolean status;
                    AioTenant tenant = user.getTenant();
                    boolean bl2 = status = tenant.getLicenseActive() == null ? true : tenant.getLicenseActive();
                    if (!status && (tenant.getTrialEnd() == null || tenant.getTrialEnd().before(new Date()))) {
                        throw new LicenseExpiredException(tenant.getAddOnKey());
                    }
                }
                if ("myReports".equalsIgnoreCase(action)) {
                    this.myReports(out, userService, user, request, platformType);
                    validAction = true;
                }
                if ("report/export".equalsIgnoreCase(action)) {
                    format = this.runReport(out, userService, user, request, response, platformType);
                    validAction = true;
                }
            }
            if (!validAction) {
                out.put("message", "Invalid AIO Rest API endpoint: " + action);
                throw new Exception();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (!out.containsKey("message")) {
                out.put("message", e2.getMessage());
                try {
                    if (!(e2 instanceof OpenXML4JRuntimeException)) {
                        new EmailService().sendErrorEmail(e2, "Rest API: " + request.getQueryString(), "");
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            out.put("result", "Error");
        }
        if ("json".equals(format)) {
            response.getWriter().print(JsonUtils.objectToJsonString(out.get("results")));
        } else if ("html".equals(format)) {
            response.getWriter().print(out.get("results"));
        } else if (!"excel".equals(format) && !"pdf".equals(format)) {
            response.getWriter().print(JsonUtils.objectToJsonString(out));
        }
    }

    public static Object chartToJson(DTO dto, List<List<Object>> results) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        LinkedHashMap columnNames = Maps.newLinkedHashMap();
        ArrayList lColumnNames = Lists.newArrayList();
        int _i = 0;
        for (Field field : dto.getAllFields()) {
            field.setColumnName("C" + _i);
            lColumnNames.add(field.getColumnName());
            columnNames.put(field.getColumnName(), field.getName());
            ++_i;
        }
        ArrayList data = Lists.newArrayList();
        for (List<Object> row : results) {
            LinkedHashMap m2 = Maps.newLinkedHashMap();
            for (int i2 = 0; i2 < columnNames.size(); ++i2) {
                m2.put(lColumnNames.get(i2), row.get(i2));
            }
            data.add(m2);
        }
        out.put("columnNames", columnNames);
        out.put("data", data);
        return out;
    }

    public static Object gridToJson(DTO dto, Grid grid) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        if (dto.isList()) {
            return RestService.toJsonList(grid);
        }
        return RestService.toJsonMatrix(dto, grid);
    }

    private static Object toJsonMatrix(DTO dto, Grid grid) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        LinkedHashMap jsonMap = Maps.newLinkedHashMap();
        dto = JsonUtils.stringToType(JsonUtils.objectToJsonString(dto), new TypeReference<DTO>(){});
        LinkedHashMap columnNames = Maps.newLinkedHashMap();
        int _i = 0;
        for (Field field : dto.getAllFields()) {
            field.setColumnName("C" + _i);
            columnNames.put(field.getColumnName(), field.getName());
            ++_i;
        }
        jsonMap.put("columnNames", columnNames);
        int rowFieldCount = dto.getRow().size();
        int columnFieldCount = dto.getColumn().size();
        int dataFieldCount = dto.getData().size();
        int effectiveRowFieldCount = rowFieldCount > 1 ? 2 : 1;
        int flatRowsPerMatrixRow = grid.getHeaderRows().get(columnFieldCount - 1).getHeaderCells().size() - effectiveRowFieldCount - 1;
        if (dto.isTimesheet()) {
            flatRowsPerMatrixRow = grid.getHeaderRows().get(0).getHeaderCells().size() - 2;
        }
        ArrayList data = Lists.newArrayList();
        jsonMap.put("data", data);
        for (List<GridCell> dataRow : grid.getDataRows()) {
            for (int i2 = 0; i2 < flatRowsPerMatrixRow; ++i2) {
                int j2;
                LinkedHashMap m2 = Maps.newLinkedHashMap();
                data.add(m2);
                for (j2 = 0; j2 < rowFieldCount; ++j2) {
                    m2.put(dto.getRow().get(j2).getColumnName(), dataRow.get(j2).getV());
                }
                for (j2 = 0; j2 < columnFieldCount; ++j2) {
                    if (dto.isTimesheet()) {
                        m2.put(dto.getColumn().get(j2).getColumnName(), grid.getHeaderRows().get(0).getHeaderCells().get(1 + i2).getV());
                        continue;
                    }
                    int headersSize = grid.getHeaderRows().get(j2).getHeaderCells().size() - effectiveRowFieldCount - 1;
                    int oneValueCatersTo = flatRowsPerMatrixRow / headersSize;
                    m2.put(dto.getColumn().get(j2).getColumnName(), grid.getHeaderRows().get(j2).getHeaderCells().get(effectiveRowFieldCount + i2 / oneValueCatersTo).getV());
                }
                for (j2 = 0; j2 < dataFieldCount; ++j2) {
                    m2.put(dto.getData().get(j2).getColumnName(), dataRow.get(rowFieldCount + (i2 * dataFieldCount + j2)).getV());
                }
            }
        }
        return jsonMap;
    }

    private static Object toJsonList(Grid grid) {
        LinkedHashMap jsonMap = Maps.newLinkedHashMap();
        if (grid.getHeaderRows().size() == 1) {
            LinkedHashMap columnNames = Maps.newLinkedHashMap();
            jsonMap.put("columnNames", columnNames);
            HeaderRow headerRow = grid.getHeaderRows().get(0);
            int i2 = 0;
            for (GridCell gc2 : headerRow.getHeaderCells()) {
                columnNames.put("C" + i2, gc2.getV());
                ++i2;
            }
            ArrayList dataVals = Lists.newArrayList();
            jsonMap.put("data", dataVals);
            for (List<GridCell> dataRow : grid.getDataRows()) {
                RestService.addListData(dataVals, dataRow);
            }
            dataVals = Lists.newArrayList();
            jsonMap.put("footer", dataVals);
            RestService.addListData(dataVals, grid.getFooterRow());
        }
        return jsonMap;
    }

    private static void addListData(List<Map<Object, Object>> dataVals, List<GridCell> dataRow) {
        LinkedHashMap dataValRow = Maps.newLinkedHashMap();
        dataVals.add(dataValRow);
        int i2 = 0;
        for (GridCell gc2 : dataRow) {
            dataValRow.put("C" + i2, gc2.getV());
            ++i2;
        }
    }
}

