/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.CompositeCrosstabKey;
import com.kaanha.reports.model.CrosstabKey;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.DataSet;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.Grid;
import com.kaanha.reports.model.GridCell;
import com.kaanha.reports.model.HeaderRow;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.service.CrosstabKeyComparator;
import com.kaanha.reports.service.DBEngine;
import com.kaanha.reports.service.FieldValueComparator;
import com.kaanha.reports.service.Normalizer;
import com.kaanha.reports.service.OfflineReportService;
import com.kaanha.reports.service.RestService;
import com.kaanha.reports.service.TrendReportingService;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ReportingService {
    DBEngine dbEngine = DBEngine.getInstance();
    static Logger logger = Logger.getLogger(ReportingService.class);

    public Map<String, Object> process(DTO dto, boolean jsonOnly, AioUser loggedInUser) throws Exception {
        if (dto.isTrend()) {
            dto.setQueryFields(new TrendReportingService().getQueryFields(dto));
        }
        DataSet dataSet = Normalizer.extract(dto, loggedInUser);
        try {
            OfflineReportService.setReportStartEndDates(dto);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String datamartID = this.dbEngine.createMartNew(dataSet, dto);
        Object output = this.createOutput(datamartID, dto, jsonOnly);
        HashMap out = Maps.newHashMap();
        out.put("dto", dto);
        out.put("viewData", output);
        this.dbEngine.dropMart(datamartID);
        return out;
    }

    private Object createOutput(String datamartID, DTO dto, boolean jsonOnly) throws Exception {
        ArrayList dataFields;
        if (jsonOnly) {
            this.removeGrouping(dto);
        }
        Object out = dto;
        if (dto.isList()) {
            out = this.createTable(datamartID, dto);
        }
        if (dto.isCrosstab()) {
            out = this.createMatrix(datamartID, dto);
        }
        if (dto.isTimesheet()) {
            out = this.createTimesheet(datamartID, dto);
        }
        if (dto.isBar() || dto.isLine() || dto.isPie()) {
            if (dto.getColumn().size() > 0) {
                ArrayList o2 = Lists.newArrayList();
                dataFields = dto.getData();
                for (Object dataField : dataFields) {
                    dto.setData(Lists.newArrayList((Object[])new Field[]{dataField}));
                    Grid grid = this.createMatrix(datamartID, dto);
                    o2.add(this.convertGridToChart(dto, grid));
                }
                HashMap m2 = Maps.newHashMap();
                m2.put("dataFields", dataFields);
                m2.put("chartData", o2);
                out = m2;
            } else {
                out = this.createChart(datamartID, dto);
            }
        }
        if (dto.isTrend()) {
            Grid grid = this.createTrendMatrix(datamartID, dto);
            if ("table".equalsIgnoreCase(dto.getTrendOutputFormat())) {
                HeaderRow intervalHeader = grid.getHeaderRows().get(0);
                boolean first = true;
                for (GridCell cell : intervalHeader.getHeaderCells()) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    String _interval = cell.getV().toString();
                    cell.setV(_interval.substring(_interval.indexOf(":") + 1));
                }
                out = grid;
            } else {
                dataFields = Lists.newArrayList();
                dataFields.addAll(dto.getData());
                ArrayList o3 = Lists.newArrayList();
                o3.add(this.convertTrendGridToChart(dto, grid));
                HashMap m3 = Maps.newHashMap();
                m3.put("dataFields", dataFields);
                m3.put("chartData", o3);
                out = m3;
            }
        }
        if (jsonOnly) {
            if (out instanceof Grid) {
                return RestService.gridToJson(dto, (Grid)out);
            }
            return RestService.chartToJson(dto, out);
        }
        return out;
    }

    private Grid createTable(String datamartID, DTO dto) throws Exception {
        Grid grid = new Grid();
        List<Field> groupByFields = this.findGroupByFields(dto);
        HeaderRow headerRow = new HeaderRow();
        for (Field f2 : dto.getAllFields()) {
            if (f2.isGroupBy()) continue;
            GridCell headerCell = new GridCell();
            headerCell.setV(Fielder.fieldLabel(f2));
            headerRow.addHeaderCell(headerCell);
        }
        grid.addHeaderRow(headerRow);
        if (groupByFields.size() > 0) {
            List<List<Object>> groupByValues = this.findAndSortGroupByValues(datamartID, dto, groupByFields);
            List<Object> previousGroupByValue = null;
            for (List<Object> groupByValue : groupByValues) {
                this.addTableGroup(datamartID, dto, grid, groupByFields, groupByValue, previousGroupByValue);
                this.addTableDataRows(datamartID, dto, grid, groupByFields.size());
                previousGroupByValue = groupByValue;
            }
        } else {
            this.addTableDataRows(datamartID, dto, grid, groupByFields.size());
        }
        this.addTableGrandTotal(datamartID, dto, grid, groupByFields);
        return grid;
    }

    private Grid createMatrix(String datamartID, DTO dto) throws Exception {
        List<CrosstabKey> columnKeys = this.dbEngine.queryMartForCrosstabColumns(datamartID, dto);
        Collections.sort(columnKeys, new CrosstabKeyComparator(dto.getColumn()));
        return this.createMergedMatrix(datamartID, dto, columnKeys);
    }

    private Grid createTimesheet(String datamartID, DTO dto) throws Exception {
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        Set<Date> allDates = DateUtils.datesBetween(startDate, endDate);
        LinkedHashSet columnKeys = Sets.newLinkedHashSet();
        for (Date date : allDates) {
            CrosstabKey columnKey = new CrosstabKey();
            columnKey.addValue(DateUtils.format(date, dto.getColumn().get(0).getPattern()));
            columnKeys.add(columnKey);
        }
        return this.createMergedMatrix(datamartID, dto, Lists.newArrayList((Iterable)columnKeys));
    }

    private List<List<Object>> createChart(String datamartID, DTO dto) throws Exception {
        List<List<Object>> results = this.dbEngine.queryMartForList(datamartID, dto);
        Field rowField = dto.getRow().get(0);
        Collections.sort(results, new FieldValueComparator(rowField, dto.getPriorities()));
        return results;
    }

    private Grid createMergedMatrix(String datamartID, DTO dto, List<CrosstabKey> columnKeys) throws Exception {
        return this.createMergedMatrix(datamartID, dto, columnKeys, null);
    }

    private Grid createMergedMatrix(String datamartID, DTO dto, List<CrosstabKey> columnKeys, List<CrosstabKey> rowKeys) throws Exception {
        boolean queryRowKeys = rowKeys == null;
        List<Field> groupByFields = this.findGroupByFields(dto);
        Grid grid = new Grid();
        ArrayList timesheetDays = Lists.newArrayList();
        this.addMatrixHeader(dto, grid, columnKeys, timesheetDays, groupByFields.size());
        if (groupByFields.size() > 0) {
            List<List<Object>> groupByValues = this.findAndSortGroupByValues(datamartID, dto, groupByFields);
            List<Object> previousGroupByValue = null;
            for (List<Object> groupByValue : groupByValues) {
                this.addMatrixGroup(datamartID, dto, grid, groupByFields, columnKeys, groupByValue, previousGroupByValue);
                if (queryRowKeys) {
                    rowKeys = this.dbEngine.queryMartForCrosstabRows(datamartID, dto);
                }
                this.createSingleMatrix(datamartID, dto, grid, columnKeys, rowKeys, groupByFields, timesheetDays);
                previousGroupByValue = groupByValue;
            }
        } else {
            if (queryRowKeys) {
                rowKeys = this.dbEngine.queryMartForCrosstabRows(datamartID, dto);
            }
            this.createSingleMatrix(datamartID, dto, grid, columnKeys, rowKeys, groupByFields, timesheetDays);
        }
        if (Utils.isGrid(dto)) {
            this.addMatrixGrandTotal(datamartID, dto, grid, groupByFields, columnKeys);
        }
        return grid;
    }

    private Grid createSingleMatrix(String datamartID, DTO dto, Grid grid, List<CrosstabKey> columnKeys, List<CrosstabKey> rowKeys, List<Field> groupByFields, List<Boolean> timesheetDays) throws Exception, ParseException {
        Map<CompositeCrosstabKey, List<Object>> dataTable = this.dbEngine.queryMartForCrosstabData(datamartID, dto);
        Map<CrosstabKey, List<Object>> totalsData = null;
        if (Utils.isGrid(dto)) {
            List<List<Object>> rowTotals = this.dbEngine.queryMartForTotals(datamartID, dto, "ROW");
            totalsData = this.totalsToKey(rowTotals, dto.getRow().size(), dto.getData().size());
        }
        for (CrosstabKey rowKey : rowKeys) {
            ArrayList dataRow = Lists.newArrayList();
            boolean first = true;
            int index = 0;
            for (String value : rowKey.values()) {
                if (!dto.getRow().get(index).isGroupBy()) {
                    GridCell rowValCell = new GridCell(value);
                    if (groupByFields.size() > 0 && first) {
                        rowValCell.setS(Utils.indexedStyle("aio-idt", groupByFields.size() + 1));
                        first = false;
                    }
                    dataRow.add(rowValCell);
                }
                ++index;
            }
            index = 0;
            for (CrosstabKey columnKey : columnKeys) {
                CompositeCrosstabKey cck = new CompositeCrosstabKey();
                cck.setColumnKey(columnKey);
                cck.setRowKey(rowKey);
                ArrayList values = Lists.newArrayList();
                if (dataTable.containsKey(cck)) {
                    for (Object obj : dataTable.get(cck)) {
                        Double doubleValue = obj == null ? 0.0 : Double.valueOf(obj.toString());
                        values.add(new GridCell(doubleValue));
                    }
                } else {
                    for (int i2 = 0; i2 < dto.getData().size(); ++i2) {
                        values.add(new GridCell("-"));
                    }
                }
                if (dto.isTimesheet()) {
                    for (GridCell o2 : values) {
                        if (timesheetDays.get(index).booleanValue()) {
                            o2.setS(ReportingService.styleWeekendData());
                            continue;
                        }
                        o2.setS("ts-data");
                    }
                }
                ++index;
                dataRow.addAll(values);
            }
            if (Utils.isGrid(dto) && totalsData.containsKey(rowKey)) {
                for (Object rowTotal : totalsData.get(rowKey)) {
                    GridCell c2 = new GridCell(rowTotal);
                    c2.setS("aio-total");
                    dataRow.add(c2);
                }
            }
            grid.addDataRow(dataRow);
        }
        return grid;
    }

    private Grid createTrendMatrix(String datamartID, DTO dto) throws Exception {
        CrosstabKey columnKey;
        Field columnField = dto.getColumn().get(0);
        ArrayList keys1 = Lists.newArrayList();
        ArrayList keys2 = Lists.newArrayList();
        TrendReportingService trs = new TrendReportingService();
        List<String> intervals = trs.getIntervals(dto);
        for (String string : intervals) {
            columnKey = new CrosstabKey();
            columnKey.addValue(string);
            keys1.add(columnKey);
        }
        if (dto.isBreakByIssueType()) {
            List<String> issueTypes = dto.getIssueTypes();
            Collections.sort(issueTypes);
            for (String value : dto.getTrendValues()) {
                for (String issueType : issueTypes) {
                    CrosstabKey columnKey2 = new CrosstabKey();
                    columnKey2.addValue(value);
                    columnKey2.addValue(issueType);
                    keys2.add(columnKey2);
                }
            }
        } else {
            for (String string : dto.getTrendValues()) {
                columnKey = new CrosstabKey();
                columnKey.addValue(string);
                keys2.add(columnKey);
            }
        }
        if (columnField.getId().equals("aio_interval")) {
            return this.createMergedMatrix(datamartID, dto, keys1, keys2);
        }
        return this.createMergedMatrix(datamartID, dto, keys2, keys1);
    }

    private List<List<Object>> convertTrendGridToChart(DTO dto, Grid grid) {
        TrendReportingService.trendValuesToData(dto);
        return this.convertMatrixToChart(dto, grid);
    }

    private List<List<Object>> convertGridToChart(DTO dto, Grid grid) {
        this.matrixColumnValuesToData(dto, grid);
        return this.convertMatrixToChart(dto, grid);
    }

    private List<List<Object>> convertMatrixToChart(DTO dto, Grid grid) {
        ArrayList out = Lists.newArrayList();
        for (List<GridCell> dataRow : grid.getDataRows()) {
            List<String> row = Lists.newArrayList();
            for (GridCell cell : dataRow) {
                row.add((String)cell.getV());
            }
            out.add(row);
        }
        Field rowField = dto.getRow().get(0);
        Collections.sort(out, new FieldValueComparator(rowField, dto.getPriorities()));
        for (List<String> row : out) {
            String _interval = row.get(0).toString();
            row.set(0, _interval.substring(_interval.indexOf(":") + 1));
        }
        return out;
    }

    private void addTableGroup(String datamartID, DTO dto, Grid grid, List<Field> groupByFields, List<Object> groupByValue, List<Object> previousGroupByValue) throws Exception {
        this.resetGroupByFieldsFilter(groupByFields);
        boolean doNotCheck = false;
        for (int i2 = 0; i2 < groupByFields.size(); ++i2) {
            Field groupByField = groupByFields.get(i2);
            this.setFilterForGroupByField(groupByField, groupByValue.get(i2).toString());
            if (!doNotCheck && previousGroupByValue != null && previousGroupByValue.get(i2).equals(groupByValue.get(i2))) continue;
            doNotCheck = true;
            ArrayList gridDataRow = Lists.newArrayList();
            GridCell dataCell = new GridCell(groupByField.getName() + ": " + groupByValue.get(i2));
            dataCell.setS("aio-gh " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("aio-idt", i2));
            gridDataRow.add(dataCell);
            grid.addDataRow(gridDataRow);
            List<List<Object>> results = this.dbEngine.queryMartForTotals(datamartID, dto, null);
            for (List<Object> rowData : results) {
                for (Object obj : rowData) {
                    dataCell = new GridCell(obj);
                    dataCell.setS("aio-total " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("X", i2));
                    gridDataRow.add(dataCell);
                }
            }
        }
    }

    private void addMatrixGroup(String datamartID, DTO dto, Grid grid, List<Field> groupByFields, List<CrosstabKey> columnKeys, List<Object> groupByValue, List<Object> previousGroupByValue) throws Exception {
        this.resetGroupByFieldsFilter(groupByFields);
        boolean doNotCheck = false;
        for (int i2 = 0; i2 < groupByFields.size(); ++i2) {
            Field groupByField = groupByFields.get(i2);
            this.setFilterForGroupByField(groupByField, groupByValue.get(i2).toString());
            if (!doNotCheck && previousGroupByValue != null && previousGroupByValue.get(i2).equals(groupByValue.get(i2))) continue;
            doNotCheck = true;
            ArrayList gridDataRow = Lists.newArrayList();
            GridCell dataCell = new GridCell(groupByField.getName() + ": " + groupByValue.get(i2));
            dataCell.setW(dto.getRow().size() - groupByFields.size());
            dataCell.setS("aio-gh " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("aio-idt", i2));
            gridDataRow.add(dataCell);
            grid.addDataRow(gridDataRow);
            this.matrixColumnTotal(datamartID, dto, columnKeys, gridDataRow);
            for (GridCell c2 : gridDataRow) {
                if (!StringUtils.isBlank((CharSequence)c2.getS())) continue;
                c2.setS("aio-total " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("X", i2));
            }
        }
    }

    private void addTableDataRows(String datamartID, DTO dto, Grid grid, int countOfGroupFields) throws Exception {
        List<Map<String, Object>> results = this.dbEngine.queryMartForMap(datamartID, dto);
        for (Map<String, Object> rowData : results) {
            ArrayList gridDataRow = Lists.newArrayList();
            boolean first = true;
            for (Field f2 : dto.getAllFields()) {
                if (f2.isGroupBy()) continue;
                GridCell dataCell = new GridCell(rowData.get(f2.getColumnName()));
                if (countOfGroupFields > 0 && first) {
                    dataCell.setS(Utils.indexedStyle("aio-idt", countOfGroupFields));
                    first = false;
                }
                gridDataRow.add(dataCell);
            }
            grid.addDataRow(gridDataRow);
        }
    }

    private void addTableGrandTotal(String datamartID, DTO dto, Grid grid, List<Field> groupByFields) throws Exception {
        this.resetGroupByFieldsFilter(groupByFields);
        ArrayList grandTotalRow = Lists.newArrayList();
        GridCell total = new GridCell("Total");
        grandTotalRow.add(total);
        List<List<Object>> results = this.dbEngine.queryMartForTotals(datamartID, dto, null);
        for (List<Object> rowData : results) {
            for (Object obj : rowData) {
                GridCell dataCell = new GridCell(obj);
                grandTotalRow.add(dataCell);
            }
        }
        for (GridCell c2 : grandTotalRow) {
            c2.setS("aio-total");
        }
        grid.setFooterRow(grandTotalRow);
    }

    private void addMatrixGrandTotal(String datamartID, DTO dto, Grid grid, List<Field> groupByFields, List<CrosstabKey> columnKeys) throws Exception {
        this.resetGroupByFieldsFilter(groupByFields);
        ArrayList grandTotalRow = Lists.newArrayList();
        GridCell total = new GridCell("Total");
        total.setW(dto.getRow().size() - groupByFields.size());
        grandTotalRow.add(total);
        this.matrixColumnTotal(datamartID, dto, columnKeys, grandTotalRow);
        for (GridCell c2 : grandTotalRow) {
            c2.setS("aio-total");
        }
        grid.setFooterRow(grandTotalRow);
    }

    private void matrixColumnTotal(String datamartID, DTO dto, List<CrosstabKey> columnKeys, List<GridCell> gridDataRow) throws JsonParseException, JsonMappingException, ParseException, IOException, Exception {
        GridCell cell;
        List<List<Object>> results = this.dbEngine.queryMartForTotals(datamartID, dto, "COLUMN");
        Map<CrosstabKey, List<Object>> totalsData = this.totalsToKey(results, dto.getColumn().size(), dto.getData().size());
        for (CrosstabKey crosstabKey : columnKeys) {
            ArrayList l2 = null;
            l2 = totalsData.containsKey(crosstabKey) ? totalsData.get(crosstabKey) : Lists.newArrayList(Collections.nCopies(dto.getData().size(), "-"));
            for (int a2 = 0; a2 < dto.getData().size(); ++a2) {
                cell = new GridCell(l2.get(a2));
                gridDataRow.add(cell);
            }
        }
        results = this.dbEngine.queryMartForTotals(datamartID, dto, "GROUP");
        for (List list : results) {
            for (Object obj : list) {
                cell = new GridCell(obj);
                gridDataRow.add(cell);
            }
        }
    }

    private Map<CrosstabKey, List<Object>> totalsToKey(List<List<Object>> results, int keySize, int dataSize) throws JsonParseException, JsonMappingException, ParseException, IOException, Exception {
        HashMap totalsData = Maps.newHashMap();
        for (List<Object> resultsRow : results) {
            CrosstabKey key = new CrosstabKey();
            for (int a2 = 0; a2 < keySize; ++a2) {
                key.addValue(resultsRow.get(a2) == null ? null : resultsRow.get(a2).toString());
            }
            for (int a3 = 0; a3 < dataSize; ++a3) {
                List<Object> dataValues;
                if (totalsData.containsKey(key)) {
                    dataValues = (List)totalsData.get(key);
                } else {
                    dataValues = Lists.newArrayList();
                    totalsData.put(key, dataValues);
                }
                dataValues.add(resultsRow.get(keySize + a3));
            }
        }
        return totalsData;
    }

    private List<List<Object>> findAndSortGroupByValues(String datamartID, DTO dto, List<Field> groupByFields) throws Exception {
        List<List<Object>> groupByValues = this.dbEngine.queryMartForUniqueValues(datamartID, dto, groupByFields);
        for (int i2 = groupByFields.size() - 1; i2 >= 0; --i2) {
            Field _f = groupByFields.get(i2);
            int dir = "down".equals(_f.getSortDir()) ? -1 : 1;
            Collections.sort(groupByValues, new FieldValueComparator(_f, i2, dir, dto.getPriorities()));
        }
        return groupByValues;
    }

    private void addMatrixHeader(DTO dto, Grid grid, List<CrosstabKey> columnKeys, List<Boolean> timesheetDays, int countOfGroupByFields) throws ParseException {
        for (int i2 = 0; i2 < dto.getColumn().size(); ++i2) {
            HeaderRow headerRow = new HeaderRow();
            GridCell headerCell = new GridCell();
            if (dto.isTimesheet()) {
                headerCell.setV("Timesheet Period: " + DateUtils.convertFormat(dto.getStartDate(), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "MMM dd, yyyy") + " to " + DateUtils.convertFormat(dto.getEndDate(), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "MMM dd, yyyy"));
                headerCell.setW(dto.getRow().size() - countOfGroupByFields);
                headerCell.setS("aio-total");
            } else {
                if (dto.getRow().size() - countOfGroupByFields > 1) {
                    GridCell cell = new GridCell();
                    cell.setW(dto.getRow().size() - countOfGroupByFields - 1);
                    headerRow.addHeaderCell(cell);
                }
                headerCell.setV(Fielder.fieldLabel(dto.getColumn().get(i2)));
            }
            headerRow.addHeaderCell(headerCell);
            Object previousValue = null;
            int reps = 0;
            for (CrosstabKey colKey : columnKeys) {
                String value = colKey.getValue(i2);
                if (previousValue == null || !value.equals(previousValue)) {
                    reps = 0;
                    if (dto.isTimesheet()) {
                        headerCell = new GridCell(DateUtils.getTimesheetDate(value, dto.getColumn().get(0).getPattern(), dto.getStartDate()));
                        if (DateUtils.isWeekend(DateUtils.getTimesheetDay(value, dto.getColumn().get(0).getPattern(), dto.getEndDate(), dto.getStartDate()))) {
                            headerCell.setS(ReportingService.styleWeekendHeader());
                        } else {
                            headerCell.setS("ts-header");
                        }
                    } else {
                        headerCell = new GridCell(value);
                    }
                    previousValue = value;
                    headerRow.addHeaderCell(headerCell);
                }
                headerCell.setW(++reps * dto.getData().size());
            }
            if (Utils.isGrid(dto)) {
                GridCell totalHeader = new GridCell(i2 == dto.getColumn().size() - 1 ? "Total" : "");
                totalHeader.setW(dto.getData().size());
                totalHeader.setS("aio-total");
                headerRow.addHeaderCell(totalHeader);
            }
            grid.addHeaderRow(headerRow);
        }
        HeaderRow headerRow = new HeaderRow();
        for (Field f2 : dto.getRow()) {
            if (f2.isGroupBy()) continue;
            headerRow.addHeaderCell(new GridCell(Fielder.fieldLabel(f2)));
        }
        for (CrosstabKey colKey : columnKeys) {
            for (Field f3 : dto.getData()) {
                if (dto.isTimesheet()) {
                    String day = DateUtils.getTimesheetDay(colKey.getValue(0), dto.getColumn().get(0).getPattern(), dto.getEndDate(), dto.getStartDate());
                    GridCell headerCell = new GridCell(day);
                    if (DateUtils.isWeekend(day)) {
                        timesheetDays.add(true);
                        headerCell.setS(ReportingService.styleWeekendHeader());
                    } else {
                        timesheetDays.add(false);
                        headerCell.setS("ts-header");
                    }
                    headerRow.addHeaderCell(headerCell);
                    continue;
                }
                headerRow.addHeaderCell(new GridCell(Fielder.fieldLabel(f3)));
            }
        }
        for (Field f2 : dto.getData()) {
            GridCell headerCell = new GridCell(Fielder.fieldLabel(f2));
            if (dto.isTimesheet()) {
                headerCell.setV("Hours");
            }
            headerCell.setS("aio-total");
            headerRow.addHeaderCell(headerCell);
        }
        grid.addHeaderRow(headerRow);
    }

    private void resetGroupByFieldsFilter(List<Field> groupByFields) {
        for (Field groupByField : groupByFields) {
            groupByField.setFilterValue(null);
        }
    }

    private List<Field> findGroupByFields(DTO dto) {
        ArrayList groupByFields = Lists.newArrayList();
        for (Field f2 : dto.getRow()) {
            if (!f2.isGroupBy()) continue;
            groupByFields.add(f2);
        }
        for (Field f2 : dto.getColumn()) {
            if (!f2.isGroupBy()) continue;
            groupByFields.add(f2);
        }
        return groupByFields;
    }

    private void setFilterForGroupByField(Field groupByField, String groupByValue) throws JsonProcessingException {
        HashMap filter = Maps.newHashMap();
        filter.put("condition", "AND");
        ArrayList rules = Lists.newArrayList();
        HashMap m2 = Maps.newHashMap();
        m2.put("id", "filter_" + groupByField.getId());
        m2.put("operator", "equal");
        m2.put("value", groupByValue);
        m2.put("groupBy", true);
        rules.add(m2);
        filter.put("rules", rules);
        groupByField.setFilterValue(JsonUtils.objectToJsonString(filter));
    }

    private void matrixColumnValuesToData(DTO dto, Grid grid) {
        dto.getData().clear();
        List<GridCell> headerCells = grid.getHeaderRows().get(0).getHeaderCells();
        for (int i2 = 1; i2 < headerCells.size(); ++i2) {
            Field f2 = new Field();
            f2.setName(headerCells.get(i2).getV().toString());
            dto.getData().add(f2);
        }
    }

    private void removeGrouping(DTO dto) {
        for (Field f2 : dto.getRow()) {
            f2.setGroupBy(false);
        }
    }

    public static String styleWeekendData() {
        return "ts-data ts-weekend";
    }

    public static String styleWeekendHeader() {
        return "ts-header ts-weekend";
    }
}

