/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.kaanha.reports.helper.ResourceLoader;
import com.kaanha.reports.helper.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.stereotype.Service;

@Service
public class ProtectedConfigFile {
    Key aesKey;

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        SecretKey key = kgen.generateKey();
        byte[] encoded = key.getEncoded();
        FileOutputStream output = new FileOutputStream(new File(args[0]));
        output.write(encoded);
        output.close();
    }

    public ProtectedConfigFile() throws Exception {
        byte[] b2 = new byte[16];
        FileInputStream f2 = null;
        try {
            f2 = new FileInputStream(Utils.getEnvProperty("JIRA_REPORTS_KEY"));
            f2.read(b2);
            f2.close();
        }
        catch (Exception e2) {
            ResourceLoader.getClasspathResourceInputStream("jirareportskey").read(b2);
        }
        this.aesKey = new SecretKeySpec(b2, "AES");
    }

    public byte[] encrypt(String text) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.aesKey);
        return cipher.doFinal(text.getBytes());
    }

    public String decrypt(byte[] bytes) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, this.aesKey);
        return new String(cipher.doFinal(bytes));
    }
}

