/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.FilterType;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.EmailService;
import com.kaanha.reports.service.ExportService;
import com.kaanha.reports.service.OAuthService;
import com.kaanha.reports.service.ReportingService;
import com.kaanha.reports.service.SchemaBuilder;
import com.kaanha.reports.service.SearchService;
import com.kaanha.reports.service.TrendReportingService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class OfflineReportService {
    OAuthService authService = OAuthService.getInstance();
    UserPersistenceService userPersistenceService = new UserPersistenceService();
    ReportPersistenceService reportPersistenceService = new ReportPersistenceService();
    SearchService searchService = new SearchService();
    ReportingService reportingService = new ReportingService();
    EmailService emailService = new EmailService();
    TrendReportingService trendReportingService = new TrendReportingService();
    TenantPersistenceService tenantPersistenceService = new TenantPersistenceService();
    static Logger logger = Logger.getLogger(OfflineReportService.class);

    public void run(List<AioScheduledReport> reportSchedules, PlatformTypeEnum platformType, HttpServletRequest request, String baseUrl, String addOnKey, boolean summary, AioUser summaryRecipient) throws Exception {
        ArrayList dtos = Lists.newArrayList();
        ArrayList resultss = Lists.newArrayList();
        String emailUrlPrefix = baseUrl;
        emailUrlPrefix = PlatformTypeEnum.HOSTED.equals((Object)platformType) ? ("com.kaanha.reports".equals(addOnKey) ? baseUrl + "/plugins/servlet/aio/public" : baseUrl + "/plugins/servlet/aio-ts/public") : baseUrl + "/aio/public";
        for (AioScheduledReport reportSchedule : reportSchedules) {
            try {
                AioReport report = reportSchedule.getReport();
                String debugID = "Schedule: " + reportSchedule.getID();
                Map<String, Object> out = this.run(report, debugID, false, platformType, request);
                String results = JsonUtils.objectToJsonString(out.get("viewData"));
                DTO dto = (DTO)out.get("dto");
                if (summary) {
                    resultss.add(results);
                    dtos.add(dto);
                    continue;
                }
                this.emailSingleReport(reportSchedule, results, dto, emailUrlPrefix);
            }
            catch (Exception e2) {
                if (summary) continue;
                throw e2;
            }
        }
        if (summary && dtos.size() > 0) {
            this.emailSummaryReport(dtos, resultss, summaryRecipient);
        }
    }

    private void emailSummaryReport(List<DTO> dtos, List<String> resultss, AioUser summaryRecipient) throws Exception {
        ExportService exportService = new ExportService();
        exportService.export(dtos, resultss);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        exportService.writeFileToOutputStream(boas, "xlsx");
        byte[] byteArray = boas.toByteArray();
        String attachmentName = Utils.generateExportFileName("Daily Summary " + DateUtils.format(new Date(), "MMM-dd-yyyy"), "xlsx");
        try {
            this.emailService.sendSubscriptionEmail(summaryRecipient, summaryRecipient, attachmentName, byteArray, null, null, false, null);
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private void emailSingleReport(AioScheduledReport reportSchedule, String results, DTO dto, String emailUrlPrefix) throws Exception {
        String format = "xlsx";
        AioReport report = reportSchedule.getReport();
        ExportService exportService = new ExportService();
        exportService.export(dto, results);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        exportService.writeFileToOutputStream(boas, format);
        byte[] byteArray = boas.toByteArray();
        if (reportSchedule.isPublish()) {
            this.reportPersistenceService.publish(report.getID(), results, report.getOwner());
            report = this.reportPersistenceService.findByID(report.getID(), report.getOwner());
        }
        String attachmentName = Utils.generateExportFileName(report.getName(), format);
        for (AioSchedRepRcpt sharedReportRecipient : reportSchedule.getScheduledReportRecipient()) {
            ArrayList recipients = Lists.newArrayList();
            if (sharedReportRecipient.getTeam() != null) {
                for (AioTeamMember tm : sharedReportRecipient.getTeam().getMembers()) {
                    recipients.add(tm.getUser());
                }
            } else {
                recipients.add(sharedReportRecipient.getRecipient());
            }
            for (AioUser recipient : recipients) {
                try {
                    if (reportSchedule.getReport().getOwner().getPreferences() != null && reportSchedule.getReport().getOwner().getPreferences().isDailySummary() && recipient.equals(reportSchedule.getReport().getOwner())) continue;
                    this.emailService.sendSubscriptionEmail(report.getOwner(), recipient, attachmentName, byteArray, sharedReportRecipient.getUnsubscribeLink(), report.getPublishedLink(), reportSchedule.isPublish(), emailUrlPrefix);
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    public Map<String, Object> run(AioReport report, String debugID, boolean jsonOnly, PlatformTypeEnum platformType, HttpServletRequest request) throws Exception, ParseException, JsonParseException, JsonMappingException, IOException, JsonProcessingException {
        AioUser user = report.getOwner();
        OAuthParams oAuthParams = OAuthParams.build(platformType, request, user, null);
        this.authService.login(oAuthParams);
        Map<String, Object> schemaMap = this.buildSchema(oAuthParams);
        List schema = (List)schemaMap.get("schema");
        Map priorities = (Map)schemaMap.get("priorities");
        DTO dto = this.reportPersistenceService.convertAioReportToDto(report, user, schema);
        dto.setSchema(schema);
        dto.setTimezone(user.getTimeZone());
        dto.setPriorities(priorities);
        if (PlatformTypeEnum.CLOUD.equals((Object)platformType)) {
            dto.setJiraBaseUrl(user.getTenant().getBaseUrl());
        } else {
            dto.setJiraBaseUrl(this.tenantPersistenceService.findAll()[0].getBaseUrl());
        }
        String jql = this.buildJql(oAuthParams, dto);
        if (dto.isTrend()) {
            int grandTotal = this.searchService.size(oAuthParams, jql);
            dto.setIssues(Lists.newArrayList());
            List<List<Object>> trendJqls = this.trendReportingService.trendJqls(dto);
            for (List<Object> trendJql : trendJqls) {
                String _jql = trendJql.get(0).toString();
                Map _issue = (Map)trendJql.get(1);
                if (StringUtils.isNotBlank((CharSequence)jql)) {
                    _jql = "(" + jql + ") and (" + _jql + ")";
                }
                int size = this.searchService.size(oAuthParams, _jql);
                HashMap issue = Maps.newHashMap();
                _issue.put("aio_total", "" + size);
                _issue.put("aio_total_percent", "" + (double)size * 100.0 / ((double)grandTotal * 1.0));
                issue.put("fields", _issue);
                dto.getIssues().add(JsonUtils.stringToJsonNode(JsonUtils.objectToJsonString(issue)));
            }
        } else {
            this.fetchIssues(oAuthParams, dto, jql, true, 0, debugID);
        }
        logger.debug((Object)"Processing");
        Map<String, Object> out = this.reportingService.process(dto, jsonOnly, user);
        return out;
    }

    public int fetchIssues(OAuthParams oAuthParams, DTO dto, String jql, boolean fetchAll, int start, String schedReportId) throws JsonProcessingException, Exception, IOException, JsonParseException, JsonMappingException, ParseException {
        long et2;
        long st;
        Map<String, Object> queryFieldsMap = SchemaBuilder.queryFields(dto);
        boolean fetchEpic = queryFieldsMap.containsKey("fetchEpic") && (Boolean)queryFieldsMap.get("fetchEpic") != false;
        boolean epicLinkOnly = queryFieldsMap.containsKey("epicLinkOnly") && (Boolean)queryFieldsMap.get("epicLinkOnly") != false;
        boolean fetchWorklog = (Boolean)queryFieldsMap.get("fetchWorklog");
        boolean fetchProject = (Boolean)queryFieldsMap.get("fetchProject");
        Object epicNameFieldId = queryFieldsMap.get("epicNameFieldId");
        Object epicLinkFieldId = queryFieldsMap.get("epicLinkFieldId");
        Set queryFields = (Set)queryFieldsMap.get("queryFields");
        dto.setQueryFields(Lists.newArrayList((Iterable)queryFields));
        List<JsonNode> issues = this.searchService.search(oAuthParams, queryFields, jql, fetchAll, start, schedReportId);
        long pst = new Date().getTime();
        if (fetchEpic) {
            st = new Date().getTime();
            logger.debug((Object)("Processing Epics (" + schedReportId + ")"));
            this.processEpics(oAuthParams, epicNameFieldId, epicLinkFieldId, issues, schedReportId, epicLinkOnly);
            et2 = new Date().getTime();
            logger.debug((Object)("Done. Took " + (et2 - st) / 1000L + " seconds"));
        }
        if (fetchWorklog) {
            st = new Date().getTime();
            logger.debug((Object)("Processing Worklogs (" + schedReportId + ")"));
            this.processWorklogs(oAuthParams, issues);
            et2 = new Date().getTime();
            logger.debug((Object)("Done. Took " + (et2 - st) / 1000L + " seconds"));
        }
        if (fetchProject) {
            this.processProject(oAuthParams, issues);
        }
        st = new Date().getTime();
        logger.debug((Object)("Processing Versions (" + schedReportId + ")"));
        this.processVersions(oAuthParams, issues);
        et2 = new Date().getTime();
        logger.debug((Object)("Done. Took " + (et2 - st) / 1000L + " seconds"));
        st = new Date().getTime();
        logger.debug((Object)("Processing History (" + schedReportId + ")"));
        this.processHistory(oAuthParams, issues);
        et2 = new Date().getTime();
        logger.debug((Object)("Done. Took " + (et2 - st) / 1000L + " seconds"));
        long pet = new Date().getTime();
        logger.debug((Object)("Processing Done. Took " + (pet - pst) / 1000L + " seconds"));
        dto.setIssues(issues);
        return issues.size();
    }

    private void processProject(OAuthParams oAuthParams, List<JsonNode> issues) throws Exception {
        String projects = this.authService.get(oAuthParams, "/rest/api/latest/project");
        JsonNode pNode = JsonUtils.stringToJsonNode(projects);
        HashMap keyToTypeMap = Maps.newHashMap();
        HashMap keyToDescMap = Maps.newHashMap();
        HashMap keyToLeadMap = Maps.newHashMap();
        for (JsonNode project : pNode) {
            String projectKey = JsonUtils.text(project, "key");
            JsonNode p2 = JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, "/rest/api/latest/project/" + projectKey));
            try {
                keyToTypeMap.put(projectKey, JsonUtils.text(p2, "projectTypeKey"));
            }
            catch (Exception e2) {
                keyToTypeMap.put(projectKey, "");
            }
            try {
                keyToDescMap.put(projectKey, JsonUtils.text(p2, "description"));
            }
            catch (Exception e3) {
                keyToDescMap.put(projectKey, "");
            }
            try {
                keyToLeadMap.put(projectKey, p2.get("lead").get("name").asText());
            }
            catch (Exception e4) {
                keyToLeadMap.put(projectKey, "");
            }
        }
        for (JsonNode issue : issues) {
            JsonNode ipNode = issue.get("fields").get("project");
            ((ObjectNode)ipNode).put("projectType", (String)keyToTypeMap.get(JsonUtils.text(ipNode, "key")));
            ((ObjectNode)ipNode).put("projectDesc", (String)keyToDescMap.get(JsonUtils.text(ipNode, "key")));
            ((ObjectNode)ipNode).put("projectLead", (String)keyToLeadMap.get(JsonUtils.text(ipNode, "key")));
        }
    }

    private String buildJql(OAuthParams oAuthParams, DTO dto) throws Exception {
        String jql = "";
        if (dto.getFilterType().equals((Object)FilterType.jql)) {
            jql = dto.getFilterValue();
        }
        if (dto.getFilterType().equals((Object)FilterType.jira)) {
            if (StringUtils.isBlank((CharSequence)dto.getFilterValue()) || "-1".equals(dto.getFilterValue())) {
                jql = "";
            } else {
                try {
                    String filter = this.authService.get(oAuthParams, "/rest/api/latest/filter/" + dto.getFilterValue());
                    jql = JsonUtils.text(JsonUtils.stringToJsonNode(filter), "jql");
                }
                catch (Exception e2) {
                    throw new Exception("JIRA Filter with id " + dto.getFilterValue() + " does not exist. Please update the report with correct filter.");
                }
            }
        }
        if (dto.getFilterType().equals((Object)FilterType.custom)) {
            jql = dto.getBaseJql();
        }
        if (dto.isTimesheet()) {
            jql = OfflineReportService.buildJqlForTimesheet(dto, jql);
        }
        return jql;
    }

    public static String buildJqlForTimesheet(DTO dto, String jql) throws Exception {
        String timesheetJql = OfflineReportService.timesheetJql(dto);
        if (StringUtils.isBlank((CharSequence)jql)) {
            jql = timesheetJql;
        } else if (!StringUtils.isBlank((CharSequence)timesheetJql)) {
            jql = "(" + jql + ") and (" + timesheetJql + ")";
        }
        return jql;
    }

    public static String timesheetJql(DTO dto) throws Exception {
        List<String> issueTypes;
        List<String> users;
        List<String> projects;
        OfflineReportService.setReportStartEndDates(dto);
        String timesheetJql = "";
        if (!dto.isIncludeNonWorklog()) {
            timesheetJql = timesheetJql + "worklogDate >= " + DateUtils.format(DateUtils.addDays(DateUtils.jsToJava(dto.getStartDate()), -1), "yyyy-MM-dd") + " and worklogDate <=" + DateUtils.format(DateUtils.addDays(DateUtils.jsToJava(dto.getEndDate()), 1), "yyyy-MM-dd");
        }
        if ((projects = dto.getProjects()) != null && projects.size() > 0) {
            ArrayList _projects = Lists.newArrayList();
            for (String _p : projects) {
                _projects.add("'" + _p + "'");
            }
            timesheetJql = timesheetJql + (StringUtils.isBlank((CharSequence)timesheetJql) ? "" : " and ") + " project in (" + Joiner.on((String)",").join((Iterable)_projects) + ")";
        }
        if (!dto.isIncludeNonWorklog() && (users = dto.determineTimesheetUsers()).size() > 0) {
            timesheetJql = timesheetJql + (StringUtils.isBlank((CharSequence)timesheetJql) ? "" : " and ") + " worklogAuthor in (" + Joiner.on((String)",").join(users) + ")";
        }
        if ((issueTypes = dto.getIssueTypes()) != null && issueTypes.size() > 0) {
            ArrayList _issueTypes = Lists.newArrayList();
            for (String _i : issueTypes) {
                _issueTypes.add("'" + _i + "'");
            }
            if (dto.isIncludeSubTasks() && dto.getSubIssueTypes() != null) {
                for (String _i : dto.getSubIssueTypes()) {
                    _issueTypes.add("'" + _i + "'");
                }
            }
            timesheetJql = timesheetJql + (StringUtils.isBlank((CharSequence)timesheetJql) ? "" : " and ") + " issuetype in (" + Joiner.on((String)",").join((Iterable)_issueTypes) + ")";
        }
        return timesheetJql;
    }

    public static void setReportStartEndDates(DTO dto) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)dto.getDateRange())) {
            LocalDate lastmonth;
            LocalDate lastweek;
            String timezone = dto.getTimezone();
            LocalDate now = DateUtils.timezoneLocalDate(timezone);
            Date startDate = null;
            Date endDate = null;
            if ("current_week".equals(dto.getDateRange())) {
                startDate = now.withDayOfWeek(1).toDate();
                endDate = now.withDayOfWeek(7).toDate();
            }
            if ("last_week".equals(dto.getDateRange())) {
                lastweek = now.minusWeeks(1);
                startDate = lastweek.withDayOfWeek(1).toDate();
                endDate = lastweek.withDayOfWeek(7).toDate();
            }
            if ("current_last_week".equals(dto.getDateRange())) {
                lastweek = now.minusWeeks(1);
                startDate = lastweek.withDayOfWeek(1).toDate();
                endDate = now.withDayOfWeek(7).toDate();
            }
            if ("current_month".equals(dto.getDateRange())) {
                startDate = now.withDayOfMonth(1).toDate();
                endDate = now.dayOfMonth().withMaximumValue().toDate();
            }
            if ("last_month".equals(dto.getDateRange())) {
                lastmonth = now.minusMonths(1);
                startDate = lastmonth.withDayOfMonth(1).toDate();
                endDate = lastmonth.dayOfMonth().withMaximumValue().toDate();
            }
            if ("custom".equals(dto.getDateRange())) {
                startDate = DateUtils.jsToJava(dto.getStartDate());
                endDate = DateUtils.jsToJava(dto.getEndDate());
            }
            if ("last_n_days".equals(dto.getDateRange())) {
                endDate = DateUtils.addDays(now.toDate(), -1);
                startDate = DateUtils.addDays(endDate, -dto.getDays().intValue() + 1);
            }
            if ("today".equals(dto.getDateRange())) {
                endDate = DateUtils.addDays(now.toDate(), 0);
                startDate = DateUtils.addDays(endDate, 0);
            }
            if ("yesterday".equals(dto.getDateRange())) {
                endDate = DateUtils.addDays(now.toDate(), -1);
                startDate = DateUtils.addDays(endDate, 0);
            }
            if ("ytd".equals(dto.getDateRange())) {
                startDate = new LocalDate(now.getYear(), 1, 1).toDate();
                endDate = now.toDate();
            }
            if ("ytlm".equals(dto.getDateRange())) {
                startDate = new LocalDate(now.getYear(), 1, 1).toDate();
                lastmonth = now.minusMonths(1);
                endDate = lastmonth.dayOfMonth().withMaximumValue().toDate();
            }
            if ("ytcm".equals(dto.getDateRange())) {
                startDate = new LocalDate(now.getYear(), 1, 1).toDate();
                endDate = now.dayOfMonth().withMaximumValue().toDate();
            }
            startDate = DateUtils.removeTime(startDate);
            endDate = DateUtils.maxTime(endDate);
            dto.setStartDate(DateUtils.format(startDate, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
            dto.setEndDate(DateUtils.format(endDate, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        }
    }

    private Map<String, Object> buildSchema(OAuthParams oAuthParams) throws Exception {
        String jiraFields = this.authService.get(oAuthParams, "/rest/api/latest/field");
        String jiraAutocompleteData = this.authService.get(oAuthParams, "/rest/api/latest/jql/autocompletedata");
        String jiraPriorities = this.authService.get(oAuthParams, "/rest/api/latest/priority");
        HashMap schemaData = Maps.newHashMap();
        schemaData.put("fields", JsonUtils.stringToJsonNode(jiraFields));
        schemaData.put("autocompletedata", JsonUtils.stringToJsonNode(jiraAutocompleteData));
        schemaData.put("priorities", JsonUtils.stringToJsonNode(jiraPriorities));
        String strSchemaData = JsonUtils.objectToJsonString(schemaData);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        Map<String, Object> schemaMap = schemaBuilder.build(JsonUtils.stringToType(strSchemaData, new TypeReference<JsonNode>(){}), oAuthParams.getUser(), new AdminPersistenceService());
        return schemaMap;
    }

    private void processEpics(OAuthParams oAuthParams, Object epicNameFieldId, Object epicLinkFieldId, List<JsonNode> issues, String schedReportId, boolean epicLinkOnly) throws JsonProcessingException, IOException, Exception {
        HashMap<String, String> epics = new HashMap<String, String>();
        HashMap<String, JsonNode> epicLinks = new HashMap<String, JsonNode>();
        int i2 = 0;
        for (JsonNode issue : issues) {
            boolean isSubtask;
            JsonNode epicLink;
            block16: {
                ++i2;
                epicLink = null;
                isSubtask = issue.get("fields").get("issuetype").get("subtask").asBoolean();
                if (isSubtask) {
                    try {
                        if (!issue.get("fields").has("parent")) break block16;
                        JsonNode parentKey = issue.get("fields").get("parent").get("key");
                        if (issue.get("fields").get("parent").get("fields").get("issuetype").get("name").asText().equals("Epic")) {
                            epicLink = parentKey;
                        } else if (epicLinks.containsKey(parentKey.asText())) {
                            epicLink = (JsonNode)epicLinks.get(parentKey.asText());
                        } else {
                            String parentIssue = this.authService.get(oAuthParams, "/rest/api/latest/issue/" + parentKey.asText() + "?fields=" + epicLinkFieldId);
                            JsonNode epicLinkJsonNode = JsonUtils.stringToJsonNode(parentIssue).get("fields").get(epicLinkFieldId.toString());
                            if (epicLinkJsonNode != null) {
                                epicLink = epicLinkJsonNode;
                                epicLinks.put(parentKey.asText(), epicLink);
                            }
                        }
                        break block16;
                    }
                    catch (Exception e2) {
                        if (e2.getMessage() == null || !e2.getMessage().contains("HTTP/1.1 404 Not Found") && !e2.getMessage().contains("nonce_used")) {
                            this.emailService.sendErrorEmail(e2, "", issue.toString());
                        }
                        break block16;
                    }
                }
                epicLink = issue.get("fields").get(epicLinkFieldId.toString());
            }
            if (JsonUtils.isNotJsonNull(epicLink)) {
                String strEpicLink = epicLink.asText();
                if (isSubtask) {
                    ObjectNode epicNode = (ObjectNode)issue.path("fields");
                    epicNode.put(epicLinkFieldId.toString(), strEpicLink);
                }
                if (!epicLinkOnly) {
                    String epicName = (String)epics.get(strEpicLink);
                    if (epicName == null) {
                        try {
                            JsonNode epic = JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, "/rest/api/latest/issue/" + strEpicLink + "?fields=" + epicNameFieldId.toString()));
                            epicName = epic.get("fields").get(epicNameFieldId.toString()).asText();
                        }
                        catch (Exception e3) {
                            epicName = strEpicLink + " (No Access)";
                        }
                        epics.put(strEpicLink, epicName);
                    }
                    ObjectNode epicNode = (ObjectNode)issue.path("fields");
                    epicNode.put(epicNameFieldId.toString(), epicName);
                }
            }
            if (i2 % 100 != 0) continue;
            logger.debug((Object)("processEpics (" + schedReportId + "): " + i2 + "/" + issues.size() + " (" + i2 * 100 / issues.size() + "%)"));
        }
    }

    private void processWorklogs(OAuthParams oAuthParams, List<JsonNode> issues) throws JsonProcessingException, IOException, Exception {
        for (JsonNode issue : issues) {
            HashMap jNode;
            JsonNode worklogs = null;
            String worklogUrl = "/rest/api/latest/issue/" + issue.get("key").asText() + "/worklog";
            if (issue.has("fields")) {
                JsonNode workLogParentNode = issue.get("fields").get("worklog");
                if (JsonUtils.isJsonNull(workLogParentNode)) {
                    worklogs = JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, worklogUrl));
                } else {
                    int max = workLogParentNode.get("maxResults").asInt();
                    int total = workLogParentNode.get("total").asInt();
                    worklogs = total > max ? JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, worklogUrl)) : workLogParentNode;
                }
            } else {
                worklogs = JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, worklogUrl));
            }
            if (JsonUtils.isJsonNull(worklogs)) continue;
            if (issue.has("fields")) {
                if (issue.get("fields").has("worklog")) {
                    ObjectNode workLogNode = (ObjectNode)issue.path("fields").path("worklog");
                    workLogNode.set("worklogs", worklogs.get("worklogs"));
                    continue;
                }
                jNode = Maps.newHashMap();
                jNode.put("worklogs", worklogs.get("worklogs"));
                ObjectNode fieldsNode = (ObjectNode)issue.path("fields");
                fieldsNode.set("worklog", JsonUtils.stringToJsonNode(JsonUtils.objectToJsonString(jNode)));
                continue;
            }
            jNode = Maps.newHashMap();
            jNode.put("worklogs", worklogs.get("worklogs"));
            HashMap jNode2 = Maps.newHashMap();
            jNode2.put("worklog", JsonUtils.stringToJsonNode(JsonUtils.objectToJsonString(jNode)));
            ObjectNode issueNode = (ObjectNode)issue;
            issueNode.set("fields", JsonUtils.stringToJsonNode(JsonUtils.objectToJsonString(jNode2)));
        }
    }

    private void processVersions(OAuthParams oAuthParams, List<JsonNode> issues) throws JsonParseException, JsonMappingException, IOException, Exception {
        HashMap versions = Maps.newHashMap();
        for (JsonNode issue : issues) {
            if (!issue.get("fields").has("fixVersions") || issue.get("fields").get("fixVersions").size() <= 0) continue;
            for (JsonNode fixVersion : issue.get("fields").get("fixVersions")) {
                String versionId = fixVersion.get("id").asText();
                if (versions.containsKey(versionId)) {
                    ((ObjectNode)fixVersion).put("startDate", (String)versions.get(versionId));
                    continue;
                }
                JsonNode version = JsonUtils.stringToJsonNode(this.authService.get(oAuthParams, "/rest/api/latest/version/" + versionId));
                String startDate = null;
                if (version.has("startDate") && JsonUtils.isNotJsonNull(version.get("startDate"))) {
                    startDate = version.get("startDate").asText();
                }
                versions.put(versionId, startDate);
                ((ObjectNode)fixVersion).put("startDate", startDate);
            }
        }
    }

    private void processHistory(OAuthParams oAuthParams, List<JsonNode> issues) throws ParseException, IOException {
        String timezone = oAuthParams.getUser().getTimeZone();
        for (JsonNode issue : issues) {
            if (!issue.has("changelog")) continue;
            ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
            JsonNode hs2 = issue.get("changelog").get("histories");
            Integer overallOrder = 1;
            HashMap<String, Map<String, Object>> tracker = new HashMap<String, Map<String, Object>>();
            for (JsonNode h2 : hs2) {
                JsonNode items = h2.get("items");
                for (JsonNode item : items) {
                    Map<String, Object> startTracker;
                    boolean first = false;
                    String fName = item.get("field").asText();
                    if (tracker.containsKey(fName)) {
                        startTracker = (Map)tracker.get(fName);
                    } else {
                        startTracker = new HashMap();
                        tracker.put(fName, startTracker);
                        startTracker.put("order", "1");
                        first = true;
                    }
                    String toString = "";
                    if (JsonUtils.isNotJsonNull(item.get("toString"))) {
                        toString = item.get("toString").asText();
                    }
                    String fromString = "";
                    if (JsonUtils.isNotJsonNull(item.get("fromString"))) {
                        fromString = item.get("fromString").asText();
                    }
                    if (first && StringUtils.isNotBlank((CharSequence)fromString)) {
                        overallOrder = this.addHistoryRow(timezone, rows, overallOrder, startTracker, h2, fName, issue.get("fields").get("created").asText(), fromString, issue, "");
                    }
                    overallOrder = this.addHistoryRow(timezone, rows, overallOrder, startTracker, h2, fName, h2.get("created").asText(), toString, issue, fromString);
                }
            }
            ((ObjectNode)issue.path("fields")).set("changelog", JsonUtils.stringToJsonNode(JsonUtils.objectToJsonString(rows)));
            ((ObjectNode)issue).remove("changelog");
        }
    }

    public Integer addHistoryRow(String timezone, List<Map<String, String>> rows, Integer overallOrder, Map<String, Object> startTracker, JsonNode h2, String fName, String start, String value, JsonNode issue, String from) throws ParseException {
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        row.put("id", h2.get("id").asText());
        row.put("issuekey", issue.get("key").asText());
        row.put("start", start);
        row.put("value", value);
        row.put("order_field", startTracker.get("order").toString());
        row.put("field", fName);
        row.put("order", "" + overallOrder);
        row.put("order_combo", startTracker.get("order").toString() + "-" + value);
        row.put("from", from);
        if (h2.has("author")) {
            row.put("author", h2.get("author").get("displayName").asText());
        } else {
            row.put("author", "");
        }
        rows.add(row);
        if (startTracker.containsKey(fName)) {
            Map r2 = (Map)startTracker.get(fName);
            r2.put("end", h2.get("created").asText());
        }
        startTracker.put(fName, row);
        startTracker.put("order", Integer.parseInt(startTracker.get("order").toString()) + 1);
        Integer n2 = overallOrder;
        Integer n3 = overallOrder = Integer.valueOf(overallOrder + 1);
        return overallOrder;
    }
}

