/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.kaanha.reports.helper.Constants;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.service.AtlassianOAuthClient;
import com.kaanha.reports.service.ProtectedConfigFile;
import com.kaanha.reports.service.TokenSecretVerifierHolder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.AccessDeniedException;
import java.sql.SQLException;
import java.util.Map;
import net.oauth.OAuthProblemException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OAuthService {
    ProtectedConfigFile protectedConfigFile = new ProtectedConfigFile();
    static Logger logger = Logger.getLogger(OAuthService.class);
    static OAuthService oAuthService;

    private OAuthService() throws Exception {
    }

    public static OAuthService getInstance() throws Exception {
        if (oAuthService == null) {
            oAuthService = new OAuthService();
        }
        return oAuthService;
    }

    public String getAccessTokenStatus(OAuthParams oAuthParams) throws Exception {
        try {
            this.getRequestToken(oAuthParams);
        }
        catch (Exception e2) {
            return this.processAuthException(e2);
        }
        if (StringUtils.isBlank((CharSequence)oAuthParams.getUser().getoAuthTokenStr())) {
            return "AUTHORIZE_URL";
        }
        try {
            return this.login(oAuthParams);
        }
        catch (Exception e3) {
            return this.processAuthException(e3);
        }
    }

    public String createAuthorizeUrl(OAuthParams oAuthParams) throws Exception {
        TokenSecretVerifierHolder requestToken = this.getRequestToken(oAuthParams);
        String authorizeUrl = this.createAuthClient(oAuthParams).getAuthorizeUrlForToken(requestToken.token);
        oAuthParams.getUser().setoAuthTokenSecret(requestToken.secret);
        return authorizeUrl;
    }

    private TokenSecretVerifierHolder getRequestToken(OAuthParams oAuthParams) throws Exception {
        AtlassianOAuthClient jiraoAuthClient = this.createAuthClient(oAuthParams);
        TokenSecretVerifierHolder requestToken = jiraoAuthClient.getRequestToken();
        return requestToken;
    }

    private AtlassianOAuthClient createAuthClient(OAuthParams oAuthParams) throws Exception {
        AtlassianOAuthClient jiraoAuthClient = new AtlassianOAuthClient(oAuthParams);
        return jiraoAuthClient;
    }

    public String processAuthException(Exception e2) throws Exception {
        String message = null;
        if (e2.getCause() instanceof OAuthProblemException && "consumer_key_unknown".equals(e2.getCause().getMessage())) {
            message = "APP_LINK_NEEDED";
        }
        if (e2 instanceof OAuthProblemException && "consumer_key_unknown".equals(e2.getMessage())) {
            message = "APP_LINK_NEEDED";
        }
        if (e2.getCause() instanceof OAuthProblemException && "token_rejected".equals(e2.getCause().getMessage())) {
            message = "AUTHORIZE_URL";
        }
        if (e2.getCause() instanceof OAuthProblemException && "signature_invalid".equals(e2.getCause().getMessage())) {
            message = "APP_LINK_NEEDED";
        }
        if (e2 instanceof OAuthProblemException && "token_rejected".equals(e2.getMessage())) {
            message = "AUTHORIZE_URL";
        }
        if (message == null) {
            throw e2;
        }
        return message;
    }

    public String login(OAuthParams oAuthParams) throws Exception {
        return this.get(oAuthParams, "/rest/auth/latest/session");
    }

    public String get(OAuthParams oAuthParams, String url) throws Exception {
        try {
            return this.createAuthClient(oAuthParams).authenticatedGet(oAuthParams.getBaseUrl() + url, oAuthParams.getUser().getoAuthTokenStr());
        }
        catch (Exception e2) {
            logger.error((Object)(e2.getMessage() + ": " + url), (Throwable)e2);
            throw e2;
        }
    }

    public String post(OAuthParams oAuthParams, String url, String payload) throws Exception {
        return this.createAuthClient(oAuthParams).authenticatedPost(oAuthParams.getBaseUrl() + url, oAuthParams.getUser().getoAuthTokenStr(), payload);
    }

    public String createAccessToken(OAuthParams oAuthParams, String requestToken, String tokenSecret, String oauthVerifier) throws Exception {
        return this.createAuthClient(oAuthParams).swapRequestTokenForAccessToken(requestToken, tokenSecret, oauthVerifier);
    }

    public boolean initOAuth(OAuthParams oAuthParams, Map<String, Object> out) throws AccessDeniedException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception, SQLException, JsonParseException, JsonMappingException, IOException {
        boolean valid = true;
        String accessTokenStatus = this.getAccessTokenStatus(oAuthParams);
        String origConsumerKey = oAuthParams.getConsumerKey();
        if (accessTokenStatus.equals("APP_LINK_NEEDED") && oAuthParams.getConsumerKey().equals("All-In-One JIRA Reports")) {
            oAuthParams.setConsumerKey("All-In-One Reports for JIRA");
            accessTokenStatus = this.getAccessTokenStatus(oAuthParams);
        }
        out.put("accessTokenStatus", accessTokenStatus);
        if (accessTokenStatus.equals("APP_LINK_NEEDED")) {
            out.put("addOnKey", oAuthParams.getAddOnKey());
            out.put("applicationName", Constants.addOnName(oAuthParams.getAddOnKey()));
            out.put("consumerKey", origConsumerKey);
            out.put("publicKey", oAuthParams.getPublicKey());
            valid = false;
        } else if (accessTokenStatus.equals("AUTHORIZE_URL")) {
            String authorizeUrl = this.createAuthorizeUrl(oAuthParams);
            out.put("authorizeUrl", authorizeUrl);
            valid = false;
        }
        return valid;
    }
}

