/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.DataSet;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.TeamPersistenceService;
import com.kaanha.reports.service.SchemaBuilder;
import com.kaanha.reports.service.ValueExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Normalizer {
    public static DataSet extract(DTO dto, AioUser loggedInUser) throws Exception {
        DataSet dataSet = new DataSet();
        ArrayList data = Lists.newArrayList();
        HashMap worklogs = Maps.newHashMap();
        HashMap history = Maps.newHashMap();
        List<Field> fields = dto.getQueryFields();
        Field worklogAioTeamField = Fielder.findInFields(SchemaBuilder.derivedFieldId("worklog", "wlAioTeam"), dto.getAllFields());
        boolean hasWlAioTeam = false;
        HashMap userToTeamMapping = Maps.newHashMap();
        if (worklogAioTeamField != null) {
            hasWlAioTeam = true;
            List<AioTeam> myTeams = new TeamPersistenceService().getUserTeams(loggedInUser);
            for (AioTeam team : myTeams) {
                for (AioTeamMember tm : team.getMembers()) {
                    String username = tm.getUser().getUsername();
                    String teamName = team.getName();
                    if (userToTeamMapping.containsKey(username)) {
                        teamName = (String)userToTeamMapping.get(username) + ", " + teamName;
                    }
                    userToTeamMapping.put(username, teamName);
                }
            }
        }
        for (JsonNode issue : dto.getIssues()) {
            if (!issue.has("fields")) continue;
            JsonNode fieldVals = issue.get("fields");
            ArrayList line = Lists.newArrayList();
            for (Field field : fields) {
                String val = null;
                if ("issuekey".equalsIgnoreCase(field.getId())) {
                    val = JsonUtils.text(issue, "key");
                } else {
                    if ("worklog".equalsIgnoreCase(field.getId())) {
                        worklogs.put(JsonUtils.text(issue, "key"), ValueExtractor.worklogs(field, fieldVals, hasWlAioTeam, userToTeamMapping, dto.isTimeEntry()));
                        continue;
                    }
                    if ("changelog".equalsIgnoreCase(field.getId())) {
                        history.put(JsonUtils.text(issue, "key"), ValueExtractor.history(field, fieldVals));
                        continue;
                    }
                    if (field.isRaw()) {
                        JsonNode rawValue = fieldVals.get(field.getId());
                        if (rawValue != null && !rawValue.isNull()) {
                            val = rawValue.toString();
                        }
                    } else {
                        try {
                            val = ValueExtractor.value(field, fieldVals, dto.getTimezone());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                line.add(val);
            }
            data.add(line);
        }
        dataSet.setIssues(data);
        dataSet.setWorklogs(worklogs);
        dataSet.setHistory(history);
        return dataSet;
    }
}

