/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.kaanha.reports.connect.ConnectionParams;
import com.kaanha.reports.connect.RestConnectionParams;
import com.kaanha.reports.connect.RestConnector;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import java.util.Date;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@DisallowConcurrentExecution
public class LicenseService
implements Job {
    static Logger logger = Logger.getLogger(LicenseService.class);
    RestConnector conn = RestConnector.getInstance();
    ConnectionParams rest = new RestConnectionParams();
    TenantPersistenceService tps;
    UserPersistenceService ups;

    public static void main(String[] args) throws SchedulerException {
        JobDetail job2 = JobBuilder.newJob(LicenseService.class).withIdentity("senJob", "group1").build();
        SimpleTrigger trigger2 = TriggerBuilder.newTrigger().withIdentity("senTrigger", "group1").withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever()).build();
        Scheduler scheduler2 = new StdSchedulerFactory().getScheduler();
        scheduler2.start();
        scheduler2.scheduleJob(job2, trigger2);
        JobDetail job = JobBuilder.newJob(LicenseService.class).withIdentity("licenseJob", "group1").build();
        SimpleTrigger trigger = TriggerBuilder.newTrigger().withIdentity("licenseTrigger", "group1").withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever()).build();
        Scheduler scheduler = new StdSchedulerFactory().getScheduler();
        scheduler.start();
        scheduler.scheduleJob(job, trigger);
    }

    public LicenseService() throws Exception {
        this.rest.setURL("https://marketplace.atlassian.com");
        this.rest.setUsername(Utils.getEnvProperty("MARKETPLACE_USERNAME"));
        this.rest.setPassword(Utils.getEnvProperty("MARKETPLACE_PASSWORD"));
        PersistenceService.createCloudInstance();
        this.tps = new TenantPersistenceService();
        this.ups = new UserPersistenceService();
    }

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String key = context.getJobDetail().getKey().toString();
        if ("group1.licenseJob".equals(key)) {
            this.e1();
        } else {
            this.e2();
        }
    }

    private void e2() throws JobExecutionException {
        logger.debug((Object)"__________________________e2");
        try {
            String restpath;
            String url = restpath = "/rest/2/vendors/" + Utils.getEnvProperty("MARKETPLACE_VENDOR_ID") + "/reporting/licenses/export?accept=json&hosting=cloud";
            logger.debug((Object)("e2: " + url));
            String response = this.conn.get(this.rest, url);
            JsonNode licNode = JsonUtils.stringToJsonNode(response);
            for (JsonNode lic : licNode) {
                AioUser[] users;
                String sen = lic.get("licenseId").asText();
                String addOnKey = lic.get("addonKey").asText();
                AioTenant[] t2 = this.tps.findByAddOnKeyAndServiceEntitlementNumber(addOnKey, sen);
                if (t2.length != 0) continue;
                String userEmail = lic.get("contactDetails").get("technicalContact").get("email").asText().toLowerCase();
                if (StringUtils.isNotBlank((CharSequence)userEmail)) {
                    for (AioUser user : users = this.ups.findByEmailAddress(userEmail)) {
                        if (!StringUtils.isBlank((CharSequence)user.getTenant().getServiceEntitlementNumber())) continue;
                        logger.debug((Object)("e2: " + userEmail + ", " + user.getTenant().getID() + ", " + sen));
                        user.getTenant().setServiceEntitlementNumber(sen);
                        this.tps.save(user.getTenant());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(userEmail = lic.get("contactDetails").get("billingContact").get("email").asText().toLowerCase()))) continue;
                for (AioUser user : users = this.ups.findByEmailAddress(userEmail)) {
                    if (!StringUtils.isBlank((CharSequence)user.getTenant().getServiceEntitlementNumber())) continue;
                    logger.debug((Object)("e2: " + userEmail + ", " + user.getTenant().getID() + ", " + sen));
                    user.getTenant().setServiceEntitlementNumber(sen);
                    this.tps.save(user.getTenant());
                }
            }
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        logger.debug((Object)"__________________________e2 done");
    }

    private void e1() throws JobExecutionException {
        logger.debug((Object)"__________________________e1");
        try {
            String restpath = "/rest/2/vendors/" + Utils.getEnvProperty("MARKETPLACE_VENDOR_ID") + "/reporting/licenses?hosting=cloud&limit=50";
            int count = 0;
            int i2 = 0;
            int countInactive = 0;
            int countNoSEN = 0;
            AioTenant[] allTenants = this.tps.findAll();
            TreeSet longRunningEvaluations = Sets.newTreeSet();
            for (AioTenant t2 : allTenants) {
                boolean delete;
                boolean active;
                block14: {
                    if ("https://jirareports.atlassian.net".equals(t2.getBaseUrl())) continue;
                    ++i2;
                    active = false;
                    delete = false;
                    String licenseId = t2.getServiceEntitlementNumber();
                    if (StringUtils.isBlank((CharSequence)licenseId)) {
                        ++countNoSEN;
                        active = true;
                    } else {
                        try {
                            String path = restpath + "&text=" + licenseId + "&addon=" + t2.getAddOnKey();
                            String lic = this.conn.get(this.rest, path);
                            JsonNode licNode = JsonUtils.stringToJsonNode(lic);
                            if (!licNode.has("licenses")) break block14;
                            JsonNode licenses = licNode.get("licenses");
                            for (JsonNode license : licenses) {
                                String licId = license.get("licenseId").asText();
                                String addonKey = license.get("addonKey").asText();
                                if (!licenseId.equals(licId) || !addonKey.equals(t2.getAddOnKey())) continue;
                                String status = license.get("status").asText();
                                String strMaintEndDate = license.get("maintenanceEndDate").asText();
                                Date maintenanceEndDate = DateUtils.toDate(strMaintEndDate, "yyyy-MM-dd");
                                String strMaintStartDate = license.get("maintenanceStartDate").asText();
                                Date maintenanceStartDate = DateUtils.toDate(strMaintStartDate, "yyyy-MM-dd");
                                String licenseType = license.get("licenseType").asText();
                                if ("active".equals(status)) {
                                    active = true;
                                } else {
                                    String log = licId + ", " + strMaintEndDate + ", " + String.format("%1$10s", status) + ", " + String.format("%1$10s", DateUtils.format(t2.getTrialEnd(), "yyyy-MM-dd")) + ", " + String.format("%1$12s", new Object[]{t2.getStatus()}) + ", " + String.format("%1$50s", t2.getBaseUrl()) + ", " + String.format("%1$4s", "" + i2 * 100 / allTenants.length + "%");
                                    if (!this.expired(maintenanceEndDate, t2, 7)) {
                                        active = true;
                                    } else {
                                        ++countInactive;
                                        log = log + " ----";
                                    }
                                    if (this.expired(maintenanceEndDate, t2, 60) && (t2.getTrialEnd() == null || t2.getTrialEnd().before(new Date()))) {
                                        delete = true;
                                        log = log + " ****";
                                        ++count;
                                    }
                                    logger.debug((Object)("e1: " + log));
                                }
                                if (!"EVALUATION".equals(licenseType) || !(DateUtils.daysBetween(maintenanceStartDate, maintenanceEndDate) > 90.0)) continue;
                                longRunningEvaluations.add(licenseId);
                                active = false;
                                if (!t2.getLicenseActive().booleanValue()) continue;
                                t2.setTrialEnd(maintenanceEndDate);
                            }
                        }
                        catch (Exception e2) {
                            continue;
                        }
                    }
                }
                if (delete) {
                    this.tps.delete(t2);
                    continue;
                }
                t2.setLicenseActive(active);
                this.tps.save(t2);
            }
            logger.debug((Object)("e1 Removed: " + count + ";Inactive: " + countInactive + "; Total: " + allTenants.length + "; Percentage: " + countInactive * 100 / allTenants.length + "; No SEN: " + countNoSEN));
            logger.debug((Object)("e1 Long running evaluations: SELECT * FROM \"aioTenant\" where \"serviceEntitlementNumber\" in ('" + Joiner.on((String)"','").join((Iterable)longRunningEvaluations) + "') and \"lastAllowedDate\" is not null order by \"lastAllowedDate\" desc"));
        }
        catch (Exception e3) {
            logger.error((Object)e3.getMessage(), (Throwable)e3);
        }
        logger.debug((Object)"__________________________e1 done");
    }

    private boolean expired(Date maintenanceEndDate, AioTenant t2, int days) {
        Date now = new Date();
        return maintenanceEndDate.before(now) && DateUtils.daysBetween(now, maintenanceEndDate) > (double)days;
    }
}

