/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.service.Cache;
import com.kaanha.reports.service.H2Function;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class H2Functions {
    @H2Function
    public static String SprintFieldValue(String datamartID, String sprintFieldId, String fieldId, String sprints) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)sprints)) {
            Map<Object, Object> sv;
            String latestSprint = H2Functions.FindLatestSprint(sprints);
            String sprintHash = latestSprint.substring(0, latestSprint.indexOf("["));
            if (Cache.sprint.containsKey(datamartID) && Cache.sprint.get(datamartID).containsKey(sprintHash)) {
                sv = Cache.sprint.get(datamartID).get(sprintHash);
            } else {
                sv = Maps.newHashMap();
                String s2 = latestSprint.substring(latestSprint.indexOf("[", 1));
                s2 = s2.substring(s2.indexOf("[") + 1, s2.lastIndexOf("]"));
                for (String p2 : s2.split(",")) {
                    String[] itr = p2.split("=");
                    if (itr.length != 2) continue;
                    sv.put(sprintFieldId + "_" + itr[0], itr[1]);
                }
                HashMap sprint = Maps.newHashMap();
                sprint.put(sprintHash, sv);
                Cache.sprint.put(datamartID, sprint);
            }
            String fieldVal = (String)sv.get(fieldId);
            if ("<null>".equals(fieldVal)) {
                fieldVal = null;
            }
            return fieldVal;
        }
        return null;
    }

    private static String FindLatestSprint(String sprints) {
        boolean hasActiveSprint = false;
        boolean hasFutureSprint = false;
        String activeSprint = "";
        String futureSprint = "";
        String latestSprint = "";
        Date latestStartDate = null;
        String[] sprintsArr = sprints.split("~@~");
        if (sprintsArr.length == 1) {
            return sprintsArr[0];
        }
        for (String sprint : sprintsArr) {
            String[] keyValueArray;
            String sprintData = sprint.substring(sprint.indexOf("[", 1));
            sprintData = sprintData.substring(sprintData.indexOf("[") + 1, sprintData.lastIndexOf("]"));
            for (String pair : keyValueArray = sprintData.split(",")) {
                String[] keyValue = pair.split("=");
                String key = keyValue[0];
                if ("state".equalsIgnoreCase(key)) {
                    String state = keyValue[1];
                    if ("active".equalsIgnoreCase(state)) {
                        hasActiveSprint = true;
                        activeSprint = sprint;
                    }
                    if ("future".equalsIgnoreCase(state)) {
                        hasFutureSprint = true;
                        futureSprint = sprint;
                    }
                }
                if (!"startdate".equalsIgnoreCase(key)) continue;
                String startDate = keyValue[1];
                try {
                    Date startDateDt = DateUtils.sdfSprint.get().parse(startDate);
                    if (latestStartDate != null && !startDateDt.after(latestStartDate)) continue;
                    latestStartDate = startDateDt;
                    latestSprint = sprint;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (hasActiveSprint) {
            return activeSprint;
        }
        if (hasFutureSprint) {
            return futureSprint;
        }
        return latestSprint;
    }

    @H2Function
    public static String HistoryValue(String fieldId, String fieldType, String value) throws JsonParseException, JsonMappingException, IOException, ParseException {
        return H2Functions.HistoryValue(fieldId, fieldType, value, null, 8.0);
    }

    @H2Function
    public static String HistoryValue(String fieldId, String fieldType, String value, String timezone, double businessHrsPerDay) throws JsonParseException, JsonMappingException, IOException, ParseException {
        if (value == null) {
            return null;
        }
        JsonNode historyNode = JsonUtils.stringToJsonNode(value);
        String fieldTypeValue = historyNode.get("field").asText();
        if (StringUtils.isBlank((CharSequence)fieldType) || fieldType.equalsIgnoreCase(fieldTypeValue)) {
            if (fieldId.startsWith("time_")) {
                Date startDate = DateUtils.applyTimezone(historyNode.get("start").asText(), timezone);
                Date endDate = DateUtils.applyTimezone(new Date(), timezone);
                if (historyNode.has("end")) {
                    endDate = DateUtils.applyTimezone(historyNode.get("end").asText(), timezone);
                }
                if (fieldId.equals("time_hrs")) {
                    return "" + DateUtils.hoursBetween(endDate, startDate);
                }
                if (fieldId.equals("time_hrs_business")) {
                    return "" + DateUtils.businessDaysBetween(endDate, startDate) * businessHrsPerDay;
                }
                if (fieldId.equals("time_days")) {
                    return "" + DateUtils.daysBetween(endDate, startDate);
                }
                if (fieldId.equals("time_days_business")) {
                    return "" + DateUtils.businessDaysBetween(endDate, startDate);
                }
            } else if (historyNode.has(fieldId)) {
                if (JsonUtils.isJsonNull(historyNode.get(fieldId))) {
                    return null;
                }
                return historyNode.get(fieldId).asText();
            }
        }
        return null;
    }

    @H2Function
    public static String DeepValue(String parentId, String fieldId, String value) throws JsonParseException, JsonMappingException, IOException {
        if (value == null) {
            return null;
        }
        String path = fieldId.substring(parentId.length() + 1);
        String pathValue = H2Functions.pathValue(JsonUtils.stringToJsonNode(value), path);
        return pathValue;
    }

    @H2Function
    public static String AIO_FORMATDATETIME(Timestamp datetime, String pattern) throws Exception {
        if (pattern.indexOf(" [") > -1 && pattern.endsWith("]")) {
            pattern = pattern.substring(0, pattern.indexOf(" ["));
        }
        if (datetime == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)pattern) && !"null".equals(pattern)) {
            if ("Quarter".equalsIgnoreCase(pattern)) {
                return DateUtils.getQuarterForDate(datetime);
            }
            DateFormat sdf = DateUtils.formatterForPattern(pattern);
            return sdf.format(datetime);
        }
        return datetime.toString();
    }

    @H2Function
    public static Date AIO_TODATE(String strDate, String pattern) throws Exception {
        if ("-".equals(strDate) || StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        return DateUtils.toDate(strDate, pattern);
    }

    @H2Function
    public static String AIO_UNLINK(String href) throws Exception {
        return Utils.getValueFromLink(href)[0];
    }

    @H2Function
    public static Date AIO_APPLY_TIMEZONE(String strDate, String timezone, String defaultTimezone) throws Exception {
        if (StringUtils.isBlank((CharSequence)timezone)) {
            timezone = defaultTimezone;
        }
        return DateUtils.applyTimezone(strDate, timezone);
    }

    private static String pathValue(JsonNode node, String path) {
        if (JsonUtils.notJsonNull(node)) {
            if (node.isArray()) {
                ArrayList out = Lists.newArrayList();
                for (JsonNode n2 : node) {
                    String pathValue = H2Functions.pathValue(n2, path);
                    if (pathValue == null) continue;
                    out.add(pathValue);
                }
                return Joiner.on((String)"; ").join((Iterable)out);
            }
            String[] pathComponents = path.split("\\|\\|");
            if (pathComponents.length > 1) {
                ArrayList out = Lists.newArrayList();
                for (String pathComponent : pathComponents) {
                    String pathValue = H2Functions.pathValue(node, pathComponent);
                    if (pathValue == null) continue;
                    out.add(pathValue);
                }
                return Joiner.on((String)"; ").join((Iterable)out);
            }
            String[] pathElements = path.split("\\.");
            if (pathElements.length > 1) {
                return H2Functions.pathValue(node.get(pathElements[0]), path.substring(path.indexOf(".") + 1));
            }
            return JsonUtils.text(node, path);
        }
        return null;
    }

    @H2Function
    public static Double StoryPointsValue(String datamartID, String storyPointsType, Double storyPoints, String resolutionDate) throws ParseException {
        if (storyPoints != null) {
            if ("completed".equals(storyPointsType) || "sp_percent_complete".equals(storyPointsType)) {
                if (StringUtils.isBlank((CharSequence)resolutionDate)) {
                    return 0.0;
                }
                return storyPoints;
            }
            if ("remaining".equals(storyPointsType)) {
                if (StringUtils.isBlank((CharSequence)resolutionDate)) {
                    return storyPoints;
                }
                return 0.0;
            }
        }
        return null;
    }

    @H2Function
    public static Double AGE(String created) throws ParseException {
        return DateUtils.daysBetween(new Date(), DateUtils.sdfJiraLongDate.get().parse(created));
    }

    @H2Function
    public static Double BUSINESS_AGE(String created) throws ParseException {
        return DateUtils.businessDaysBetween(new Date(), DateUtils.sdfJiraLongDate.get().parse(created));
    }

    @H2Function
    public static Double UPDATE_AGE(String updated) throws ParseException {
        return DateUtils.daysBetween(new Date(), DateUtils.sdfJiraLongDate.get().parse(updated));
    }

    @H2Function
    public static Double BUSINESS_UPDATE_AGE(String updated) throws ParseException {
        return DateUtils.businessDaysBetween(new Date(), DateUtils.sdfJiraLongDate.get().parse(updated));
    }

    @H2Function
    public static Double RESOLUTIONTIME(String resolutiondate, String created) throws ParseException {
        if (StringUtils.isBlank((CharSequence)resolutiondate)) {
            return null;
        }
        return DateUtils.daysBetween(DateUtils.sdfJiraLongDate.get().parse(resolutiondate), DateUtils.sdfJiraLongDate.get().parse(created));
    }

    @H2Function
    public static Double BUSINESS_RESOLUTIONTIME(String resolutiondate, String created) throws ParseException {
        if (StringUtils.isBlank((CharSequence)resolutiondate)) {
            return null;
        }
        return DateUtils.businessDaysBetween(DateUtils.sdfJiraLongDate.get().parse(resolutiondate), DateUtils.sdfJiraLongDate.get().parse(created));
    }

    @H2Function
    public static Long AIO_VARIANCE(Long timeoriginalestimate, Long timeestimate, Long timespent) throws ParseException {
        if (timeoriginalestimate == null) {
            timeoriginalestimate = 0L;
        }
        if (timeestimate == null) {
            timeestimate = 0L;
        }
        if (timespent == null) {
            timespent = 0L;
        }
        return -(timeoriginalestimate - timeestimate - timespent);
    }

    @H2Function
    public static String AIO_LINK(String url, String value, String baseUrl) throws ParseException {
        return H2Functions.AIO_LINK(url, value, baseUrl, false);
    }

    @H2Function
    public static String AIO_LINK(String url, String value, String baseUrl, boolean array) throws ParseException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "-";
        }
        String link = value;
        if (array) {
            if (StringUtils.indexOf((CharSequence)link, (CharSequence)";") > -1) {
                link = StringUtils.replace((String)link, (String)";", (String)",");
            }
            if (StringUtils.indexOf((CharSequence)link, (CharSequence)"\n") > -1) {
                link = StringUtils.replace((String)link, (String)"\n", (String)",");
                value = StringUtils.replace((String)value, (String)"\n", (String)"; ");
            }
            return "<a href=\"" + baseUrl + url + "(" + link + ")\" target=\"_blank\">" + value + "</a>";
        }
        if (StringUtils.indexOf((CharSequence)link, (CharSequence)" ") > -1) {
            link = "'" + link + "'";
        }
        return "<a href=\"" + baseUrl + url + link + "\" target=\"_blank\">" + value + "</a>";
    }

    @H2Function
    public static String ParentValue(String parent, String fieldName) throws JsonParseException, JsonMappingException, IOException {
        if (StringUtils.isNotBlank((CharSequence)parent)) {
            JsonNode parentNode = JsonUtils.stringToJsonNode(parent);
            if ("key".equals(fieldName)) {
                return parentNode.get("key").asText();
            }
            if ((parentNode = parentNode.get("fields")).has(fieldName)) {
                if (parentNode.get(fieldName).has("name")) {
                    return parentNode.get(fieldName).get("name").asText();
                }
                return parentNode.get(fieldName).asText();
            }
        }
        return null;
    }

    @H2Function
    public static Integer AIO_PRIORITY(String priority, String pMap) throws JsonParseException, JsonMappingException, IOException {
        if (StringUtils.isNotBlank((CharSequence)priority)) {
            Map<String, Integer> m2 = JsonUtils.stringToType(pMap, new TypeReference<Map<String, Integer>>(){});
            return m2.get(priority);
        }
        return null;
    }

    @H2Function
    public static double AIO_NONZERO(double value) {
        if (value == 0.0) {
            return 1.0;
        }
        return value;
    }

    @H2Function
    public static int AIO_NUM_CHARACTER(String value, String character) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)value, (CharSequence)"-")) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)value, (CharSequence)character) + 1;
    }

    @H2Function
    public static String AIO_BUCKET(String value, String buckets) throws Exception {
        JsonNode bucketsNode = JsonUtils.stringToJsonNode(buckets);
        double d2 = Double.parseDouble(value);
        String label = "No range (" + value + ")";
        for (JsonNode range : bucketsNode) {
            if (!(d2 >= range.get("start").asDouble()) || !(d2 < range.get("end").asDouble())) continue;
            label = range.get("label").asText();
        }
        return label;
    }

    @H2Function
    public static String SLA_VALUE(String value, String pattern) throws Exception {
        JsonNode valNode;
        JsonNode node = JsonUtils.stringToJsonNode(value);
        if (node != null && !node.isNull() && (valNode = H2Functions.slaValueNode(node)) != null && !valNode.isNull()) {
            return valNode.get("remainingTime").get(pattern).asText();
        }
        return null;
    }

    @H2Function
    public static String SLA_TARGET(String value, String pattern) throws Exception {
        JsonNode valNode;
        JsonNode node = JsonUtils.stringToJsonNode(value);
        if (node != null && !node.isNull() && (valNode = H2Functions.slaValueNode(node)) != null && !valNode.isNull()) {
            return valNode.get("goalDuration").get(pattern).asText();
        }
        return null;
    }

    private static JsonNode slaValueNode(JsonNode node) {
        JsonNode valNode = null;
        if (node.has("ongoingCycle")) {
            if (node.get("ongoingCycle").has("remainingTime")) {
                valNode = node.get("ongoingCycle");
            }
        } else if (node.has("completedCycles")) {
            JsonNode cc2 = node.get("completedCycles");
            Iterator<JsonNode> iterator = cc2.iterator();
            while (iterator.hasNext()) {
                JsonNode n2;
                valNode = n2 = iterator.next();
            }
        }
        return valNode;
    }
}

