/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.Filter;
import com.kaanha.reports.model.Operator;
import com.kaanha.reports.model.SQLFilter;
import com.kaanha.reports.service.SchemaBuilder;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FilterService {
    static Map<String, String> operatorMapFE = Maps.newLinkedHashMap();
    static Map<String, String> operatorMapJIRA = Maps.newLinkedHashMap();

    static void filters(List<Field> fields, List<Filter> filters) {
        for (Field field : fields) {
            if (!field.isFilterable()) continue;
            Filter filter = new Filter();
            filter.setId("filter_" + field.getId());
            filter.setLabel(field.getName());
            switch (field.getType()) {
                case VARCHAR: {
                    filter.setType("string");
                    break;
                }
                case NUMBER: {
                    filter.setType("double");
                    break;
                }
                case TIMESTAMP: {
                    filter.setType("date");
                    break;
                }
                default: {
                    filter.setType("string");
                }
            }
            filter.setField(field.getClauseName());
            for (JsonNode o2 : field.getOperators()) {
                String operator2 = o2.asText();
                if (!operatorMapJIRA.containsKey(operator2)) continue;
                operator2 = operatorMapJIRA.get(operator2);
                if (field.isNumber() && FilterService.isInOperator(operator2) || field.isDate() && (FilterService.isInOperator(operator2) || FilterService.isEqualOperator(operator2))) continue;
                filter.getOperators().add(operator2);
            }
            if (field.isDate()) {
                filter.getOperators().add("between");
                filter.getOperators().add("last_n");
                filter.getOperators().add("next_n");
            }
            filter.setAuto(field.getAuto() == null ? false : field.getAuto().asBoolean());
            filter.setUser(field.isUserType());
            if (filter.getOperators().size() <= 0) continue;
            filters.add(filter);
        }
        Collections.sort(filters);
    }

    public static List<String> nonAggregateFilters(DTO dto, Collection<Field> fields) throws Exception, ParseException, JsonParseException, JsonMappingException, IOException {
        return FilterService.buildFilters(dto, fields, false);
    }

    public static List<String> aggregateFilters(DTO dto, Collection<Field> fields) throws Exception, ParseException, JsonParseException, JsonMappingException, IOException {
        return FilterService.buildFilters(dto, fields, true);
    }

    private static List<String> buildFilters(DTO dto, Collection<Field> fields, boolean aggregate) throws Exception, ParseException, JsonParseException, JsonMappingException, IOException {
        ArrayList strFilters = Lists.newArrayList();
        for (Field f2 : fields) {
            JsonNode filterNode;
            String strFilter;
            boolean applyFilter;
            if (!StringUtils.isNotBlank((CharSequence)f2.getFilterValue()) || !(applyFilter = f2.isGroupBy() || aggregate || FilterService.notJqlFilter(dto, f2)) || (!aggregate || !f2.isAggregate()) && (aggregate || f2.isAggregate()) || !StringUtils.isNotBlank((CharSequence)(strFilter = FilterService.fieldFilter(f2, filterNode = JsonUtils.stringToJsonNode(f2.getFilterValue()), dto.getTimezone())))) continue;
            strFilters.add(strFilter);
        }
        return strFilters;
    }

    private static boolean notJqlFilter(DTO dto, Field f2) {
        Field schemaField = Fielder.findInFields(f2.getId(), dto.getSchema());
        return "Epic Name".equalsIgnoreCase(f2.getName()) || schemaField == null || !schemaField.isFilterable();
    }

    public static List<String> buildTimesheetFilters(DTO dto, List<String> users, Collection<Field> fields) throws ParseException, Exception {
        ArrayList strFilters = Lists.newArrayList();
        if (dto.isTimesheet()) {
            SQLFilter sqlFilter = new SQLFilter();
            sqlFilter.setField(Fielder.findInFields(SchemaBuilder.derivedFieldId("worklog", "started"), fields));
            sqlFilter.setOperator(Operator.BETWEEN);
            sqlFilter.getValues().add(dto.getStartDate());
            sqlFilter.getValues().add(dto.getEndDate());
            String strFilter = FilterService.sqlFilterToString(sqlFilter, dto.getTimezone());
            if (dto.isIncludeNonWorklog() || dto.isTimeEntry()) {
                strFilter = "(" + strFilter + " OR " + sqlFilter.getField().getColumnName() + " IS NULL)";
            }
            if (StringUtils.isNotBlank((CharSequence)strFilter)) {
                strFilters.add(strFilter);
            }
            if (users.size() > 0) {
                sqlFilter = new SQLFilter();
                sqlFilter.setField(Fielder.findInFields(SchemaBuilder.derivedFieldId("worklog", "author.name"), fields));
                sqlFilter.setOperator(Operator.IN);
                sqlFilter.getValues().add(StringUtils.join(users, (String)","));
                strFilter = FilterService.sqlFilterToString(sqlFilter, dto.getTimezone());
                if (dto.isIncludeNonWorklog() || dto.isTimeEntry()) {
                    strFilter = "(" + strFilter + " OR " + sqlFilter.getField().getColumnName() + " IS NULL )";
                }
                if (StringUtils.isNotBlank((CharSequence)strFilter)) {
                    strFilters.add(strFilter);
                }
            }
        }
        return strFilters;
    }

    private static String fieldFilter(Field field, JsonNode filterNode, String timeZone) throws ParseException {
        if (filterNode.has("rules")) {
            ArrayList strFilters = Lists.newArrayList();
            JsonNode rulesNode = filterNode.get("rules");
            for (JsonNode ruleNode : rulesNode) {
                String strFilter = FilterService.fieldFilter(field, ruleNode, timeZone);
                if (!StringUtils.isNotBlank((CharSequence)strFilter)) continue;
                strFilters.add(strFilter);
            }
            return Joiner.on((String)(" " + filterNode.get("condition").asText() + " ")).join((Iterable)strFilters);
        }
        if (filterNode.has("id")) {
            SQLFilter filter = new SQLFilter();
            filter.setField(field);
            filter.setOperator(Operator.valueOf(filterNode.get("operator").asText().toUpperCase()));
            if (filterNode.get("value").isArray()) {
                for (JsonNode n2 : filterNode.get("value")) {
                    filter.getValues().add(n2.asText());
                }
            } else {
                String dblqt;
                String val = filterNode.get("value").asText();
                if (StringUtils.startsWith((CharSequence)val, (CharSequence)(dblqt = "\"")) && StringUtils.endsWith((CharSequence)val, (CharSequence)dblqt)) {
                    val = StringUtils.removeEnd((String)StringUtils.removeStart((String)val, (String)dblqt), (String)dblqt);
                }
                filter.getValues().add(val);
            }
            if (filterNode.has("groupBy") && filterNode.get("groupBy").asBoolean()) {
                filter.setGroupBy(true);
            }
            return FilterService.sqlFilterToString(filter, timeZone);
        }
        return "";
    }

    public static String sqlFilterToString(SQLFilter filter, String timeZone) throws ParseException {
        String strFilter = "";
        Field field = filter.getField();
        String lhs = Fielder.name(field);
        switch (filter.getOperator()) {
            case BETWEEN: {
                strFilter = FilterService.simpleCondition(filter, field, "BETWEEN");
                break;
            }
            case IN: 
            case NOT_IN: {
                String[] valuesArr;
                String values = filter.getValues().get(0);
                ArrayList quotedValues = Lists.newArrayList();
                for (String val : valuesArr = values.split(",")) {
                    val = StringUtils.removeStart((String)val, (String)"\"");
                    val = StringUtils.removeEnd((String)val, (String)"\"");
                    val = StringUtils.removeStart((String)val, (String)"'");
                    val = StringUtils.removeEnd((String)val, (String)"'");
                    quotedValues.add("'" + Utils.h2Escape(val) + "'");
                }
                if (quotedValues.size() <= 0) break;
                strFilter = lhs + " " + StringUtils.replace((String)filter.getOperator().toString(), (String)"_", (String)" ") + " (" + Joiner.on((String)",").join((Iterable)quotedValues) + ") ";
                break;
            }
            case CONTAINS: {
                strFilter = "UPPER(" + lhs + ") LIKE '%" + Utils.h2Escape(filter.getValues().get(0)).toUpperCase() + "%' ";
                break;
            }
            case NOT_CONTAINS: {
                strFilter = "UPPER(" + lhs + ") NOT LIKE '%" + Utils.h2Escape(filter.getValues().get(0)).toUpperCase() + "%' ";
                break;
            }
            case EQUAL: {
                strFilter = FilterService.simpleCondition(filter, field, "=");
                break;
            }
            case NOT_EQUAL: {
                strFilter = FilterService.simpleCondition(filter, field, "!=");
                break;
            }
            case GREATER: {
                strFilter = FilterService.simpleCondition(filter, field, ">");
                break;
            }
            case GREATER_OR_EQUAL: {
                strFilter = FilterService.simpleCondition(filter, field, ">=");
                break;
            }
            case LESS: {
                strFilter = FilterService.simpleCondition(filter, field, "<");
                break;
            }
            case LESS_OR_EQUAL: {
                strFilter = FilterService.simpleCondition(filter, field, "<=");
                break;
            }
            case LAST_N: {
                System.out.println(timeZone);
                Date now = DateUtils.removeTime(DateUtils.applyTimezone(new Date(), timeZone));
                Date start = DateUtils.addDays(now, -1 * Integer.parseInt(filter.getValues().get(0)));
                strFilter = Fielder.name(field) + " BETWEEN '" + DateUtils.format(start, "YYYY-MM-dd") + "' AND '" + DateUtils.format(now, "YYYY-MM-dd") + "'";
            }
        }
        return strFilter;
    }

    public static String simpleCondition(SQLFilter filter, Field field, String operator2) throws ParseException {
        String strFilter;
        String lhs = Fielder.name(field);
        if (field.isNumber()) {
            strFilter = lhs + " " + operator2 + " " + Utils.h2Escape(filter.getValues().get(0));
        } else if (field.isDate()) {
            String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
            String rhs = null;
            if (filter.isGroupBy()) {
                rhs = filter.getValues().get(0);
            } else {
                try {
                    DateUtils.toDate(filter.getValues().get(0), pattern);
                }
                catch (ParseException pex) {
                    pattern = "yyyy/MM/dd";
                }
                rhs = new Timestamp(DateUtils.toDate(filter.getValues().get(0), pattern).getTime()).toString();
            }
            strFilter = lhs + " " + operator2 + " '" + rhs + "'";
            if ("BETWEEN".equals(operator2)) {
                strFilter = strFilter + " AND '" + new Timestamp(DateUtils.toDate(filter.getValues().get(1), pattern).getTime()) + "'";
            }
        } else {
            strFilter = lhs + " " + operator2 + " '" + Utils.h2Escape(filter.getValues().get(0)) + "'";
        }
        return strFilter;
    }

    private static boolean isInOperator(String operator2) {
        return operator2.equalsIgnoreCase("in") || operator2.equalsIgnoreCase("not_in");
    }

    private static boolean isEqualOperator(String operator2) {
        return operator2.equalsIgnoreCase("equal") || operator2.equalsIgnoreCase("not_equal");
    }

    static {
        operatorMapFE.put("equal", "=");
        operatorMapFE.put("not_equal", "!=");
        operatorMapFE.put("in", "in");
        operatorMapFE.put("not_in", "not in");
        operatorMapFE.put("less", "<");
        operatorMapFE.put("less_or_equal", "<=");
        operatorMapFE.put("greater", ">");
        operatorMapFE.put("greater_or_equal", ">=");
        operatorMapFE.put("contains", "~");
        operatorMapFE.put("not_contains", "!~");
        operatorMapFE.put("is_empty", "is");
        operatorMapFE.put("is_not_empty", "is not");
        operatorMapFE.put("between", "between");
        operatorMapFE.put("last_n", "in last N days");
        operatorMapFE.put("next_n", "in next N days");
        for (String key : operatorMapFE.keySet()) {
            operatorMapJIRA.put(operatorMapFE.get(key), key);
        }
    }
}

