/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.service.H2Functions;
import com.kaanha.reports.service.ReportingService;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldValueComparator<T>
implements Comparator<List<Object>> {
    Field field;
    int index;
    int dir = 1;
    boolean priority = false;
    private Map<String, Integer> priorities;
    static Logger logger = Logger.getLogger(ReportingService.class);

    public FieldValueComparator(Field field, Map<String, Integer> priorities) {
        this(field, 0, 1, priorities);
    }

    public FieldValueComparator(Field field, int index, int dir, Map<String, Integer> priorities) {
        this.field = field;
        this.index = index;
        this.dir = dir;
        if (Fielder.isPriority(field)) {
            this.priority = true;
        }
        this.priorities = priorities;
    }

    @Override
    public int compare(List<Object> l1, List<Object> l2) {
        try {
            if (l1.get(this.index) == null) {
                if (l2.get(this.index) == null) {
                    return this.dir * 0;
                }
                return this.dir * -1;
            }
            if (l2.get(this.index) == null) {
                return this.dir * 1;
            }
            String val1 = l1.get(this.index).toString();
            String val2 = l2.get(this.index).toString();
            if (this.priority) {
                Integer i1 = this.priorities.get(val1);
                Integer i2 = this.priorities.get(val2);
                if (i1 == null && i2 == null) {
                    return this.dir * val1.compareTo(val2);
                }
                if (i1 == null && i2 != null) {
                    return this.dir * -1;
                }
                if (i1 != null && i2 == null) {
                    return this.dir * 1;
                }
                return this.dir * i1.compareTo(i2);
            }
            if (this.field.isLink()) {
                val1 = H2Functions.AIO_UNLINK(val1);
                val2 = H2Functions.AIO_UNLINK(val2);
            }
            if (this.field.isDate()) {
                Date d1 = null;
                Date d2 = null;
                try {
                    d1 = DateUtils.toDate(val1, this.field.getPattern());
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
                try {
                    d2 = DateUtils.toDate(val2, this.field.getPattern());
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
                if (d1 == null && d2 == null) {
                    return this.dir * val1.compareTo(val2);
                }
                if (d1 == null && d2 != null) {
                    return this.dir * -1;
                }
                if (d1 != null && d2 == null) {
                    return this.dir * 1;
                }
                return this.dir * d1.compareTo(d2);
            }
            return this.dir * val1.compareTo(val2);
        }
        catch (Exception e2) {
            logger.error((Object)("marker1:" + e2.getMessage()), (Throwable)e2);
            logger.error((Object)("val1:" + l1 + ", val2:" + l2 + ", " + this.field.getId() + ", " + this.field.getId() + ", " + this.field.getName() + ", " + (Object)((Object)this.field.getType()) + ", " + this.field.getPattern()));
            return this.dir * l1.toString().compareTo(l2.toString());
        }
    }
}

