/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.Grid;
import com.kaanha.reports.model.GridCell;
import com.kaanha.reports.model.HeaderRow;
import com.kaanha.reports.service.H2Functions;
import com.kaanha.reports.service.ReportingService;
import com.smartxls.ChartFormat;
import com.smartxls.ChartShape;
import com.smartxls.RangeStyle;
import com.smartxls.WorkBook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportService {
    Workbook wb;
    Map<String, CellStyle> styles = Maps.newHashMap();
    WorkBook chartWb;
    CreationHelper helper;
    static Logger logger = Logger.getLogger(ExportService.class);

    public void export(DTO dto, String data) throws Exception {
        if (Utils.isGrid(dto)) {
            this.exportGrid(dto, data);
        } else {
            this.exportAxisChart(dto, data);
        }
    }

    public void export(List<DTO> dtos, List<String> resultss) throws Exception {
        for (int i2 = 0; i2 < dtos.size(); ++i2) {
            DTO dto = dtos.get(i2);
            this.export(dto, resultss.get(i2));
            if (this.chartWb == null) {
                this.chartWb = new WorkBook();
            }
            if (!Utils.isGrid(dto)) continue;
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            this.wb.write(boas);
            ByteArrayInputStream bias = new ByteArrayInputStream(boas.toByteArray());
            WorkBook temp = new WorkBook();
            temp.readXLSX(bias);
            if (this.chartWb.getNumSheets() < i2 + 1) {
                this.chartWb.insertSheets(i2, 1);
            }
            this.chartWb.CopySheetFromBook(temp, 0, i2);
        }
        this.chartWb.setSheet(0);
        this.wb = null;
    }

    /*
     * WARNING - void declaration
     */
    private void exportAxisChart(DTO dto, String data) throws Exception {
        int n2;
        if (this.chartWb == null) {
            this.chartWb = new WorkBook();
        } else {
            this.chartWb.insertSheets(this.chartWb.getNumSheets(), 1);
        }
        this.chartWb.setSheet(this.chartWb.getNumSheets() - 1);
        this.chartWb.setSheetName(this.chartWb.getNumSheets() - 1, this.sheetName(dto));
        JsonNode node = JsonUtils.stringToJsonNode(data);
        JsonNode dataFields = null;
        if (node.has("chartData")) {
            data = node.get("chartData").toString();
            dataFields = node.get("dataFields");
        }
        List<List<Object>> chartData = JsonUtils.stringToType(data, new TypeReference<List<List<Object>>>(){});
        Field rowField = dto.getRow().get(0);
        List<Field> aggregateFields = dto.getData();
        if (dto.getColumn().size() > 0) {
            int rowNum = 0;
            int j2 = 0;
            for (List<Object> section : chartData) {
                this.chartWb.setText(rowNum++, 0, this.titleForChartWithSegment(dataFields, rowField, j2));
                this.chartWb.setText(rowNum, 0, Fielder.fieldLabel(rowField));
                int i2 = 1;
                for (Field field : aggregateFields) {
                    this.chartWb.setText(rowNum, i2++, Fielder.fieldLabel(field));
                }
                this.setHeaderBold(rowNum - 1, 0, rowNum - 1, aggregateFields.size());
                this.setHeaderBold(rowNum, 0, rowNum, aggregateFields.size());
                ++rowNum;
                for (Object rowObj : section) {
                    List row = (List)rowObj;
                    int colNum = 0;
                    for (Object val : row) {
                        try {
                            this.chartWb.setNumber(rowNum, colNum, Double.parseDouble(val.toString()));
                        }
                        catch (NumberFormatException nfe) {
                            this.chartWb.setText(rowNum, colNum, val.toString());
                        }
                        ++colNum;
                    }
                    ++rowNum;
                }
                rowNum += 5;
                ++j2;
            }
        } else {
            this.chartWb.setText(0, 0, Fielder.fieldLabel(rowField));
            int i3 = 1;
            for (Field field : aggregateFields) {
                this.chartWb.setText(0, i3++, Fielder.fieldLabel(field));
            }
            i3 = 1;
            for (List list : chartData) {
                this.chartWb.setText(i3++, 0, list.get(0).toString());
            }
            for (int col = 0; col < aggregateFields.size(); ++col) {
                void var10_16;
                boolean bl2 = false;
                while (var10_16 < chartData.size()) {
                    if (chartData.get((int)var10_16).get(col + 1) != null) {
                        this.chartWb.setNumber((int)(var10_16 + true), col + 1, Double.parseDouble(chartData.get((int)var10_16).get(col + 1).toString()));
                    }
                    ++var10_16;
                }
            }
            this.setHeaderBold(0, 0, 0, aggregateFields.size());
        }
        short chartShape = 0;
        short dataLabelType = 4;
        boolean bl3 = true;
        if (dto.isBar() || dto.isTrend() && "bar".equalsIgnoreCase(dto.getTrendOutputFormat())) {
            chartShape = 0;
            dataLabelType = 1;
            boolean bl4 = true;
            if (dto.getColumn().size() > 0 && dataFields.size() > 1) {
                int n3 = dataFields.size();
            }
        }
        if (dto.isLine() || dto.isTrend() && "line".equalsIgnoreCase(dto.getTrendOutputFormat())) {
            chartShape = 1;
            dataLabelType = 1;
            boolean bl5 = true;
            if (dto.getColumn().size() > 0 && dataFields.size() > 1) {
                int n4 = dataFields.size();
            }
        }
        if (dto.isPie()) {
            chartShape = 6;
            dataLabelType = 4;
            n2 = aggregateFields.size();
        }
        for (int j3 = 0; j3 < n2; ++j3) {
            int left = aggregateFields.size() + 2;
            int top = 2 + 29 * j3 + j3;
            int right = left + 12;
            int bottom = top + 29;
            ArrayList _aggregateFields = Lists.newArrayList(aggregateFields);
            if (dto.isPie()) {
                _aggregateFields = Lists.newArrayList((Object[])new Field[]{aggregateFields.get(j3)});
            }
            List<Object> view = chartData;
            if (dto.getColumn().size() > 0) {
                List<Object> o2 = chartData.get(j3);
                view = o2;
            }
            ChartShape chart = this.addChart(view, rowField, _aggregateFields, chartShape, dataLabelType, left, top, right, bottom, dto.isPie(), j3, aggregateFields.size(), dto);
            if (dto.isPie()) {
                chart.setTitle(Fielder.fieldLabel(rowField) + " - " + Fielder.fieldLabel(aggregateFields.get(j3)));
                continue;
            }
            if (dto.getColumn().size() > 0) {
                chart.setTitle(this.titleForChartWithSegment(dataFields, rowField, j3));
                continue;
            }
            chart.setTitle(dto.getName());
        }
        int lastRow = this.chartWb.getLastRow();
        this.chartWb.setText(lastRow + 1, 0, "Exported on " + DateUtils.format(new Date(), "MMM-dd-yyyy 'at' hh:mm a") + " using All-In-One Reports for JIRA");
        this.chartWb.addHyperlink(lastRow + 1, 0, lastRow + 1, 0, "https://marketplace.atlassian.com/plugins/com.kaanha.reports", 1, "");
    }

    private void setHeaderBold(int sr, int er2, int sc, int ec2) throws Exception {
        RangeStyle rangeStyle = this.chartWb.getRangeStyle(sr, er2, sc, ec2);
        rangeStyle.setFontBold(true);
        rangeStyle.setWordWrap(true);
        this.chartWb.setRangeStyle(rangeStyle, sr, er2, sc, ec2);
    }

    private String titleForChartWithSegment(JsonNode dataFields, Field rowField, int j2) {
        return Fielder.fieldLabel(rowField) + " - " + (JsonUtils.isJsonNull(dataFields.get(j2).get("label")) ? dataFields.get(j2).get("name").asText() : dataFields.get(j2).get("label").asText());
    }

    private void addBanner(Workbook wb, DTO dto) {
        Sheet sheet = wb.getSheetAt(0);
        Row row = sheet.createRow(sheet.getLastRowNum() + 2);
        Cell cell = row.createCell(0);
        cell.setCellValue("Exported on " + DateUtils.format(DateUtils.convertToLocal(new Date(), dto.getTimezone()), "MMM-dd-yyyy 'at' hh:mm a") + " using All-In-One Reports for JIRA");
        cell.setCellStyle(this.styles.get("header"));
        Hyperlink url_link = this.helper.createHyperlink(HyperlinkType.URL);
        url_link.setAddress("https://marketplace.atlassian.com/plugins/com.kaanha.reports");
        cell.setHyperlink(url_link);
    }

    private ChartShape addChart(List<List<Object>> chartData, Field rowField, List<Field> aggregateFields, short chartShape, short dataLabelType, int left, int top, int right, int bottom, boolean isPie, int seriesIndex, int aggregateFieldsSize, DTO dto) throws Exception {
        ChartShape chart = this.chartWb.addChart(left, top, right, bottom);
        chart.setChartType(chartShape);
        if (dto.isBar() && dto.getColumn().size() > 0) {
            chart.setPlotStacked(true);
            chart.setBarGapRatio(-100);
        }
        String linkRange = "$A$1:$" + ExportService.getExcelColumnName(aggregateFieldsSize + 1) + "$" + (chartData.size() + 1);
        if (dto.getColumn().size() > 0) {
            int topLeft = seriesIndex * (chartData.size() + 7) + 2;
            linkRange = "$A$" + topLeft + ":$" + ExportService.getExcelColumnName(aggregateFieldsSize + 1) + "$" + (topLeft + chartData.size());
        }
        if (isPie) {
            linkRange = "$A$1:$A$" + (chartData.size() + 1) + ",$" + ExportService.getExcelColumnName(seriesIndex + 2) + "$1:$" + ExportService.getExcelColumnName(seriesIndex + 2) + "$" + (chartData.size() + 1);
        }
        chart.setLinkRange(linkRange, false);
        chart.setAxisTitle((short)0, 0, Fielder.fieldLabel(rowField));
        if (aggregateFields.size() == 1) {
            chart.setAxisTitle((short)1, 0, Fielder.fieldLabel(aggregateFields.get(0)));
        }
        int i2 = 0;
        chart.setVaryColors(true);
        for (Field field : aggregateFields) {
            chart.setSeriesName(i2, Fielder.fieldLabel(field));
            ChartFormat seriesFormat = chart.getSeriesFormat(i2);
            seriesFormat.setDataLabelType(dataLabelType);
            chart.setSeriesFormat(i2, seriesFormat);
            ++i2;
        }
        ChartFormat titleformat = chart.getTitleFormat();
        titleformat.setFontSize(280);
        titleformat.setFontUnderline(true);
        chart.setTitleFormat(titleformat);
        return chart;
    }

    private void exportGrid(DTO dto, String data) throws IOException {
        this.wb = new XSSFWorkbook();
        this.helper = this.wb.getCreationHelper();
        Font hlinkfont = this.createStyles(this.wb, dto);
        Grid grid = JsonUtils.stringToType(data, new TypeReference<Grid>(){});
        Sheet sheet = this.wb.createSheet(this.sheetName(dto));
        int rowNum = 0;
        for (HeaderRow headerRow : grid.getHeaderRows()) {
            int cellNum = 0;
            Row xlHeaderRow = sheet.createRow(rowNum);
            if (dto.isTimesheet() && rowNum == 0) {
                xlHeaderRow.setHeightInPoints(2.0f * sheet.getDefaultRowHeightInPoints());
            }
            for (GridCell gridCell : headerRow.getHeaderCells()) {
                Cell xlCell = xlHeaderRow.createCell(cellNum);
                cellNum = this.setCellValueStyleWidth(gridCell, xlCell, true, false, null, false, sheet, rowNum, cellNum, hlinkfont, false);
                ++cellNum;
            }
            ++rowNum;
        }
        HashMap dateIndex = Maps.newHashMap();
        ArrayList linkIndex = Lists.newArrayList();
        int _i = 0;
        ArrayList groupByIndex = Lists.newArrayList();
        boolean hasGroupBy = false;
        for (Field f2 : dto.getRow()) {
            if (f2.isGroupBy()) {
                groupByIndex.add(_i);
                hasGroupBy = true;
            }
            ++_i;
        }
        _i = 0;
        for (Field f2 : dto.getRow()) {
            int _gi;
            int n2 = _gi = hasGroupBy ? _i - this.numberOfGroupByFieldsBefore(groupByIndex, _i) : _i;
            if (f2.isDate()) {
                dateIndex.put(_gi, f2.getPattern());
            } else {
                dateIndex.put(_gi, null);
            }
            if (!f2.isGroupBy() && f2.isLink()) {
                linkIndex.add(_gi);
            }
            ++_i;
        }
        for (List<GridCell> dataRow : grid.getDataRows()) {
            int cellNum = 0;
            boolean groupHeaderRow = StringUtils.isNotBlank((String)dataRow.get(0).getS()) && dataRow.get(0).getS().contains("aio-gh");
            Row xlDataRow = sheet.createRow(rowNum);
            for (GridCell cell : dataRow) {
                boolean isDate = dateIndex.containsKey(cellNum) && dateIndex.get(cellNum) != null;
                boolean isLink = !groupHeaderRow && linkIndex.contains(cellNum);
                Cell xlCell = xlDataRow.createCell(cellNum);
                cellNum = this.setCellValueStyleWidth(cell, xlCell, false, isDate, (String)dateIndex.get(cellNum), isLink, sheet, rowNum, cellNum, hlinkfont, groupHeaderRow);
                ++cellNum;
            }
            ++rowNum;
        }
        boolean bl2 = false;
        Row xlDataRow = sheet.createRow(rowNum);
        for (GridCell cell : grid.getFooterRow()) {
            int n3;
            Cell xlCell = xlDataRow.createCell(n3);
            n3 = this.setCellValueStyleWidth(cell, xlCell, false, false, null, false, sheet, rowNum, n3, hlinkfont, false);
            ++n3;
        }
        for (int i2 = 0; i2 < sheet.getRow(0).getPhysicalNumberOfCells(); ++i2) {
            try {
                sheet.autoSizeColumn(i2);
                int w2 = sheet.getColumnWidth(i2);
                if (w2 <= 12800) continue;
                sheet.setColumnWidth(i2, 12800);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addBanner(this.wb, dto);
    }

    private String sheetName(DTO dto) {
        String sheetName = dto.getName();
        if ((sheetName = sheetName.replaceAll("[^A-Za-z0-9]", "_")).length() > 30) {
            sheetName = sheetName.substring(0, 29);
        }
        return sheetName;
    }

    private int numberOfGroupByFieldsBefore(List<Integer> groupByIndex, int _i) {
        int out = 0;
        for (Integer gbfi : groupByIndex) {
            if (gbfi >= _i) continue;
            ++out;
        }
        return out;
    }

    private int mergeCells(Sheet sheet, int rowNum, int cellNum, GridCell cell) {
        if (cell.getW() > 1) {
            int lastCol = cellNum + cell.getW() - 1;
            CellRangeAddress region = new CellRangeAddress(rowNum, rowNum, cellNum, lastCol);
            this.addBorder(region, sheet);
            sheet.addMergedRegion(region);
            cellNum = lastCol;
        }
        return cellNum;
    }

    private int setCellValueStyleWidth(GridCell cell, Cell xlCell, boolean header, boolean isDate, String pattern, boolean isLink, Sheet sheet, int rowNum, int cellNum, Font hlinkfont, boolean groupHeader) {
        block25: {
            Object objVal = cell.getV();
            if (objVal == null) {
                if (header) {
                    xlCell.setCellValue("");
                } else {
                    xlCell.setCellValue("-");
                }
            } else {
                String val = objVal.toString();
                try {
                    if (!isDate && NumberUtils.isNumber((String)val)) {
                        xlCell.setCellValue(Double.parseDouble(val));
                    } else if (isDate) {
                        if (StringUtils.isNumeric((String)val)) {
                            xlCell.setCellValue(Double.parseDouble(val));
                            isDate = false;
                        } else if ("Quarter".equalsIgnoreCase(pattern)) {
                            xlCell.setCellValue(val);
                            isDate = false;
                        } else {
                            xlCell.setCellValue(DateUtils.toDate(val, pattern));
                        }
                    } else if (isLink) {
                        String[] _val = Utils.getValueFromLink(val);
                        xlCell.setCellValue(_val[0]);
                        Hyperlink url_link = this.helper.createHyperlink(HyperlinkType.URL);
                        url_link.setAddress(StringUtils.replace((String)_val[1], (String)" ", (String)"%20"));
                        xlCell.setHyperlink(url_link);
                    } else if (groupHeader) {
                        xlCell.setCellValue(H2Functions.AIO_UNLINK(val));
                    } else {
                        xlCell.setCellValue(val);
                    }
                }
                catch (Exception e2) {
                    isDate = false;
                    try {
                        xlCell.setCellValue(val);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!iae.getMessage().contains("The maximum length of cell contents")) break block25;
                        xlCell.setCellValue(StringUtils.substring((String)val, (int)0, (int)32766));
                    }
                }
            }
        }
        String cellStyle = "cell";
        if (StringUtils.isNotBlank((String)cell.getS())) {
            cellStyle = cell.getS();
        } else if (header) {
            cellStyle = "header";
        }
        xlCell.setCellStyle(this.styles.get(cellStyle));
        if (isDate) {
            xlCell.setCellStyle(this.getDateStyle(cellStyle, DateUtils.getExcelDatePatternForJavaDatePattern(pattern)));
        }
        if (isLink) {
            CellUtil.setFont(xlCell, hlinkfont);
        }
        return this.mergeCells(sheet, rowNum, cellNum, cell);
    }

    private CellStyle getDateStyle(String originalStyle, String xlDatePattern) {
        String combinedDatePattern = originalStyle + "_" + xlDatePattern;
        if (this.styles.containsKey(combinedDatePattern)) {
            return this.styles.get(combinedDatePattern);
        }
        CellStyle combined = this.wb.createCellStyle();
        combined.cloneStyleFrom(this.styles.get(originalStyle));
        DataFormat df2 = this.wb.createDataFormat();
        combined.setDataFormat(df2.getFormat(xlDatePattern));
        this.styles.put(combinedDatePattern, combined);
        return combined;
    }

    private Font createStyles(Workbook wb, DTO dto) {
        short i2;
        short grey = IndexedColors.GREY_25_PERCENT.getIndex();
        Font tsHeaderFont = wb.createFont();
        tsHeaderFont.setBold(true);
        tsHeaderFont.setFontHeightInPoints((short)10);
        CellStyle style = wb.createCellStyle();
        style.setFont(tsHeaderFont);
        if (dto.isTimesheet()) {
            style.setWrapText(true);
        } else {
            style.setWrapText(false);
        }
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(grey);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.addBorder(style);
        this.styles.put("ts-header", style);
        Font tsDataFont = wb.createFont();
        tsDataFont.setFontHeightInPoints((short)10);
        style = wb.createCellStyle();
        style.setFont(tsDataFont);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(false);
        this.addBorder(style);
        this.styles.put("ts-data", style);
        Font weekendHeaderFont = wb.createFont();
        weekendHeaderFont.setBold(true);
        weekendHeaderFont.setFontHeightInPoints((short)10);
        style = wb.createCellStyle();
        style.setFont(weekendHeaderFont);
        style.setFillForegroundColor(grey);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        this.addBorder(style);
        this.styles.put(ReportingService.styleWeekendHeader(), style);
        Font weekendDataFont = wb.createFont();
        weekendDataFont.setFontHeightInPoints((short)10);
        style = wb.createCellStyle();
        style.setFont(weekendDataFont);
        style.setFillForegroundColor(grey);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(false);
        this.addBorder(style);
        this.styles.put(ReportingService.styleWeekendData(), style);
        Font totalFont = wb.createFont();
        totalFont.setBold(true);
        style = wb.createCellStyle();
        style.setFont(totalFont);
        style.setFillForegroundColor(grey);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (dto.isTimesheet()) {
            style.setAlignment(HorizontalAlignment.CENTER);
        }
        style.setWrapText(false);
        this.addBorder(style);
        this.styles.put("aio-total", style);
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        style = wb.createCellStyle();
        style.setFont(headerFont);
        style.setWrapText(false);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.addBorder(style);
        this.styles.put("header", style);
        style = wb.createCellStyle();
        this.addBorder(style);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        this.styles.put("cell", style);
        style = wb.createCellStyle();
        this.addBorder(style);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styles.put("aio-gh", style);
        for (i2 = 0; i2 < 10; i2 = (short)(i2 + 1)) {
            style = wb.createCellStyle();
            this.addBorder(style);
            style.setWrapText(true);
            style.setVerticalAlignment(VerticalAlignment.TOP);
            style.setFillForegroundColor((short)(IndexedColors.LIGHT_TURQUOISE.getIndex() + i2));
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (dto.isTimesheet()) {
                style.setAlignment(HorizontalAlignment.CENTER);
            }
            style.setFont(totalFont);
            this.styles.put("aio-total " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("X", i2), style);
            CellStyle newCellStyle = wb.createCellStyle();
            newCellStyle.cloneStyleFrom(style);
            newCellStyle.setIndention(i2);
            newCellStyle.setAlignment(HorizontalAlignment.LEFT);
            newCellStyle.setFont(headerFont);
            this.styles.put("aio-gh " + Utils.indexedStyle("aio-gh", i2) + " " + Utils.indexedStyle("aio-idt", i2), newCellStyle);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            style = wb.createCellStyle();
            style.setIndention(i2);
            this.styles.put(Utils.indexedStyle("aio-idt", i2), style);
        }
        Font hlinkfont = wb.createFont();
        hlinkfont.setUnderline((byte)1);
        hlinkfont.setColor(IndexedColors.BLUE.getIndex());
        return hlinkfont;
    }

    private void addBorder(CellStyle style) {
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
    }

    private void addBorder(CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderLeft(1, region, sheet);
        RegionUtil.setLeftBorderColor(IndexedColors.BLACK.getIndex(), region, sheet);
        RegionUtil.setBorderBottom(1, region, sheet);
        RegionUtil.setBottomBorderColor(IndexedColors.BLACK.getIndex(), region, sheet);
        RegionUtil.setBorderRight(1, region, sheet);
        RegionUtil.setRightBorderColor(IndexedColors.BLACK.getIndex(), region, sheet);
        RegionUtil.setBorderTop(1, region, sheet);
        RegionUtil.setTopBorderColor(IndexedColors.BLACK.getIndex(), region, sheet);
    }

    private static String getExcelColumnName(int number) {
        StringBuilder sb = new StringBuilder();
        int num = number - 1;
        while (num >= 0) {
            int numChar = num % 26 + 65;
            sb.append((char)numChar);
            num = num / 26 - 1;
        }
        return sb.reverse().toString();
    }

    public void writeFileToOutputStream(OutputStream os, String format) throws Exception {
        if ("pdf".equals(format)) {
            this.exportPDF(os);
        } else {
            this.exportXLSX(os);
        }
        os.flush();
    }

    private void exportXLSX(OutputStream os) throws Exception {
        if (this.wb != null) {
            this.wb.write(os);
        } else {
            this.chartWb.writeXLSX(os);
        }
        os.flush();
    }

    private void exportPDF(OutputStream os) throws Exception {
        if (this.wb != null) {
            String fname = "aio_export_" + System.currentTimeMillis() + ".xlsx";
            File tempFile = new File(fname);
            FileOutputStream fout = new FileOutputStream(tempFile);
            this.wb.write(fout);
            fout.close();
            WorkBook _wb = new WorkBook();
            _wb.readXLSX(new FileInputStream(tempFile));
            _wb.exportPDF(os);
            os.flush();
            tempFile.delete();
        } else {
            this.chartWb.exportPDF(os);
            os.flush();
        }
    }
}

