/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.servlet.ViewServletUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailService {
    private JavaMailSenderImpl mailSender;
    private VelocityEngine velocityEngine = ViewServletUtils.initVelocity();
    private Template template;
    static Logger logger = Logger.getLogger(EmailService.class);

    public EmailService() throws Exception {
        String templateName = "views/email-subscription.vm";
        this.template = this.velocityEngine.getTemplate(templateName);
    }

    private void sendEmail(MimeMessageHelper message) throws Exception {
        JavaMailSenderImpl ms = this.getMailSender();
        MimeMessage mimeMessage = message.getMimeMessage();
        Thread.currentThread().setContextClassLoader(Message.class.getClassLoader());
        ms.send(mimeMessage);
    }

    public void sendSubscriptionEmail(AioUser scheduleOwner, AioUser recipient, String attachmentname, byte[] data, String unsubscribeLink, String publishedLink, boolean publish, String emailUrlPrefix) throws Exception {
        SMTPMailServer smtp;
        String toEmail = recipient.getEmailAddress();
        logger.debug((Object)("Sending subscription email: " + toEmail + ", owner: " + scheduleOwner.getEmailAddress()));
        String htmlContent = "";
        String subject = "JIRA Report Subscription: " + attachmentname;
        String publishedUrl = emailUrlPrefix + "/published?link=" + publishedLink;
        String unsubscribeUrl = emailUrlPrefix + "/unsubscribe?link=" + unsubscribeLink;
        if (scheduleOwner.getPreferences() != null && scheduleOwner.getPreferences().isCustomEmailTemplate()) {
            subject = scheduleOwner.getPreferences().getEmailSubject();
            StringBuffer body = new StringBuffer("<div>" + StringUtils.replace((String)scheduleOwner.getPreferences().getEmailBody(), (String)"\n", (String)"<br/>") + "</div>");
            if (publish && StringUtils.isNotBlank((CharSequence)publishedLink)) {
                body.append("<br/><div>The report can be accessed online <a href='" + publishedUrl + "'>here</a></div><br />");
            }
            if (StringUtils.isNotBlank((CharSequence)unsubscribeLink)) {
                body.append("<div><a href='" + unsubscribeUrl + "'>Click here</a> to unsubscribe from this email</div>");
            }
            htmlContent = body.toString();
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("name", (Object)(StringUtils.isBlank((CharSequence)recipient.getDisplayName()) ? recipient.getUsername() : recipient.getDisplayName()));
            ctx.put("reportName", (Object)attachmentname);
            ctx.put("ownerName", (Object)(StringUtils.isBlank((CharSequence)scheduleOwner.getDisplayName()) ? scheduleOwner.getUsername() : scheduleOwner.getDisplayName()));
            ctx.put("ownerEmail", (Object)(StringUtils.isBlank((CharSequence)scheduleOwner.getEmailAddress()) ? scheduleOwner.getUsername() : "(" + scheduleOwner.getEmailAddress() + ")"));
            ctx.put("logoUrl", (Object)"https://www.jirareports.com/jr/images/aiojr-logo.png");
            if (StringUtils.isNotBlank((CharSequence)unsubscribeLink)) {
                ctx.put("unsubscribeUrl", (Object)unsubscribeUrl);
            }
            if (publish && StringUtils.isNotBlank((CharSequence)publishedLink)) {
                ctx.put("publishedUrl", (Object)publishedUrl);
            } else {
                ctx.put("publishedUrl", null);
            }
            StringWriter writer = new StringWriter();
            this.template.merge((Context)ctx, (Writer)writer);
            htmlContent = writer.toString();
        }
        MimeMessageHelper message = this.createMessage();
        message.setSubject(subject);
        String fromEmail = "noreply@jirareports.com";
        String fromName = "All-In-One Reports";
        if (!Utils.hasEnvProperty("smtp_mail_host") && (smtp = MailFactory.getServerManager().getDefaultSMTPMailServer()) != null && StringUtils.isNotBlank((CharSequence)smtp.getDefaultFrom())) {
            fromEmail = smtp.getDefaultFrom();
            fromName = smtp.getName();
        }
        message.setFrom(fromEmail, fromName);
        message.setTo(toEmail);
        message.setText(htmlContent, true);
        message.addAttachment(attachmentname, (InputStreamSource)new ByteArrayResource(data));
        this.sendEmail(message);
        logger.debug((Object)"Done sending subscription email");
    }

    private MimeMessageHelper createMessage() throws Exception, MessagingException {
        MimeMessage mimeMessage = this.getMailSender().createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        return message;
    }

    private JavaMailSenderImpl getMailSender() throws Exception {
        if (this.mailSender == null) {
            this.mailSender = new JavaMailSenderImpl();
            Properties javaMailProperties = new Properties();
            javaMailProperties.setProperty("mail.debug", "false");
            if (Utils.hasEnvProperty("smtp_mail_host")) {
                javaMailProperties.setProperty("mail.transport.protocol", "smtp");
                javaMailProperties.setProperty("mail.smtp.auth", "true");
                javaMailProperties.setProperty("mail.smtp.starttls.enable", "true");
                this.mailSender.setHost(Utils.getEnvProperty("smtp_mail_host"));
                this.mailSender.setPort(Integer.parseInt(Utils.getEnvProperty("smtp_mail_port")));
                this.mailSender.setUsername(Utils.getEnvProperty("smtp_mail_username"));
                this.mailSender.setPassword(Utils.getEnvProperty("smtp_mail_password"));
            } else {
                SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
                if (smtp != null) {
                    javaMailProperties.setProperty("mail.smtp.auth", "" + StringUtils.isNotBlank((CharSequence)smtp.getUsername()));
                    javaMailProperties.setProperty("mail.smtp.starttls.enable", "" + smtp.isTlsRequired());
                    this.mailSender.setHost(smtp.getHostname());
                    this.mailSender.setProtocol(smtp.getMailProtocol().getProtocol());
                    if (StringUtils.isNotBlank((CharSequence)smtp.getPort())) {
                        this.mailSender.setPort(Integer.parseInt(smtp.getPort()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)smtp.getUsername())) {
                        this.mailSender.setUsername(smtp.getUsername());
                    }
                    if (StringUtils.isNotBlank((CharSequence)smtp.getPassword())) {
                        this.mailSender.setPassword(smtp.getPassword());
                    }
                } else {
                    System.out.println("AIO: NOT ABLE TO SEND SUBSCRIPTION REPORTS. NO EMAIL SERVER SPECIFIED IN JIRA SETTINGS.");
                }
            }
            this.mailSender.setJavaMailProperties(javaMailProperties);
        }
        return this.mailSender;
    }

    public void sendErrorEmail(Exception e2, String prepend, String postData) {
        if (Utils.hasEnvProperty("smtp_mail_host")) {
            try {
                MimeMessageHelper message = this.createMessage();
                message.setSubject("AIO Reports Error (" + Utils.getEnvironment() + ")");
                message.setFrom("noreply@jirareports.com", "All-In-One Reports");
                message.setTo("info@jirareports.com");
                message.setText(prepend + "\n\n" + ExceptionUtils.getFullStackTrace((Throwable)e2) + "\n\n" + postData, false);
                this.sendEmail(message);
            }
            catch (Exception ex2) {
                logger.error((Object)ex2.getMessage(), (Throwable)ex2);
            }
        }
    }

    public void sendSubscriptionErrorEmail(String displayName, String emailAddress, String attachmentname, String failureMessage) throws MessagingException, Exception {
        MimeMessageHelper message = this.createMessage();
        message.setSubject("[Failed] JIRA Report Subscription: " + attachmentname);
        message.setFrom("noreply@jirareports.com", "All-In-One Reports");
        message.setTo(emailAddress);
        StringBuilder messagetext = new StringBuilder();
        messagetext.append("Hello, " + displayName + "!");
        messagetext.append("<br/><br/>");
        messagetext.append("Scheduled execution of your subscribed All-In-One JIRA report [" + attachmentname + "] has failed due to the reason mentioned below: ");
        messagetext.append("<br/><br/>");
        messagetext.append("<b>" + failureMessage + "</b>");
        messagetext.append("<br/><br/>");
        messagetext.append("Please correct the problem and save the report to be processed again on the next scheduled time.");
        messagetext.append("<br/><br/>");
        messagetext.append("Regards,");
        messagetext.append("<br/>");
        messagetext.append("All-In-One Reports Team");
        message.setText(messagetext.toString(), true);
        this.sendEmail(message);
    }
}

