/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.kaanha.reports.helper.DataMigrationUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.FilterType;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSharedReport;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.persistence.legacy.hosted.Report;
import com.kaanha.reports.persistence.legacy.hosted.User;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataMigrationHosted
implements PluginUpgradeTask {
    PluginSettings settings;
    ActiveObjects ao;
    UserManager userManager;
    private TimeZoneManager timeZoneManager;

    public DataMigrationHosted(PluginSettingsFactory pluginSettingsFactory, ActiveObjects ao2, UserManager userManager, TimeZoneManager timeZoneManager) {
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.ao = ao2;
        this.userManager = userManager;
        this.timeZoneManager = timeZoneManager;
    }

    public Collection<Message> doUpgrade() throws Exception {
        PersistenceService ps = PersistenceService.createHostedInstance(this.ao);
        UserPersistenceService ups = new UserPersistenceService();
        ReportPersistenceService rps = new ReportPersistenceService();
        this.migrateUsers(ups);
        this.migrateReports(ups, rps, ps);
        return null;
    }

    private void migrateUsers(UserPersistenceService ups) throws SQLException {
        User[] legacyUsers;
        for (User u2 : legacyUsers = (User[])this.ao.find(User.class)) {
            this.findOrCreateUser(ups, u2.getUserkey());
        }
    }

    private void migrateReports(UserPersistenceService ups, ReportPersistenceService rps, PersistenceService ps) throws Exception {
        Report[] legacyReports;
        for (Report r2 : legacyReports = (Report[])this.ao.find(Report.class)) {
            try {
                if (r2.getCanned() != null && r2.getCanned().booleanValue()) continue;
                AioReport[] _alreadyMigrated = rps.findByLegacyId(r2.getID());
                if (_alreadyMigrated != null) {
                    boolean first = true;
                    if (r2.isDeleted()) {
                        first = false;
                    }
                    for (AioReport _ar : _alreadyMigrated) {
                        if (first) {
                            first = false;
                            continue;
                        }
                        rps.delete(_ar.getID(), _ar.getOwner());
                    }
                    continue;
                }
                if (r2.isDeleted()) continue;
                DTO dto = new DTO();
                dto.setType(r2.getType());
                dto.setName(r2.getName());
                dto.setRow(DataMigrationUtils.converStringToField(r2.getRow()));
                dto.setColumn(DataMigrationUtils.converStringToField(r2.getColumn()));
                dto.setData(DataMigrationUtils.converStringToField(r2.getData()));
                dto.setStartDate(r2.getStartDate());
                dto.setEndDate(r2.getEndDate());
                dto.setFilterType(StringUtils.isBlank((CharSequence)r2.getFilterType()) || "jirafilter".equalsIgnoreCase(r2.getFilterType()) ? FilterType.jira : FilterType.valueOf(r2.getFilterType()));
                String jql = StringUtils.replace((String)r2.getJql(), (String)"(\"created\" >= startOfDay(-100d) and \"created\" < startOfDay()) AND", (String)"");
                jql = StringUtils.replace((String)jql, (String)"issuetype in (Bug, Defect)", (String)"");
                if (FilterType.jira.equals((Object)dto.getFilterType())) {
                    dto.setFilterValue(r2.getJiraFilterId());
                }
                if (FilterType.jql.equals((Object)dto.getFilterType())) {
                    dto.setFilterValue(jql);
                }
                if (FilterType.custom.equals((Object)dto.getFilterType())) {
                    dto.setFilterType(FilterType.jql);
                    dto.setFilterValue(jql);
                }
                if (StringUtils.isBlank((CharSequence)r2.getTimesheetUsers())) {
                    dto.setUsers(Lists.newArrayList());
                } else {
                    dto.setUsers(JsonUtils.stringToType(r2.getTimesheetUsers(), new TypeReference<List<JsonNode>>(){}));
                }
                dto.setProjects(DataMigrationUtils.splitAndRemoveDoubleQuotes(r2.getTimesheetProjects()));
                dto.setDateRange(DataMigrationUtils.convertDateRangeDesc(r2.getDateRangeDesc()));
                dto.setIssueTypes(DataMigrationUtils.splitAndRemoveDoubleQuotes(r2.getIssueType()));
                dto.setSubIssueTypes(DataMigrationUtils.splitAndRemoveDoubleQuotes(r2.getSubIssueTypes()));
                dto.setIncludeSubTasks(r2.getIncludeSubTask() == null ? false : r2.getIncludeSubTask());
                if (dto.isTrend()) {
                    dto.setTrendField(r2.getRow());
                    dto.setTrendValues(Lists.newArrayList((Object[])r2.getData().split(",")));
                    dto.setTrendInterval(r2.getColumn().toLowerCase());
                    dto.setBreakByIssueType(r2.getIncludeSubTask() == null ? false : r2.getIncludeSubTask());
                    dto.setShowPercentages(r2.getShowPercentage() == null ? false : r2.getShowPercentage());
                    dto.setShowCumulative(!r2.getTmIssueBreakdown());
                    dto.setTrendOutputFormat("line");
                }
                dto.setQuickTimesheet(r2.getQuickTimesheet() == null ? false : r2.getQuickTimesheet());
                dto.setBaseJql(jql);
                dto.setLegacyReportId(r2.getID());
                dto.setCanned(r2.getCanned() == null ? false : r2.getCanned());
                AioUser owner = this.findOrCreateUser(ups, r2.getUserkey());
                if (owner == null) continue;
                dto = rps.save(dto, owner);
                try {
                    if (r2.getSharedWithUsers().length <= 0) continue;
                    for (User u2 : r2.getSharedWithUsers()) {
                        AioUser shareAioUser = this.findOrCreateUser(ups, u2.getUserkey());
                        if (shareAioUser == null) continue;
                        AioSharedReport sr = ps.create(AioSharedReport.class);
                        sr.setReport(ps.findById(AioReport.class, dto.getAioReportId()));
                        sr.setUser(shareAioUser);
                        ps.save(sr);
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public AioUser findOrCreateUser(UserPersistenceService ups, String userkey) throws SQLException {
        UserProfile jiraUser;
        AioUser owner = ups.findByUserkey(userkey);
        if (owner == null && (jiraUser = this.userManager.getUserProfile(new UserKey(userkey))) != null) {
            owner = ups.createUserForHosted(jiraUser, this.timeZoneManager);
        }
        return owner;
    }

    public int getBuildNumber() {
        if (this.ao.count(Report.class) > 0) {
            return 3;
        }
        return 0;
    }

    public String getPluginKey() {
        return "com.kaanha.reports";
    }

    public String getShortDescription() {
        return "Migrates AIO reports data to new format";
    }
}

