/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.CompositeCrosstabKey;
import com.kaanha.reports.model.CrosstabKey;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.DataSet;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.FieldType;
import com.kaanha.reports.model.LinkType;
import com.kaanha.reports.service.FilterService;
import com.kaanha.reports.service.H2Function;
import com.kaanha.reports.service.H2Functions;
import com.kaanha.reports.service.SchemaBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.h2.tools.Server;

public class DBEngine {
    private static int datamartID = 0;
    private static DBEngine dbEngine;
    private static final String DB_DRIVER = "org.h2.Driver";
    private static final String DBNAME = "aio-db";
    private static final String DB_CONNECTION = "jdbc:h2:mem:aio-db;DB_CLOSE_DELAY=-1";
    private static final String DB_USER = "";
    private static final String DB_PASSWORD = "";
    static Logger logger;

    public static DBEngine getInstance() throws Exception {
        if (dbEngine == null) {
            dbEngine = new DBEngine();
        }
        return dbEngine;
    }

    public List<Map<String, Object>> queryMartForMap(String datamartID, DTO dto) throws Exception {
        StringBuffer sql = this.buildSQL(datamartID, dto, dto.getAllFields());
        if (StringUtils.isBlank((CharSequence)sql.toString())) {
            return Lists.newArrayList();
        }
        return this.queryForMap(sql.toString());
    }

    public List<List<Object>> queryMartForList(String datamartID, DTO dto) throws Exception {
        StringBuffer sql = this.buildSQL(datamartID, dto, dto.getAllFields());
        if (StringUtils.isBlank((CharSequence)sql.toString())) {
            return Lists.newArrayList();
        }
        return this.queryForList(sql.toString());
    }

    public List<List<Object>> queryMartForTotals(String datamartID, DTO dto, String totalType) throws JsonParseException, JsonMappingException, ParseException, IOException, Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList select = Lists.newArrayList();
        ArrayList groupByFilters = Lists.newArrayList();
        ArrayList nonGroupByRowFields = Lists.newArrayList();
        for (Field f2 : dto.getRow()) {
            if (f2.isGroupBy()) {
                groupByFilters.addAll(FilterService.nonAggregateFilters(dto, Lists.newArrayList((Object[])new Field[]{f2})));
                continue;
            }
            nonGroupByRowFields.add(f2);
        }
        List queryFields = Lists.newArrayList();
        ArrayList groupByColumnNames = Lists.newArrayList();
        if (dto.isList()) {
            queryFields = nonGroupByRowFields.subList(1, nonGroupByRowFields.size());
        } else {
            if ("COLUMN".equals(totalType)) {
                queryFields.addAll(dto.getColumn());
            }
            queryFields.addAll(dto.getData());
        }
        if ("ROW".equals(totalType)) {
            for (Field f3 : dto.getRow()) {
                select.add(Fielder.name(f3) + " " + f3.getColumnName());
                groupByColumnNames.add(Fielder.name(f3));
            }
        }
        for (Field f3 : queryFields) {
            if (f3.isMeasure() && !Fielder.isPercentCompletion(f3) && f3.getBuckets().size() == 0) {
                if (StringUtils.isBlank((CharSequence)f3.getAggregateFunction()) || Fielder.isCount(f3)) {
                    select.add("NVL(SUM(" + Fielder.name(f3) + "),0) " + f3.getColumnName());
                    continue;
                }
                if ("AVG".equals(f3.getAggregateFunction())) {
                    String helperId = f3.getId() + "_AVG_HLP";
                    String helperColumnName = Fielder.findInFields(helperId, dto.getHelpers()).getColumnName();
                    select.add("NVL(ROUND((SUM(" + helperColumnName + ")/AIO_NONZERO(SUM(" + helperColumnName + "/AIO_NONZERO(" + f3.getColumnName() + ")))),2),0) " + f3.getColumnName());
                    continue;
                }
                if (f3.isPercent()) {
                    String percentOver = Fielder.findInFields(f3.getId() + "_PCT_HLP", dto.getHelpers()).getColumnName();
                    select.add("NVL(ROUND(" + f3.getAggregateFunction() + "(" + Fielder.name(f3) + "*" + percentOver + ")/AIO_NONZERO(" + f3.getAggregateFunction() + "(" + percentOver + ")),2),0) " + f3.getColumnName());
                    continue;
                }
                select.add("NVL(ROUND(" + f3.getAggregateFunction() + "(" + Fielder.name(f3) + "),2),0) " + f3.getColumnName());
                continue;
            }
            if (dto.isList()) {
                select.add("'-'");
                continue;
            }
            select.add(Fielder.name(f3) + " " + f3.getColumnName());
            groupByColumnNames.add(Fielder.name(f3));
        }
        if (select.size() > 0) {
            sql.append("SELECT DISTINCT " + DBEngine.join(select) + this.from(datamartID));
            if (groupByFilters.size() > 0) {
                sql.append(" WHERE " + Joiner.on((String)" AND ").join((Iterable)groupByFilters));
            }
            if (!dto.isList() && groupByColumnNames.size() > 0) {
                sql.append(" GROUP BY " + DBEngine.join(groupByColumnNames));
            }
            return this.queryForList(sql.toString());
        }
        return Lists.newArrayList();
    }

    private String groupBy(Collection<Field> fields) {
        ArrayList nonAggregateColumnNames = Lists.newArrayList();
        for (Field f2 : fields) {
            if (f2.isAggregate()) continue;
            nonAggregateColumnNames.add(Fielder.name(f2));
        }
        if (nonAggregateColumnNames.size() > 0) {
            return " GROUP BY " + DBEngine.join(nonAggregateColumnNames);
        }
        return "";
    }

    public List<CrosstabKey> queryMartForCrosstabColumns(String datamartID, DTO dto) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        ArrayList subTables = Lists.newArrayList();
        ArrayList columnNames = Lists.newArrayList();
        for (Field f2 : dto.getColumn()) {
            subTables.add("(" + this.buildSQL(datamartID, dto, Lists.newArrayList((Object[])new Field[]{f2})) + ")");
            columnNames.add(f2.getColumnName());
        }
        sql.append(DBEngine.join(subTables) + " ORDER BY " + DBEngine.join(columnNames) + " DESC");
        return this.queryToKey(sql.toString(), dto.getColumn());
    }

    public List<CrosstabKey> queryMartForCrosstabRows(String datamartID, DTO dto) throws Exception {
        StringBuffer sql = this.buildSQL(datamartID, dto, dto.getRow());
        return this.queryToKey(sql.toString(), dto.getRow());
    }

    public Map<CompositeCrosstabKey, List<Object>> queryMartForCrosstabData(String datamartID, DTO dto) throws Exception {
        StringBuffer sql = this.buildSQL(datamartID, dto, dto.getAllFields());
        return this.queryToCompositeKey(sql.toString(), dto);
    }

    private StringBuffer buildSQL(String datamartID, DTO dto, List<Field> fields) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList select = Lists.newArrayList();
        if (dto.isTableau()) {
            for (Field f2 : fields) {
                if (f2.isDate()) {
                    select.add("AIO_FORMATDATETIME(" + Fielder.name(f2) + ", 'yyyy-MM-dd HH:mm:ss') " + f2.getColumnName());
                    continue;
                }
                select.add(f2.getColumnName());
            }
            sql.append("SELECT " + DBEngine.join(select) + this.from(datamartID));
        } else {
            ArrayList groupByFilters = Lists.newArrayList();
            for (Field f3 : fields) {
                if (f3.isGroupBy()) {
                    groupByFilters.addAll(FilterService.nonAggregateFilters(dto, Lists.newArrayList((Object[])new Field[]{f3})));
                }
                select.add(Fielder.name(f3) + " " + f3.getColumnName());
            }
            sql.append("SELECT DISTINCT " + DBEngine.join(select) + this.from(datamartID));
            if (groupByFilters.size() > 0) {
                sql.append(" WHERE " + Joiner.on((String)" AND ").join((Iterable)groupByFilters));
            }
            sql = this.orderBy(sql, fields, dto.getPriorities());
        }
        return sql;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuffer orderBy(StringBuffer sql, List<Field> fields, Map<String, Integer> priorities) {
        void var6_13;
        ArrayList orderByClauses = Lists.newArrayList();
        for (Field field : fields) {
            if (!StringUtils.isNotBlank((CharSequence)field.getSortDir()) || "none".equals(field.getSortDir())) continue;
            orderByClauses.add("");
        }
        boolean createWrapper = false;
        for (Field f3 : fields) {
            if (!StringUtils.isNotBlank((CharSequence)f3.getSortDir()) || "none".equals(f3.getSortDir())) continue;
            int index = f3.getSortCounter() - 1;
            if (index >= orderByClauses.size()) {
                index = 0;
            }
            String exp = f3.getColumnName();
            if (f3.isDate()) {
                exp = "AIO_TODATE(" + f3.getColumnName() + ",'" + f3.getPattern() + "')";
            } else if (f3.isLink()) {
                exp = "AIO_UNLINK(" + f3.getColumnName() + ")";
            } else if (Fielder.isPriority(f3)) {
                try {
                    exp = "AIO_PRIORITY(" + f3.getColumnName() + ",'" + JsonUtils.objectToJsonString(priorities) + "')";
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            if (!exp.equalsIgnoreCase(f3.getColumnName())) {
                createWrapper = true;
            }
            orderByClauses.set(index, exp + " " + (f3.getSortDir().equals("up") ? "ASC" : "DESC"));
        }
        Iterator iterator = orderByClauses.iterator();
        while (iterator.hasNext()) {
            if (!StringUtils.isBlank((CharSequence)((CharSequence)iterator.next()))) continue;
            iterator.remove();
        }
        String string = "";
        if (orderByClauses.size() > 0) {
            String string2 = DBEngine.join(orderByClauses);
        } else {
            String string3 = fields.get(0).getColumnName() + " ASC";
        }
        if (createWrapper) {
            sql = new StringBuffer("SELECT * FROM (" + sql.toString() + ") ORDER BY " + (String)var6_13);
        } else {
            sql.append(" ORDER BY " + (String)var6_13);
        }
        return sql;
    }

    private void createFunctionAliases() throws Exception {
        for (Method m2 : H2Functions.class.getMethods()) {
            if (!m2.isAnnotationPresent(H2Function.class)) continue;
            String sql = "CREATE ALIAS " + m2.getName() + " FOR \"" + H2Functions.class.getName() + "." + m2.getName() + "\"";
            try {
                this.execute(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql) throws Exception {
        Statement stmt = null;
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            stmt.execute(sql);
            stmt.close();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> queryForMap(String sql) throws Exception {
        ArrayList out = Lists.newArrayList();
        Statement stmt = null;
        try (Connection connection = this.getConnection();){
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData metadata = rs.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            while (rs.next()) {
                HashMap row = Maps.newHashMap();
                for (int i2 = 0; i2 < numberOfColumns; ++i2) {
                    String columnName = metadata.getColumnLabel(i2 + 1);
                    row.put(columnName, rs.getObject(columnName));
                }
                out.add(row);
            }
            stmt.close();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Object>> queryForList(String sql) throws Exception {
        ArrayList out = Lists.newArrayList();
        Statement stmt = null;
        try (Connection connection = this.getConnection();){
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData metadata = rs.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            while (rs.next()) {
                ArrayList row = Lists.newArrayList();
                for (int i2 = 0; i2 < numberOfColumns; ++i2) {
                    String columnName = metadata.getColumnLabel(i2 + 1);
                    row.add(rs.getObject(columnName));
                }
                out.add(row);
            }
            stmt.close();
        }
        return out;
    }

    private ResultSet query(String sql) throws Exception {
        Connection connection = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        stmt = connection.createStatement();
        rs = stmt.executeQuery(sql);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchUpdate(String sql, List<List<Object>> batchList) throws Exception {
        Connection dbConnection = null;
        Statement preparedStatement = null;
        try {
            dbConnection = this.getConnection();
            preparedStatement = dbConnection.prepareStatement(sql);
            dbConnection.setAutoCommit(false);
            for (List<Object> row : batchList) {
                for (int j2 = 0; j2 < row.size(); ++j2) {
                    Object val = row.get(j2);
                    preparedStatement.setObject(j2 + 1, val);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            dbConnection.commit();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
    }

    List<List<Object>> queryMartForUniqueValues(String datamartID, DTO dto, List<Field> fields) throws Exception {
        StringBuffer sql = this.buildSQL(datamartID, dto, fields);
        return this.queryForList(sql.toString());
    }

    public String createMartNew(DataSet dataset, DTO dto) throws Exception {
        String baseMartId;
        boolean hasWorklog = false;
        boolean hasHistory = false;
        boolean hasMixedAgg = false;
        Field worklogField = Fielder.findInFields("worklog", dto.getQueryFields());
        Field historyField = Fielder.findInFields("changelog", dto.getQueryFields());
        Field issueKeyField = Fielder.findInFields("issuekey", dto.getSchema());
        List<Field> allFields = dto.getAllFields();
        ArrayList origColumnNames = Lists.newArrayList();
        if (dto.isTableau()) {
            for (Field f2 : allFields) {
                origColumnNames.add(f2.getColumnName());
            }
            for (Field f2 : dto.getQueryFields()) {
                f2.setColumnName("");
            }
        }
        if (worklogField != null) {
            hasWorklog = true;
        }
        if (historyField != null) {
            hasHistory = true;
        }
        for (Field f2 : allFields) {
            if (f2.isAggregate() && Fielder.isNonWorklogField(f2) && hasWorklog) {
                hasMixedAgg = true;
                break;
            }
            if (!f2.isAggregate() || !Fielder.isNonHistoryField(f2) || !hasHistory) continue;
            hasMixedAgg = true;
            break;
        }
        if (!dto.isTableau()) {
            Fielder.addHelpers(dto);
            allFields = dto.getAllFields(true);
        }
        String finalMartId = baseMartId = this.datamartID();
        if (!hasMixedAgg) {
            this.createBaseMart(baseMartId, dto, dataset, hasWorklog, hasHistory);
            finalMartId = this.createCombinedMart(baseMartId, dto, dataset, hasWorklog, hasHistory, issueKeyField, worklogField, historyField);
            finalMartId = this.processRawMart(finalMartId, dto, allFields, origColumnNames);
        } else {
            this.createBaseMart(baseMartId, dto, dataset, hasWorklog, hasHistory);
            Collection<Field> baseFields = dto.getAllFields();
            baseFields = Fielder.nonWorklogFields(baseFields);
            baseFields = Fielder.nonHistoryFields(baseFields);
            String finalBaseMartId = this.processRawMart(baseMartId, dto, baseFields, null);
            Collection<Field> nonAggrBaseFields = Fielder.nonAggregateFields(baseFields);
            Collection<Field> nonAggrBaseFieldsClone = JsonUtils.stringToType(JsonUtils.objectToJsonString(nonAggrBaseFields), new TypeReference<Collection<Field>>(){});
            if (hasWorklog) {
                String worklogDatamartID = this.createCombinedMart(baseMartId, dto, dataset, hasWorklog, false, issueKeyField, worklogField, null);
                ArrayList nonAggrBasePlusWlFields = Lists.newArrayList();
                nonAggrBasePlusWlFields.addAll(nonAggrBaseFieldsClone);
                Collection<Field> worklogFields = Fielder.worklogFields(allFields);
                nonAggrBasePlusWlFields.addAll(worklogFields);
                String finalWorklogMartId = this.processRawMart(worklogDatamartID, dto, nonAggrBasePlusWlFields, null);
                Fielder.removeHiddenFields(worklogFields);
                finalMartId = this.mergeMarts(finalBaseMartId, finalWorklogMartId, baseFields, worklogFields, nonAggrBaseFields);
            }
            if (hasHistory) {
                String historyDatamartID = this.createCombinedMart(baseMartId, dto, dataset, false, hasHistory, issueKeyField, null, historyField);
                ArrayList nonAggrBasePlusHsFields = Lists.newArrayList();
                nonAggrBasePlusHsFields.addAll(nonAggrBaseFieldsClone);
                Collection<Field> historyFields = Fielder.historyFields(allFields);
                nonAggrBasePlusHsFields.addAll(historyFields);
                String finalHistoryMartId = this.processRawMart(historyDatamartID, dto, nonAggrBasePlusHsFields, null);
                Fielder.removeHiddenFields(historyFields);
                finalMartId = this.mergeMarts(finalBaseMartId, finalHistoryMartId, baseFields, historyFields, nonAggrBaseFields);
            }
        }
        if (!dto.isTableau()) {
            Fielder.removeHelpers(dto);
            dto.getAllFields(true);
        }
        return finalMartId;
    }

    private String mergeMarts(String finalBaseMartId, String secondMartId, Collection<Field> baseFields, Collection<Field> wlOrHsFields, Collection<Field> nonAggrBaseFields) throws Exception {
        String s2;
        StringBuffer sql = new StringBuffer();
        ArrayList fields = Lists.newArrayList();
        ArrayList colNames = Lists.newArrayList();
        int i2 = 0;
        for (Field f2 : baseFields) {
            s2 = "A." + f2.getColumnName();
            f2.setColumnName("C" + i2++);
            fields.add(f2);
            colNames.add(s2 + " " + f2.getColumnName());
        }
        for (Field f2 : wlOrHsFields) {
            s2 = "B." + f2.getColumnName();
            f2.setColumnName("C" + i2++);
            fields.add(f2);
            colNames.add(s2 + " " + f2.getColumnName());
        }
        sql.append("SELECT " + DBEngine.join(colNames) + " FROM " + finalBaseMartId + " A  JOIN " + secondMartId + " B ");
        if (nonAggrBaseFields.size() > 0) {
            ArrayList joins = Lists.newArrayList();
            i2 = 0;
            for (Field f3 : nonAggrBaseFields) {
                joins.add("A." + f3.getColumnName() + "=B.C" + i2++);
            }
            sql.append(" ON " + DBEngine.join(" AND ", joins));
        }
        String combinedMartID = finalBaseMartId + "_MRG";
        this.createTable(combinedMartID, fields, false);
        this.batchInsert(combinedMartID, fields, this.queryForList(sql.toString()));
        return combinedMartID;
    }

    private String createCombinedMart(String baseMartId, DTO dto, DataSet dataset, boolean hasWorklog, boolean hasHistory, Field issueKeyField, Field worklogField, Field historyField) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList colNames = Lists.newArrayList();
        List<Field> fields = dto.getQueryFields();
        for (Field f2 : fields) {
            if ("issuekey".equals(f2.getId())) {
                colNames.add("A." + Fielder.name(f2));
                continue;
            }
            colNames.add(Fielder.name(f2));
        }
        sql.append("SELECT " + DBEngine.join(colNames) + " FROM " + baseMartId + " A ");
        if (hasWorklog) {
            boolean innerJoin = dto.isTimesheet() && !dto.isIncludeNonWorklog() && !dto.isTimeEntry();
            String worklogDatamartID = this.createWorklogBaseMart(baseMartId, dto, dataset, issueKeyField, worklogField);
            sql.append((innerJoin ? " JOIN " : " LEFT OUTER JOIN ") + worklogDatamartID + " B ON A." + "issuekey" + "=B." + "issuekey");
        }
        if (hasHistory) {
            String historyDatamartID = this.createHistoryBaseMart(baseMartId, dto, dataset, issueKeyField, historyField);
            sql.append(" LEFT OUTER JOIN " + historyDatamartID + " C ON A." + "issuekey" + "=C." + "issuekey");
        }
        String combinedMartID = baseMartId + "_B_" + (hasWorklog ? "W_" : "") + (hasHistory ? "H_" : "") + "CB";
        this.createTable(combinedMartID, fields, false);
        this.batchInsert(combinedMartID, fields, this.queryForList(sql.toString()));
        return combinedMartID;
    }

    private void createBaseMart(String baseMartId, DTO dto, DataSet dataset, boolean hasWorklog, boolean hasHistory) throws Exception {
        Collection<Field> fields = dto.getQueryFields();
        if (hasWorklog) {
            fields = Fielder.nonWorklogFields(fields);
        }
        if (hasHistory) {
            fields = Fielder.nonHistoryFields(fields);
        }
        this.createTable(baseMartId, fields, false);
        this.batchInsert(baseMartId, fields, dataset.getIssues());
    }

    private String createWorklogBaseMart(String baseMartId, DTO dto, DataSet dataset, Field issueKeyField, Field worklogField) throws Exception {
        String worklogDatamartID = this.worklogDatamartID(baseMartId);
        ArrayList fields = Lists.newArrayList();
        fields.add(issueKeyField);
        fields.add(worklogField);
        this.createTable(worklogDatamartID, fields, false);
        this.batchInsert(worklogDatamartID, fields, this.flatten(dataset.getWorklogs()));
        return worklogDatamartID;
    }

    private String createHistoryBaseMart(String baseMartId, DTO dto, DataSet dataset, Field issueKeyField, Field historyField) throws Exception {
        String historyDatamartID = this.historyDatamartID(baseMartId);
        ArrayList fields = Lists.newArrayList();
        fields.add(issueKeyField);
        fields.add(historyField);
        this.createTable(historyDatamartID, fields, false);
        this.batchInsert(historyDatamartID, fields, this.flatten(dataset.getHistory()));
        return historyDatamartID;
    }

    private String processRawMart(String datamartID, DTO dto, Collection<Field> fields, List<String> origColumnNames) throws Exception {
        ArrayList fieldsAsNewList = Lists.newArrayList(fields);
        datamartID = this.preProcess(datamartID, dto, fields, origColumnNames, fieldsAsNewList);
        if (dto.isTableau()) {
            return datamartID;
        }
        datamartID = this.applyFilters(datamartID, dto, fields, fieldsAsNewList);
        datamartID = this.postProcess(datamartID, dto, fields);
        return datamartID;
    }

    private String preProcess(String datamartID, DTO dto, Collection<Field> fields, List<String> origColumnNames, List<Field> fieldsAsNewList) throws Exception {
        Field worklogAuthorField;
        List<String> timesheetUsers;
        boolean history = false;
        boolean aggregate = false;
        ArrayList hsGroupByFields = Lists.newArrayList();
        if (Fielder.historyFields(fields).size() > 0) {
            history = true;
        }
        if (dto.isTimesheet() && Fielder.worklogFields(fields).size() > 0 && (timesheetUsers = dto.determineTimesheetUsers()).size() > 0 && (worklogAuthorField = Fielder.findInFields(SchemaBuilder.derivedFieldId("worklog", "author.name"), fields)) == null) {
            worklogAuthorField = Fielder.findInFields(SchemaBuilder.derivedFieldId("worklog", "author.name"), dto.getSchema());
            fieldsAsNewList.add(worklogAuthorField);
        }
        int i2 = 0;
        ArrayList colNames = Lists.newArrayList();
        for (Field f2 : fieldsAsNewList) {
            String exp = f2.getExpression();
            if (f2.isDate()) {
                exp = Fielder.isWorklogField(f2) ? "AIO_APPLY_TIMEZONE(" + f2.getExpression() + ",DeepValue('" + "worklog" + "','" + "worklog" + "_author.timeZone'," + "worklog" + "), '" + dto.getTimezone() + "')" : "AIO_APPLY_TIMEZONE(" + f2.getExpression() + ",'" + dto.getTimezone() + "','" + dto.getTimezone() + "')";
            }
            exp = StringUtils.replace((String)exp, (String)"<<DATAMART_ID>>", (String)datamartID);
            if (dto.isTableau() && StringUtils.isNotBlank((CharSequence)f2.getOperation())) {
                exp = "((" + exp + ")*1.0 " + f2.getOperation() + ")";
            }
            if (history && f2.isMeasure()) {
                exp = "SUM(CAST(" + exp + " AS DOUBLE))";
                aggregate = true;
            } else {
                hsGroupByFields.add(f2);
            }
            f2.setColumnName(dto.isTableau() ? origColumnNames.get(i2++) : "T" + i2++);
            colNames.add(exp + " " + f2.getColumnName());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + DBEngine.join(colNames) + " FROM " + datamartID);
        if (history && aggregate) {
            sql.append(this.groupBy(hsGroupByFields));
        }
        datamartID = datamartID + "_DT";
        this.createTable(datamartID, fieldsAsNewList, true);
        this.batchInsert(datamartID, fieldsAsNewList, this.queryForList(sql.toString()));
        return datamartID;
    }

    private String applyFilters(String datamartID, DTO dto, Collection<Field> fields, List<Field> fieldsAsNewList) throws ParseException, Exception {
        ArrayList strFilters = Lists.newArrayList();
        if (dto.isTimesheet() && Fielder.worklogFields(fields).size() > 0) {
            List<String> timesheetUsers = dto.determineTimesheetUsers();
            strFilters.addAll(FilterService.buildTimesheetFilters(dto, timesheetUsers, fieldsAsNewList));
        }
        strFilters.addAll(FilterService.nonAggregateFilters(dto, fieldsAsNewList));
        if (strFilters.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT " + DBEngine.join(this.uniqNames(fields)) + " FROM " + datamartID);
            sql.append(" WHERE (" + Joiner.on((String)") AND (").join((Iterable)strFilters) + ")");
            datamartID = datamartID + "_FL";
            this.createTable(datamartID, fields, true);
            this.batchInsert(datamartID, fields, this.queryForList(sql.toString()));
        }
        return datamartID;
    }

    private String postProcess(String datamartID, DTO dto, Collection<Field> fields) throws Exception {
        ArrayList origFields = Lists.newArrayList(fields);
        Fielder.removeHiddenFields(fields);
        Fielder.removeHiddenFields(dto.getRow());
        dto.getAllFields(true);
        ArrayList colNames = Lists.newArrayList();
        int i2 = 0;
        boolean hasPercent = false;
        for (Field f2 : fields) {
            LinkType linkType;
            String exp = Fielder.name(f2);
            f2.setColumnName("C" + i2++);
            if (Utils.isGrid(dto) && (linkType = LinkType.findByField(f2)) != null) {
                exp = "AIO_LINK('" + linkType.getUrl() + "'," + exp + ",'" + dto.getJiraBaseUrl() + "'," + linkType.isArray() + ")";
                f2.setLink(true);
            }
            if (f2.isDate()) {
                exp = "AIO_FORMATDATETIME(" + exp + ",'" + f2.getPattern() + "')";
            }
            if (f2.isAggregate()) {
                exp = f2.getAggregateFunction() + "(" + exp + ")";
            }
            if (StringUtils.isNotBlank((CharSequence)f2.getOperation())) {
                exp = "((" + exp + ")*1.0" + f2.getOperation() + ")";
            }
            if (f2.isNumber() && (f2.isAggregate() || StringUtils.isNotBlank((CharSequence)f2.getOperation()))) {
                exp = "ROUND(" + exp + ",2)";
            }
            if (!f2.isNumber() && !dto.isTableau()) {
                exp = "NVL(" + exp + ",'" + "-" + "')";
            }
            if (f2.isPercent()) {
                hasPercent = true;
            }
            if (f2.getBuckets().size() > 0) {
                exp = "AIO_BUCKET(" + exp + ",'" + JsonUtils.objectToJsonString(f2.getBuckets()) + "')";
            }
            colNames.add(exp + " " + f2.getColumnName());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + DBEngine.join(colNames) + this.from(datamartID) + this.groupBy(fields));
        List<String> strFilters = FilterService.aggregateFilters(dto, origFields);
        if (strFilters.size() > 0) {
            sql.append(" HAVING " + Joiner.on((String)" AND ").join(strFilters));
        }
        datamartID = datamartID + "_FN";
        this.createTable(datamartID, fields, false);
        this.batchInsert(datamartID, fields, this.queryForList(sql.toString()));
        if (hasPercent) {
            colNames = Lists.newArrayList();
            for (Field f3 : fields) {
                if (f3.isPercent()) {
                    if (Fielder.isCount(f3)) {
                        colNames.add("((" + f3.getColumnName() + "*100)/(SELECT SUM(" + f3.getColumnName() + ")  FROM " + datamartID + "))");
                        continue;
                    }
                    String percentOverColName = Fielder.findInFields(f3.getId() + "_PCT_HLP", dto.getHelpers()).getColumnName();
                    colNames.add("((" + f3.getColumnName() + "*100)/AIO_NONZERO(" + percentOverColName + "))");
                    continue;
                }
                colNames.add(f3.getColumnName());
            }
            sql = new StringBuffer();
            sql.append("SELECT " + DBEngine.join(colNames) + this.from(datamartID));
            datamartID = datamartID + "_PC";
            this.createTable(datamartID, fields, false);
            this.batchInsert(datamartID, fields, this.queryForList(sql.toString()));
        }
        for (Field f3 : origFields) {
            f3.setFilterValue(null);
        }
        return datamartID;
    }

    private DBEngine() throws Exception {
        this.createFunctionAliases();
        try {
            Server server = Server.createTcpServer(new String[0]).start();
            logger.debug((Object)("URL: jdbc:h2:" + server.getURL() + "/mem:" + DBNAME));
            logger.debug((Object)"Start the H2 Console:\n$ cd lib; java -cp h2-1.4.192.jar org.h2.tools.Console -web -browser -webAllowOthers");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection getConnection() throws Exception {
        Connection dbConnection = null;
        Class.forName(DB_DRIVER);
        dbConnection = DriverManager.getConnection(DB_CONNECTION, "", "");
        return dbConnection;
    }

    private List<List<Object>> flatten(Map<String, List<String>> records) {
        ArrayList out = Lists.newArrayList();
        for (String issuekey : records.keySet()) {
            List<String> record = records.get(issuekey);
            for (String _r : record) {
                ArrayList line = Lists.newArrayList();
                line.add(issuekey);
                line.add(_r);
                out.add(line);
            }
        }
        return out;
    }

    private void batchInsert(String datamartID, Collection<Field> fields, List<List<Object>> fieldVals) throws Exception {
        StringBuffer sql = new StringBuffer();
        Set<String> uniqFieldNames = this.uniqNames(fields);
        sql.append("INSERT INTO " + datamartID + " (" + DBEngine.join(uniqFieldNames) + " ) VALUES (" + DBEngine.join(Collections.nCopies(uniqFieldNames.size(), "?")) + ")");
        int batchSize = 100;
        for (int j2 = 0; j2 < fieldVals.size(); j2 += 100) {
            List<List<Object>> batchList = fieldVals.subList(j2, j2 + 100 > fieldVals.size() ? fieldVals.size() : j2 + 100);
            this.batchUpdate(sql.toString(), batchList);
        }
    }

    private void createTable(String datamartID, Collection<Field> fields, boolean strict) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + datamartID + " (");
        LinkedHashSet columns = Sets.newLinkedHashSet();
        for (Field field : fields) {
            columns.add(Fielder.name(field) + " " + this.dbtype(field, strict));
        }
        sql.append(DBEngine.join(columns));
        sql.append(")");
        this.execute(sql.toString());
    }

    private String dbtype(Field f2, boolean strict) {
        FieldType type = f2.getType();
        String length = "";
        if (f2.getBuckets().size() > 0) {
            type = FieldType.VARCHAR;
            length = "(2000000)";
        } else if (f2.isNumber()) {
            length = "(22,2)";
        } else if (f2.isDate()) {
            if (strict) {
                type = FieldType.TIMESTAMP;
            } else {
                type = FieldType.VARCHAR;
                length = "(50)";
            }
        } else {
            length = "(2000000)";
        }
        return (Object)((Object)type) + length;
    }

    public Set<String> uniqNames(Collection<Field> fields) {
        return Sets.newLinkedHashSet(this.names(fields));
    }

    private List<String> names(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            out.add(Fielder.name(f2));
        }
        return out;
    }

    @SafeVarargs
    public static final String join(Collection<String> ... collections) {
        return DBEngine.join(",", collections);
    }

    @SafeVarargs
    private static final String join(String joinOn, Collection<String> ... collections) {
        if (joinOn == null) {
            joinOn = ",";
        }
        ArrayList all = Lists.newArrayList();
        for (Collection<String> collection : collections) {
            all.addAll(collection);
        }
        return Joiner.on((String)joinOn).join((Iterable)all);
    }

    private String from(String datamartID) {
        return "  FROM " + datamartID + " A ";
    }

    private String datamartID() {
        return "DM_" + datamartID++;
    }

    private String worklogDatamartID(String datamartID) {
        return datamartID + "_WL";
    }

    private String historyDatamartID(String datamartID) {
        return datamartID + "_HS";
    }

    private List<CrosstabKey> queryToKey(String sql, List<Field> fields) throws Exception {
        ArrayList out = Lists.newArrayList();
        ResultSet rs = this.query(sql);
        while (rs.next()) {
            CrosstabKey key = new CrosstabKey();
            for (Field f2 : fields) {
                key.addValue(rs.getString(f2.getColumnName()));
            }
            out.add(key);
        }
        this.closeResultset(rs);
        return out;
    }

    private Map<CompositeCrosstabKey, List<Object>> queryToCompositeKey(String sql, DTO dto) throws Exception {
        List<Field> row = dto.getRow();
        List<Field> column = dto.getColumn();
        List<Field> data = dto.getData();
        HashMap dataTable = Maps.newHashMap();
        ResultSet rs = this.query(sql);
        while (rs.next()) {
            CompositeCrosstabKey compositeKey = new CompositeCrosstabKey();
            CrosstabKey columnKey = new CrosstabKey();
            for (Field f2 : column) {
                columnKey.addValue(rs.getString(Fielder.name(f2)));
            }
            compositeKey.setColumnKey(columnKey);
            CrosstabKey rowKey = new CrosstabKey();
            for (Field f3 : row) {
                rowKey.addValue(rs.getString(Fielder.name(f3)));
            }
            compositeKey.setRowKey(rowKey);
            for (Field f3 : data) {
                List<Object> dataValues;
                if (dataTable.containsKey(compositeKey)) {
                    dataValues = (List)dataTable.get(compositeKey);
                } else {
                    dataValues = Lists.newArrayList();
                    dataTable.put(compositeKey, dataValues);
                }
                dataValues.add(rs.getObject(Fielder.name(f3)));
            }
        }
        this.closeResultset(rs);
        return dataTable;
    }

    private void closeResultset(ResultSet rs) throws SQLException {
        Statement stmt = rs.getStatement();
        Connection conn = stmt.getConnection();
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dropMart(String finalDatamartID) {
        String baseMartId = finalDatamartID;
        try {
            baseMartId = StringUtils.substring((String)finalDatamartID, (int)0, (int)StringUtils.indexOf((CharSequence)finalDatamartID, (CharSequence)"_", (int)3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList allTables = Lists.newArrayList();
        allTables.add(baseMartId);
        allTables.add(this.worklogDatamartID(baseMartId));
        allTables.add(this.historyDatamartID(baseMartId));
        allTables.add(baseMartId + "_B_CB");
        allTables.add(baseMartId + "_B_W_CB");
        allTables.add(baseMartId + "_B_H_CB");
        allTables.add(baseMartId + "_B_W_H_CB");
        ArrayList newList = Lists.newArrayList((Iterable)allTables);
        for (String t2 : newList) {
            allTables.add(t2 + "_DT");
            allTables.add(t2 + "_DT_FN");
            allTables.add(t2 + "_DT_FN_FN");
            allTables.add(t2 + "_DT_FN_FN_PC");
            allTables.add(t2 + "_DT_FN_MRG");
            allTables.add(t2 + "_DT_FL");
            allTables.add(t2 + "_DT_FL_FN");
            allTables.add(t2 + "_DT_FL_MRG");
        }
        for (String t2 : allTables) {
            try {
                this.execute("DROP TABLE IF EXISTS " + t2);
            }
            catch (Exception exception) {}
        }
    }

    static {
        logger = Logger.getLogger(DBEngine.class);
    }
}

