/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.model.CrosstabKey;
import com.kaanha.reports.model.Field;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class CrosstabKeyComparator<T>
implements Comparator<CrosstabKey> {
    List<Field> fields;

    public CrosstabKeyComparator(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public int compare(CrosstabKey k1, CrosstabKey k2) {
        int result = 0;
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            Field field = this.fields.get(i2);
            String val1 = k1.getValue(i2);
            String val2 = k2.getValue(i2);
            if (field.isDate()) {
                Date d1 = null;
                Date d2 = null;
                try {
                    d1 = DateUtils.toDate(val1, field.getPattern());
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
                try {
                    d2 = DateUtils.toDate(val2, field.getPattern());
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
                if (d1 == null && d2 == null) {
                    return val1.compareTo(val2);
                }
                if (d1 == null && d2 != null) {
                    return -1;
                }
                if (d1 != null && d2 == null) {
                    return 1;
                }
                return d1.compareTo(d2);
            }
            result = val1.compareTo(val2);
            if (result != 0) break;
        }
        return result;
    }
}

