/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.MigratableReport;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.ReportPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class CloudToServerMigrationService {
    ReportPersistenceService reportPersistenceService;
    UserPersistenceService userPersistenceService;
    PersistenceService persistenceService = PersistenceService.getInstance();

    public CloudToServerMigrationService() throws Exception {
        this.reportPersistenceService = new ReportPersistenceService();
        this.userPersistenceService = new UserPersistenceService();
    }

    public void migrate(String tenantReports) throws JsonParseException, JsonMappingException, IOException, SQLException {
        Map<String, List<MigratableReport>> map = JsonUtils.stringToType(tenantReports, new TypeReference<Map<String, List<MigratableReport>>>(){});
        List<MigratableReport> mrs = map.get("tenantReports");
        for (MigratableReport mr : mrs) {
            AioUser u2 = this.userPersistenceService.findByUserkey(mr.getOwner().getUserKey());
            if (u2 == null) {
                u2 = this.userPersistenceService.createUserForHosted(mr.getOwner());
            }
            AioReport r2 = this.reportPersistenceService.create();
            r2.setBaseJql(mr.getBaseJql());
            r2.setBreakByIssueType(mr.isBreakByIssueType());
            r2.setCanned(mr.isCanned());
            r2.setCategory(mr.getCategory());
            r2.setColumn(mr.getColumn());
            r2.setData(mr.getData());
            r2.setDateRange(mr.getDateRange());
            r2.setDays(mr.getDays());
            r2.setEndDate(mr.getEndDate());
            r2.setFilterType(mr.getFilterType());
            r2.setFilterValue(mr.getFilterValue());
            r2.setIncludeNonWorklog(mr.isIncludeNonWorklog());
            r2.setIncludeSubTasks(mr.isIncludeSubTasks());
            r2.setIssueTypes(mr.getIssueTypes());
            r2.setLastModified(mr.getLastModified());
            r2.setLastPublishedDate(mr.getLastPublishedDate());
            r2.setName(mr.getName());
            r2.setOwner(u2);
            r2.setProjects(mr.getProjects());
            r2.setPublishedLink(mr.getPublishedLink());
            r2.setQuickTimesheet(mr.isQuickTimesheet());
            r2.setRow(mr.getRow());
            r2.setShowCumulative(mr.isShowCumulative());
            r2.setShowPercentages(mr.isShowPercentages());
            r2.setStartDate(mr.getStartDate());
            r2.setSubIssueTypes(mr.getSubIssueTypes());
            r2.setTimeInStatus(mr.isTimeInStatus());
            r2.setTimesheetInterval(mr.getTimesheetInterval());
            r2.setTrendField(mr.getTrendField());
            r2.setTrendInterval(mr.getTrendInterval());
            r2.setTrendOutputFormat(mr.getTrendOutputFormat());
            r2.setTrendValues(mr.getTrendValues());
            r2.setType(mr.getType());
            r2.setUsers(mr.getUsers());
            this.persistenceService.save(r2);
        }
    }
}

