/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.service;

import com.google.common.collect.ImmutableList;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.service.AIOHttpClient4;
import com.kaanha.reports.service.EmailService;
import com.kaanha.reports.service.RsaSha1MessageSigner;
import com.kaanha.reports.service.TokenSecretVerifierHolder;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Scanner;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.signature.OAuthMessageSigner;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class AtlassianOAuthClient {
    protected static final String SERVLET_BASE_URL = "/plugins/servlet";
    private final String consumerKey;
    private final String privateKey;
    private final String baseUrl;
    private final String callback;
    private OAuthAccessor accessor;
    private OAuthMessageSigner postSigner;
    private static final Base64 BASE64 = new Base64();
    Logger logger = Logger.getLogger(this.getClass());

    public AtlassianOAuthClient(OAuthParams oAuthParams) throws GeneralSecurityException {
        this.consumerKey = oAuthParams.getConsumerKey();
        this.privateKey = oAuthParams.getConsumerPrivateKey();
        this.baseUrl = oAuthParams.getBaseUrl();
        this.callback = oAuthParams.getCallbackUrl();
        this.postSigner = new RsaSha1MessageSigner(this.getPrivateKeyFromDer(this.decodeBase64(this.privateKey)));
    }

    public TokenSecretVerifierHolder getRequestToken() {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient oAuthClient = new OAuthClient(new AIOHttpClient4());
            ImmutableList callBack = this.callback == null || "".equals(this.callback) ? Collections.emptyList() : ImmutableList.of((Object)new OAuth.Parameter("oauth_callback", this.callback));
            OAuthMessage message = oAuthClient.getRequestTokenResponse(accessor, "POST", (Collection<? extends Map.Entry>)callBack);
            TokenSecretVerifierHolder tokenSecretVerifier = new TokenSecretVerifierHolder();
            tokenSecretVerifier.token = accessor.requestToken;
            tokenSecretVerifier.secret = accessor.tokenSecret;
            tokenSecretVerifier.verifier = message.getParameter("oauth_verifier");
            return tokenSecretVerifier;
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to obtain request token", e2);
        }
    }

    public String swapRequestTokenForAccessToken(String requestToken, String tokenSecret, String oauthVerifier) {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient client = new OAuthClient(new AIOHttpClient4());
            accessor.requestToken = requestToken;
            accessor.tokenSecret = tokenSecret;
            OAuthMessage message = client.getAccessToken(accessor, "POST", (Collection<? extends Map.Entry>)ImmutableList.of((Object)new OAuth.Parameter("oauth_verifier", oauthVerifier)));
            return message.getToken();
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to swap request token with access token", e2);
        }
    }

    public String authenticatedGet(String url, String accessToken) throws Exception {
        OAuthAccessor accessor = this.getAccessor();
        OAuthClient client = new OAuthClient(new AIOHttpClient4());
        accessor.accessToken = accessToken;
        try {
            OAuthMessage response = client.invoke(accessor, url, Collections.emptySet());
            return response.readBodyAsString();
        }
        catch (Exception e2) {
            if (e2.getMessage() != null && !e2.getMessage().contains("HTTP/1.1 404 Not Found") && !e2.getMessage().contains("nonce_used")) {
                StringBuffer error = new StringBuffer();
                error.append(this.getRequestTokenUrl() + ", " + this.getAuthorizeUrl() + ", " + this.getAccessTokenUrl());
                error.append(accessToken);
                error.append(url);
                error.append(e2.getMessage());
                new EmailService().sendErrorEmail(e2, error.toString(), url);
            }
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticatedPost(String strUrl, String accessToken, String payload) throws Exception {
        URL url = new URL(strUrl);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Content-Type", "application/json; charset=utf8");
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.consumerKey, this.privateKey);
        HttpParameters doubleEncodedParams = new HttpParameters();
        doubleEncodedParams.put("realm", strUrl);
        doubleEncodedParams.put("oauth_token", accessToken);
        doubleEncodedParams.put("oauth_signature_method", "RSA-SHA1");
        consumer.setAdditionalParameters(doubleEncodedParams);
        consumer.setMessageSigner(this.postSigner);
        consumer.sign(urlConnection);
        try (OutputStreamWriter outputStreamWriter = null;){
            outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");
            outputStreamWriter.write(payload);
        }
        String inputStreamString = null;
        try {
            BufferedInputStream in2 = new BufferedInputStream(urlConnection.getInputStream());
            Scanner scanner = new Scanner((InputStream)in2, "UTF-8");
            inputStreamString = scanner.useDelimiter("\\A").next();
            scanner.close();
        }
        catch (Exception e2) {
            BufferedInputStream in3 = new BufferedInputStream(urlConnection.getErrorStream());
            Scanner scanner = new Scanner((InputStream)in3, "UTF-8");
            inputStreamString = scanner.useDelimiter("\\A").next();
            scanner.close();
            this.logger.error((Object)inputStreamString);
            throw new Exception(inputStreamString);
        }
        finally {
            urlConnection.disconnect();
        }
        return inputStreamString;
    }

    private final OAuthAccessor getAccessor() {
        if (this.accessor == null) {
            OAuthServiceProvider serviceProvider = new OAuthServiceProvider(this.getRequestTokenUrl(), this.getAuthorizeUrl(), this.getAccessTokenUrl());
            OAuthConsumer consumer = new OAuthConsumer(this.callback, this.consumerKey, null, serviceProvider);
            consumer.setProperty("RSA-SHA1.PrivateKey", this.privateKey);
            consumer.setProperty("oauth_signature_method", "RSA-SHA1");
            this.accessor = new OAuthAccessor(consumer);
        }
        return this.accessor;
    }

    private String getAccessTokenUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/access-token";
    }

    private String getRequestTokenUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/request-token";
    }

    public String getAuthorizeUrlForToken(String token) {
        return this.getAuthorizeUrl() + "?oauth_token=" + token;
    }

    private String getAuthorizeUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/authorize";
    }

    private byte[] decodeBase64(String s2) {
        return BASE64.decode(s2.getBytes());
    }

    private PrivateKey getPrivateKeyFromDer(byte[] privateKeyObject) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyObject);
        return fac.generatePrivate(privKeySpec);
    }
}

