/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence.legacy.cloud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kaanha.reports.model.ReportType;
import com.kaanha.reports.persistence.legacy.cloud.PublishedReport;
import com.kaanha.reports.persistence.legacy.cloud.ScheduledReport;
import com.kaanha.reports.persistence.legacy.cloud.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

@Entity
public class Report
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    Long id;
    @Column(nullable=false, length=2000)
    String name;
    @ElementCollection(targetClass=String.class)
    List<String> fields = new ArrayList<String>();
    @ElementCollection(targetClass=String.class)
    List<String> row = new ArrayList<String>();
    @ElementCollection(targetClass=String.class)
    List<String> col = new ArrayList<String>();
    @ElementCollection(targetClass=String.class)
    List<String> data = new ArrayList<String>();
    @ElementCollection(targetClass=String.class)
    List<String> queryFields = new ArrayList<String>();
    @Column(length=20000)
    String jql;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    ReportType type;
    @Column(length=20000)
    String customFilter;
    String filterType;
    String jiraFilterId;
    String startDate;
    String endDate;
    @Column(length=20000)
    String timesheetUsers;
    String dateRangeDesc;
    boolean timesheetIncludeIssueBreakdown;
    Boolean timesheetIncludeProjectBreakdown;
    Boolean timesheetIncludeUserBreakdown;
    @Column(length=20000)
    String timesheetProjects;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_ID", nullable=false)
    User owner;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="PUBLISHED_ID")
    PublishedReport publishedReport;
    @Transient
    boolean fetchEpic = false;
    @Transient
    boolean fetchWorklog = false;
    @Transient
    String epicLinkFieldId;
    @Transient
    String epicNameFieldId;
    @Transient
    Map<String, Object> results;
    @Transient
    String handle;
    @Column(nullable=false)
    Date lastModified = new Date();
    boolean deleted = false;
    String category;
    String viewFormat;
    String issueType;
    Boolean includeSubTask;
    Boolean showPercentage;
    @OneToMany(mappedBy="report")
    @JsonIgnore
    List<ScheduledReport> scheduledReports;
    Boolean quickTimesheet = false;
    @ManyToMany
    @JoinTable(name="REPORT_SHARE_USERS", joinColumns={@JoinColumn(name="REPORT_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID", referencedColumnName="ID")})
    private List<User> sharedWithUsers = new ArrayList<User>();
    @Transient
    private boolean enableSave;
    @Transient
    private String timesheetJql;
    private String subIssueTypes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id2) {
        this.id = id2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<String> getRow() {
        return this.row;
    }

    public void setRow(List<String> row) {
        this.row = row;
    }

    public List<String> getColumn() {
        return this.col;
    }

    public void setColumn(List<String> column) {
        this.col = column;
    }

    public List<String> getData() {
        return this.data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    public void setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
    }

    public boolean isFetchEpic() {
        return this.fetchEpic;
    }

    public void setFetchEpic(boolean fetchEpic) {
        this.fetchEpic = fetchEpic;
    }

    public String getEpicLinkFieldId() {
        return this.epicLinkFieldId;
    }

    public void setEpicLinkFieldId(String epicLinkFieldId) {
        this.epicLinkFieldId = epicLinkFieldId;
    }

    public String getEpicNameFieldId() {
        return this.epicNameFieldId;
    }

    public void setEpicNameFieldId(String epicNameFieldId) {
        this.epicNameFieldId = epicNameFieldId;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public ReportType getType() {
        return this.type;
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getTimesheetUsers() {
        return this.timesheetUsers;
    }

    public void setTimesheetUsers(String timesheetUsers) {
        this.timesheetUsers = timesheetUsers;
    }

    public String getCustomFilter() {
        return this.customFilter;
    }

    public void setCustomFilter(String customFilter) {
        this.customFilter = customFilter;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getJiraFilterId() {
        return this.jiraFilterId;
    }

    public void setJiraFilterId(String jiraFilterId) {
        this.jiraFilterId = jiraFilterId;
    }

    public String getDateRangeDesc() {
        return this.dateRangeDesc;
    }

    public void setDateRangeDesc(String dateRangeDesc) {
        this.dateRangeDesc = dateRangeDesc;
    }

    public boolean isTimesheetIncludeIssueBreakdown() {
        return this.timesheetIncludeIssueBreakdown;
    }

    public void setTimesheetIncludeIssueBreakdown(boolean timesheetIncludeIssueBreakdown) {
        this.timesheetIncludeIssueBreakdown = timesheetIncludeIssueBreakdown;
    }

    public String getTimesheetProjects() {
        return this.timesheetProjects;
    }

    public void setTimesheetProjects(String timesheetProjects) {
        this.timesheetProjects = timesheetProjects;
    }

    @JsonIgnore
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    @JsonIgnore
    public Map<String, Object> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    @JsonIgnore
    public PublishedReport getPublishedReport() {
        return this.publishedReport;
    }

    public void setPublishedReport(PublishedReport publishedReport) {
        this.publishedReport = publishedReport;
        if (publishedReport != null) {
            publishedReport.setReport(this);
        }
    }

    @JsonIgnore
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getViewFormat() {
        return this.viewFormat;
    }

    public void setViewFormat(String viewFormat) {
        this.viewFormat = viewFormat;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public Boolean getIncludeSubTask() {
        return this.includeSubTask;
    }

    public void setIncludeSubTask(Boolean includeSubTask) {
        this.includeSubTask = includeSubTask;
    }

    public Boolean getShowPercentage() {
        return this.showPercentage;
    }

    public void setShowPercentage(Boolean showPercentage) {
        this.showPercentage = showPercentage;
    }

    public Boolean getTimesheetIncludeProjectBreakdown() {
        return this.timesheetIncludeProjectBreakdown;
    }

    public void setTimesheetIncludeProjectBreakdown(Boolean timesheetIncludeProjectBreakdown) {
        this.timesheetIncludeProjectBreakdown = timesheetIncludeProjectBreakdown;
    }

    public Boolean getTimesheetIncludeUserBreakdown() {
        return this.timesheetIncludeUserBreakdown;
    }

    public void setTimesheetIncludeUserBreakdown(Boolean timesheetIncludeUserBreakdown) {
        this.timesheetIncludeUserBreakdown = timesheetIncludeUserBreakdown;
    }

    public List<ScheduledReport> getScheduledReports() {
        ArrayList<ScheduledReport> active = new ArrayList<ScheduledReport>();
        for (ScheduledReport sr : this.scheduledReports) {
            if (sr.getDeleted()) continue;
            active.add(sr);
        }
        return active;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public Boolean getQuickTimesheet() {
        return this.quickTimesheet;
    }

    public void setQuickTimesheet(Boolean quickTimesheet) {
        this.quickTimesheet = quickTimesheet;
    }

    @JsonIgnore
    public List<User> getSharedWithUsers() {
        return this.sharedWithUsers;
    }

    public String toString() {
        return "Report [type=" + (Object)((Object)this.type) + ", name=" + this.name + ", fields=" + this.fields + ", row=" + this.row + ", col=" + this.col + ", data=" + this.data + ", queryFields=" + this.queryFields + ", jql=" + this.jql + ", customFilter=" + this.customFilter + ", filterType=" + this.filterType + ", jiraFilterId=" + this.jiraFilterId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", timesheetUsers=" + this.timesheetUsers + ", dateRangeDesc=" + this.dateRangeDesc + ", issueBreakdown=" + this.timesheetIncludeIssueBreakdown + ", projectBreakdown=" + this.timesheetIncludeProjectBreakdown + ", userBreakdown=" + this.timesheetIncludeUserBreakdown + ", timesheetProjects=" + this.timesheetProjects + ", viewFormat=" + this.viewFormat + ", issueType=" + this.issueType + ", includeSubTask=" + this.includeSubTask + "]";
    }

    public boolean getEnableSave() {
        return this.enableSave;
    }

    public void setEnableSave(boolean b2) {
        this.enableSave = b2;
    }

    public boolean isFetchWorklog() {
        return this.fetchWorklog;
    }

    public void setFetchWorklog(boolean fetchWorklog) {
        this.fetchWorklog = fetchWorklog;
    }

    public String getTimesheetJql() {
        return this.timesheetJql;
    }

    public void setTimesheetJql(String timesheetJql) {
        this.timesheetJql = timesheetJql;
    }

    public String getSubIssueTypes() {
        return this.subIssueTypes;
    }

    public void setSubIssueTypes(String subIssueTypes) {
        this.subIssueTypes = subIssueTypes;
    }
}

