/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence.legacy.cloud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kaanha.reports.model.ReportType;
import com.kaanha.reports.persistence.legacy.cloud.Report;
import com.kaanha.reports.persistence.legacy.cloud.ScheduledReport;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import org.apache.commons.lang3.SerializationUtils;

@Entity
public class PublishedReport
implements Serializable {
    private static final long serialVersionUID = 4915778598781758472L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    long id;
    @Column(nullable=false, unique=true)
    String link;
    @Lob
    @Column(name="results", length=0x7FFFFFFE)
    byte[] results;
    String name;
    Date publishedDate;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    ReportType type;
    @OneToOne(mappedBy="publishedReport")
    Report report;
    @OneToOne(mappedBy="publishedReport")
    ScheduledReport scheduledReport;
    String viewFormat;
    private String startDate;
    private String endDate;
    private Date lastAccessedDate;
    Boolean autopublish;
    private Boolean expired = false;

    public long getId() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Map<String, Object> getResults() {
        return (Map)SerializationUtils.deserialize((byte[])this.results);
    }

    public void setResults(Map<String, Object> results) {
        this.results = SerializationUtils.serialize((Serializable)((Serializable)((Object)results)));
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public ReportType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getViewFormat() {
        return this.viewFormat;
    }

    public void setViewFormat(String viewFormat) {
        this.viewFormat = viewFormat;
    }

    @JsonIgnore
    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    @JsonIgnore
    public ScheduledReport getScheduledReport() {
        return this.scheduledReport;
    }

    public void setScheduledReport(ScheduledReport scheduledReport) {
        this.scheduledReport = scheduledReport;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public Date getPublishedDate() {
        return this.publishedDate;
    }

    public void setPublishedDate(Date publishedDate) {
        this.publishedDate = publishedDate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublishedReport other = (PublishedReport)obj;
        return this.id == other.id;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setLastAccessedDate(Date date) {
        this.lastAccessedDate = date;
    }

    public Date getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    public Boolean getAutopublish() {
        return this.autopublish;
    }

    public void setAutopublish(Boolean autopublish) {
        this.autopublish = autopublish;
    }

    public void setExpired(Boolean b2) {
        this.expired = b2;
    }

    public Boolean isExpired() {
        return this.expired == null ? false : this.expired;
    }
}

