/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.connect.JWTUser;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.MigratableUser;
import com.kaanha.reports.model.OAuthParams;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.AioUserPreferences;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.service.OAuthService;
import com.nimbusds.jose.util.Base64;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.java.ao.Entity;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;

public class UserPersistenceService {
    private final PersistenceService persistenceService = PersistenceService.getInstance();
    private final OAuthService oAuthService = OAuthService.getInstance();

    public AioUser findByUserkeyAndTenant(String userkey, AioTenant tenant) throws SQLException {
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "userkey = ? and tenantID = ?", new Object[]{userkey, tenant.getID()});
        if (users == null || users.length == 0) {
            return null;
        }
        return users[0];
    }

    public AioUser[] findByTenant(AioTenant tenant) throws SQLException {
        return (AioUser[])this.persistenceService.find(AioUser.class, "tenantID = ?", new Object[]{tenant.getID()});
    }

    public AioUser findByUserkey(String userKey) throws SQLException {
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "userkey = ?", new Object[]{userKey});
        if (users == null || users.length == 0) {
            return null;
        }
        return users[0];
    }

    public AioUser login(AioUser user, JWTUser jwtUser, String timeZone) throws SQLException {
        Date today = new Date();
        if (user.getLastLoginDate() == null || user.getLoginDaysCount() == null) {
            user.setLoginDaysCount(0);
            user.setLastLoginDate(today);
        }
        user.setUsername(jwtUser.getUsername());
        user.setUserkey(jwtUser.getUserKey());
        user.setDisplayName(jwtUser.getDisplayName());
        if (user.getLastLoginDate() == null || DateUtils.daysBetween(today, user.getLastLoginDate()) > 1.0) {
            user.setLoginDaysCount(user.getLoginDaysCount() + 1);
        }
        user.setLastLoginDate(today);
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            user.setTimeZone(timeZone);
        }
        return this.save(user);
    }

    public AioUser createUserForCloud(JWTUser jwtUser, AioTenant tenant, String tz, String loc) throws SQLException {
        AioUser user = this.blankUser();
        user.setUserkey(jwtUser.getUserKey());
        user.setUsername(jwtUser.getUsername());
        user.setDisplayName(jwtUser.getDisplayName());
        user.setTenant(tenant);
        user.setTimeZone(tz);
        user.setLocale(loc);
        return this.save(user);
    }

    public AioUser blankUser() throws SQLException {
        AioUser user = this.persistenceService.create(AioUser.class);
        return user;
    }

    public AioUser save(AioUser user) throws SQLException {
        return this.persistenceService.save(user);
    }

    public AioUser createUserForHosted(UserProfile user, TimeZoneManager timeZoneManager) throws SQLException {
        AioUser aioUser = this.blankUser();
        aioUser.setUserkey(user.getUserKey().getStringValue());
        aioUser.setUsername(user.getUsername());
        aioUser.setDisplayName(user.getFullName());
        aioUser.setEmailAddress(user.getEmail());
        aioUser.setTimeZone(timeZoneManager.getLoggedInUserTimeZone().getID());
        return this.save(aioUser);
    }

    public AioReport[] getSavedReports(AioUser loggedInUser) throws SQLException {
        return this.persistenceService.findById(AioUser.class, loggedInUser.getID()).getReports();
    }

    public AioUser createUser(JsonNode user, AioUser loggedInUser) throws SQLException {
        AioUser aioUser = this.blankUser();
        aioUser.setUserkey(JsonUtils.text(user, "userkey"));
        aioUser.setDisplayName(JsonUtils.text(user, "name"));
        aioUser.setTimeZone(JsonUtils.text(user, "tz"));
        aioUser.setEmailAddress(JsonUtils.text(user, "emailAddress"));
        aioUser.setUsername(JsonUtils.text(user, "username"));
        if (loggedInUser.getTenant() != null) {
            aioUser.setTenant(loggedInUser.getTenant());
        }
        return this.save(aioUser);
    }

    public List<AioReport> getSharedReports(AioUser loggedInUser) {
        ArrayList sharedReports = Lists.newArrayList();
        ArrayList allSharedReports = Lists.newArrayList((Object[])loggedInUser.getSharedReports());
        for (AioTeam aioTeam : loggedInUser.getMemberOfTeams()) {
            allSharedReports.addAll(Lists.newArrayList((Object[])aioTeam.getSharedReports()));
        }
        for (AioReport _report : allSharedReports) {
            if (_report.getOwner().equals(loggedInUser)) continue;
            sharedReports.add(_report);
        }
        return sharedReports;
    }

    public void createAccessToken(OAuthParams oAuthParams, String oauth_token, String oauth_verifier) throws Exception {
        String accessToken = this.oAuthService.createAccessToken(oAuthParams, oauth_token, oAuthParams.getUser().getoAuthTokenSecret(), oauth_verifier);
        oAuthParams.getUser().setoAuthTokenStr(accessToken);
        this.save(oAuthParams.getUser());
    }

    public String unsubscribe(String unsubscribeLink) throws SQLException {
        Entity[] records = (AioSchedRepRcpt[])this.persistenceService.find(AioSchedRepRcpt.class, "unsubscribeLink = ?", new Object[]{unsubscribeLink});
        if (records != null && records.length > 0) {
            String name = records[0].getScheduledReport().getReport().getName();
            this.persistenceService.delete(records);
            return name;
        }
        return "the";
    }

    public int count() throws SQLException {
        return ((AioUser[])this.persistenceService.find(AioUser.class)).length;
    }

    public AioUser updateUserEmailAddressAndUsername(JsonNode user, AioUser _aioUser) throws SQLException {
        String username;
        String emailAddress = JsonUtils.text(user, "emailAddress");
        if (!StringUtils.equals((CharSequence)emailAddress, (CharSequence)_aioUser.getEmailAddress())) {
            _aioUser.setEmailAddress(emailAddress);
            _aioUser = this.save(_aioUser);
        }
        if (!StringUtils.equals((CharSequence)(username = JsonUtils.text(user, "username")), (CharSequence)_aioUser.getUsername())) {
            _aioUser.setUsername(username);
            _aioUser = this.save(_aioUser);
        }
        return _aioUser;
    }

    public void deleteAll() throws SQLException {
        this.persistenceService.delete(this.persistenceService.find(AioUser.class));
    }

    public AioUser findById(int id2) throws SQLException {
        return this.persistenceService.findById(AioUser.class, id2);
    }

    public AioUser findByEmailAddressAndTenant(String email, AioTenant tenant) throws SQLException {
        if (StringUtils.isBlank((CharSequence)email) || tenant == null) {
            return null;
        }
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "emailAddress = ? and tenantID = ?", new Object[]{email = email.trim(), tenant.getID()});
        if (users == null || users.length == 0) {
            return null;
        }
        return users[0];
    }

    public String createOrFindTableauConnectorKey(AioUser loggedInUser) throws SQLException, EncoderException {
        if (StringUtils.isBlank((CharSequence)loggedInUser.getTableauKey())) {
            loggedInUser.setTableauKey(UUID.randomUUID().toString());
            loggedInUser = this.save(loggedInUser);
        }
        return Base64.encode(loggedInUser.getTableauKey()).toString();
    }

    public AioUser findByTableauKey(String tableauKey) throws SQLException {
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "tableauKey = ?", new Object[]{tableauKey});
        if (users == null || users.length == 0) {
            return null;
        }
        return users[0];
    }

    public AioUser findOrCreateAioUser(AioUser loggedInUser, JsonNode user) throws SQLException {
        String userkey = JsonUtils.text(user, "userkey");
        AioUser _aioUser = null;
        _aioUser = loggedInUser.getTenant() == null ? this.findByUserkey(userkey) : this.findByUserkeyAndTenant(userkey, loggedInUser.getTenant());
        _aioUser = _aioUser == null ? this.createUser(user, loggedInUser) : this.updateUserEmailAddressAndUsername(user, _aioUser);
        return _aioUser;
    }

    public void login(AioUser loggedInUser, String postData) {
        try {
            JsonNode user = JsonUtils.stringToJsonNode(postData);
            loggedInUser.setDisplayName(JsonUtils.text(user, "displayName"));
            loggedInUser.setEmailAddress(JsonUtils.text(user, "emailAddress"));
            loggedInUser.setUsername(JsonUtils.text(user, "name"));
            loggedInUser.setTimeZone(JsonUtils.text(user, "timeZone"));
            this.save(loggedInUser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AioUser findByRestApiToken(String token) throws SQLException {
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "restApiToken = ?", new Object[]{token});
        if (users == null || users.length == 0) {
            return null;
        }
        return users[0];
    }

    public Object createOrFindRestApiToken(AioUser loggedInUser) throws SQLException {
        if (StringUtils.isBlank((CharSequence)loggedInUser.getRestApiToken())) {
            loggedInUser.setRestApiToken(UUID.randomUUID().toString());
            loggedInUser = this.save(loggedInUser);
        }
        return Base64.encode(loggedInUser.getRestApiToken()).toString();
    }

    public void saveTableauAccessCode(AioUser loggedInUser, String postData) throws SQLException {
        loggedInUser.setTableauAccessCode(StringUtils.removeEnd((String)StringUtils.removeStart((String)postData, (String)"\""), (String)"\""));
        this.save(loggedInUser);
    }

    public AioUser[] findAll() throws SQLException {
        return (AioUser[])this.persistenceService.find(AioUser.class);
    }

    public List<AioScheduledReport> getScheduledReports(AioUser user) throws SQLException {
        ArrayList userScheduledReports = Lists.newArrayList();
        for (AioReport r2 : user.getReports()) {
            for (AioScheduledReport sr : r2.getScheduledReports()) {
                userScheduledReports.add(sr);
            }
        }
        return userScheduledReports;
    }

    public AioUser[] findByEmailAddress(String email) throws SQLException {
        if (StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        email = email.trim();
        AioUser[] users = (AioUser[])this.persistenceService.find(AioUser.class, "lower(\"emailAddress\") = ?", new Object[]{email});
        return users;
    }

    public AioUser createUserForHosted(MigratableUser mu) throws SQLException {
        AioUser aioUser = this.blankUser();
        aioUser.setUserkey(mu.getUserKey());
        aioUser.setUsername(mu.getUsername());
        aioUser.setDisplayName(mu.getDisplayName());
        aioUser.setEmailAddress(mu.getEmailAddress());
        aioUser.setTimeZone(mu.getTimeZone());
        aioUser.setLocale(mu.getLocale());
        return this.save(aioUser);
    }

    public Map<String, Object> getMyPreferences(AioUser loggedInUser) {
        HashMap m2 = Maps.newHashMap();
        AioUserPreferences aup = loggedInUser.getPreferences();
        if (aup == null) {
            m2.put("dailySummary", false);
            m2.put("customEmailTemplate", false);
            m2.put("emailSubject", "");
            m2.put("emailBody", "");
        } else {
            m2.put("dailySummary", aup.isDailySummary());
            if (aup.isDailySummary()) {
                Calendar c2 = Calendar.getInstance();
                c2.setTime(aup.getSummaryNextSendDate());
                int h2 = c2.get(11);
                if (h2 > 12) {
                    m2.put("summaryAmPm", "pm");
                    m2.put("summaryTime", "" + (h2 - 12));
                } else {
                    m2.put("summaryAmPm", "am");
                    m2.put("summaryTime", "" + h2);
                }
            }
            m2.put("customEmailTemplate", aup.isCustomEmailTemplate());
            if (aup.isCustomEmailTemplate()) {
                m2.put("emailSubject", aup.getEmailSubject());
                m2.put("emailBody", aup.getEmailBody());
            } else {
                m2.put("emailSubject", "");
                m2.put("emailBody", "");
            }
        }
        return m2;
    }

    public void setMyPreferences(AioUser loggedInUser, String postData) throws SQLException, JsonParseException, JsonMappingException, IOException {
        AioUserPreferences aup = loggedInUser.getPreferences();
        if (aup == null) {
            aup = this.persistenceService.create(AioUserPreferences.class);
            aup.setUser(loggedInUser);
            aup = this.persistenceService.save(aup);
        }
        JsonNode pNode = JsonUtils.stringToJsonNode(postData);
        aup.setDailySummary(pNode.get("dailySummary").asBoolean());
        if (aup.isDailySummary()) {
            aup.setSummaryNextSendDate(DateUtils.dateWithTime(JsonUtils.text(pNode, "summaryTime"), JsonUtils.text(pNode, "summaryAmPm")));
        }
        aup.setCustomEmailTemplate(pNode.get("customEmailTemplate").asBoolean());
        if (aup.isCustomEmailTemplate()) {
            aup.setEmailSubject(JsonUtils.text(pNode, "emailSubject"));
            aup.setEmailBody(JsonUtils.text(pNode, "emailBody"));
        }
        aup = this.persistenceService.save(aup);
    }
}

