/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.kaanha.reports.connect.JWT;
import com.kaanha.reports.connect.JWTHandler;
import com.kaanha.reports.exception.MultipleTenantsFoundException;
import com.kaanha.reports.exception.TenantNotFoundException;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.model.LifecycleEventType;
import com.kaanha.reports.model.TenantDTO;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioSharedReport;
import com.kaanha.reports.persistence.AioSharedTeam;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.Entity;
import org.springframework.util.StringUtils;

public class TenantPersistenceService {
    private final PersistenceService persistenceService;
    private JWTHandler jwtHandler = new JWTHandler();

    public TenantPersistenceService() throws Exception {
        this.persistenceService = PersistenceService.getInstance();
    }

    public AioTenant findByClientKeyAndAddOnKey(String clientKey, String addOnKey) throws SQLException, TenantNotFoundException, MultipleTenantsFoundException {
        AioTenant[] tenants = (AioTenant[])this.persistenceService.find(AioTenant.class, "clientKey = ? and addOnKey = ?", new Object[]{clientKey, addOnKey});
        if (tenants == null || tenants.length == 0) {
            throw new TenantNotFoundException(addOnKey);
        }
        if (tenants.length > 1) {
            throw new MultipleTenantsFoundException(clientKey, addOnKey);
        }
        return tenants[0];
    }

    public AioTenant registerLifecycleEvent(LifecycleEventType lifecycleEvent, TenantDTO tenant, HttpServletRequest request) throws Exception {
        AioTenant savedTenant;
        try {
            savedTenant = this.findByClientKeyAndAddOnKey(tenant.getClientKey(), tenant.getAddOnKey());
        }
        catch (TenantNotFoundException tnf) {
            savedTenant = null;
        }
        if (savedTenant == null) {
            if (LifecycleEventType.INSTALLED.equals((Object)lifecycleEvent)) {
                savedTenant = this.create(tenant);
                savedTenant.setTrialStarted(new Date());
                savedTenant.setTrialEnd(DateUtils.addDays(new Date(), 30));
                savedTenant.setInstallDate(new Date());
            }
        } else {
            if (LifecycleEventType.INSTALLED.equals((Object)lifecycleEvent)) {
                savedTenant.setSharedSecret(tenant.getSharedSecret());
            }
            savedTenant.setStatus(lifecycleEvent);
            savedTenant.setStatusDate(new Date());
            if (StringUtils.hasText((String)tenant.getServiceEntitlementNumber())) {
                savedTenant.setServiceEntitlementNumber(tenant.getServiceEntitlementNumber());
            }
        }
        if (savedTenant != null) {
            savedTenant = this.save(savedTenant);
        }
        return savedTenant;
    }

    private void verifyInstallRequest(HttpServletRequest request, AioTenant savedTenant) throws Exception {
        JWT jwt = null;
        boolean valid = false;
        Enumeration hNames = request.getHeaderNames();
        while (hNames.hasMoreElements()) {
            String hName = (String)hNames.nextElement();
            if (!hName.equals("Authorization")) continue;
            String JWT2 = request.getHeader(hName);
            jwt = this.jwtHandler.toObject(JWT2 = JWT2.substring(JWT2.indexOf(" ") + 1));
            if (!jwt.getIss().equals(savedTenant.getClientKey())) break;
            valid = this.jwtHandler.validate(JWT2, savedTenant.getSharedSecret());
            break;
        }
        if (!valid) {
            throw new Exception("Plugin Install request is not valid");
        }
    }

    private AioTenant create(TenantDTO tenant) throws SQLException {
        AioTenant newTenant = this.create();
        newTenant.setAddOnKey(tenant.getAddOnKey());
        newTenant.setBaseUrl(tenant.getBaseUrl());
        newTenant.setClientKey(tenant.getClientKey());
        newTenant.setDescription(tenant.getDescription());
        newTenant.setOauthClientId(tenant.getOauthClientId());
        newTenant.setPluginsVersion(tenant.getPluginsVersion());
        newTenant.setProductType(tenant.getProductType());
        newTenant.setPublicKey(tenant.getPublicKey());
        newTenant.setServerVersion(tenant.getServerVersion());
        newTenant.setServiceEntitlementNumber(tenant.getServiceEntitlementNumber());
        newTenant.setSharedSecret(tenant.getSharedSecret());
        newTenant.setLicenseActive(true);
        return this.save(newTenant);
    }

    public AioTenant create() throws SQLException {
        AioTenant newTenant = this.persistenceService.create(AioTenant.class);
        return newTenant;
    }

    public AioTenant save(AioTenant tenant) throws SQLException {
        return this.persistenceService.save(tenant);
    }

    public int count() throws SQLException {
        return ((AioTenant[])this.persistenceService.find(AioTenant.class)).length;
    }

    public void deleteAll() throws SQLException {
        this.persistenceService.delete(this.persistenceService.find(AioTenant.class));
    }

    public AioTenant[] findByAddOnKeyAndServiceEntitlementNumber(String addOnKey, String sen) throws SQLException {
        return (AioTenant[])this.persistenceService.find(AioTenant.class, "addOnKey = ? and serviceEntitlementNumber = ?", new Object[]{addOnKey, sen});
    }

    public void delete(AioTenant t2) throws SQLException {
        Entity[] users;
        for (AioUser aioUser : users = (AioUser[])this.persistenceService.find(AioUser.class, "tenantID = ?", new Object[]{t2.getID()})) {
            for (AioReport report : aioUser.getReports()) {
                Entity[] schReps;
                this.persistenceService.delete(this.persistenceService.find(AioSharedReport.class, "reportID = ?", new Object[]{report.getID()}));
                for (AioScheduledReport aioScheduledReport : schReps = (AioScheduledReport[])this.persistenceService.find(AioScheduledReport.class, "reportID = ?", new Object[]{report.getID()})) {
                    this.persistenceService.delete(this.persistenceService.find(AioSchedRepRcpt.class, "scheduledReportID = ?", new Object[]{aioScheduledReport.getID()}));
                }
                this.persistenceService.delete(schReps);
            }
            this.persistenceService.delete(aioUser.getReports());
            for (AioTeam team : aioUser.getTeams()) {
                this.persistenceService.delete(team.getMembers());
            }
            this.persistenceService.delete(aioUser.getTeams());
            this.persistenceService.delete(this.persistenceService.find(AioSharedTeam.class, "userID = ?", new Object[]{aioUser.getID()}));
        }
        this.persistenceService.delete(users);
        this.persistenceService.delete(new AioTenant[]{t2});
    }

    public AioTenant[] findAll() throws SQLException {
        return (AioTenant[])this.persistenceService.find(AioTenant.class);
    }

    public AioTenant[] findByBaseUrl(String baseUrl) throws SQLException {
        return (AioTenant[])this.persistenceService.find(AioTenant.class, "baseUrl = ?", new Object[]{baseUrl});
    }
}

