/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioSharedReport;
import com.kaanha.reports.persistence.AioSharedTeam;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeamPersistenceService {
    private final PersistenceService persistenceService = PersistenceService.getInstance();

    public void createOrUpdate(DTO dto, AioUser loggedInUser) throws Exception {
        Map<String, Object> team = dto.getTeam();
        UserPersistenceService ups = new UserPersistenceService();
        Object teamId = team.get("teamId");
        AioTeam aioTeam = null;
        if (teamId == null) {
            aioTeam = this.persistenceService.create(AioTeam.class);
            aioTeam.setOwner(loggedInUser);
        } else {
            aioTeam = this.findTeamById(loggedInUser, teamId);
            this.persistenceService.delete(aioTeam.getMembers());
        }
        aioTeam.setName(team.get("name").toString());
        aioTeam = this.save(aioTeam);
        JsonNode members = JsonUtils.stringToJsonNode(team.get("members").toString());
        for (JsonNode member : members) {
            AioUser _aioUser = ups.findOrCreateAioUser(loggedInUser, member);
            AioTeamMember tm = this.persistenceService.create(AioTeamMember.class);
            tm.setTeam(aioTeam);
            tm.setUser(_aioUser);
            tm = this.persistenceService.save(tm);
        }
    }

    public AioTeam findTeamById(AioUser loggedInUser, Object teamId) throws SQLException, Exception {
        AioTeam aioTeam = this.persistenceService.findById(AioTeam.class, Integer.parseInt(teamId.toString()));
        if (!loggedInUser.equals(aioTeam.getOwner())) {
            throw new Exception("You do not have permission to modify this team");
        }
        return aioTeam;
    }

    private AioTeam save(AioTeam aioTeam) throws SQLException {
        return this.persistenceService.save(aioTeam);
    }

    public void delete(String teamId, AioUser loggedInUser) throws SQLException, Exception {
        AioTeam aioTeam = this.findTeamById(teamId);
        if (aioTeam.getOwner().equals(loggedInUser)) {
            this.persistenceService.delete(aioTeam.getMembers());
            this.persistenceService.delete(this.persistenceService.find(AioSharedTeam.class, "teamID = ?", new Object[]{aioTeam.getID()}));
            this.persistenceService.delete(this.persistenceService.find(AioSharedReport.class, "teamID = ?", new Object[]{aioTeam.getID()}));
            this.persistenceService.delete(this.persistenceService.find(AioSchedRepRcpt.class, "teamID = ?", new Object[]{aioTeam.getID()}));
            this.persistenceService.delete(new AioTeam[]{aioTeam});
        } else {
            this.persistenceService.delete(this.persistenceService.find(AioSharedTeam.class, "teamID = ? and userID = ?", new Object[]{aioTeam.getID(), loggedInUser.getID()}));
        }
    }

    public AioTeam findTeamById(String teamId) throws NumberFormatException, SQLException {
        return this.persistenceService.findById(AioTeam.class, Integer.parseInt(teamId));
    }

    public List<AioTeam> getUserTeams(AioUser user) {
        ArrayList teams = Lists.newArrayList((Object[])user.getTeams());
        teams.addAll(Lists.newArrayList((Object[])user.getSharedTeams()));
        return teams;
    }

    public void shareTeam(JsonNode shareData, AioUser loggedInUser) throws Exception {
        UserPersistenceService ups = new UserPersistenceService();
        int teamId = Integer.parseInt(JsonUtils.text(shareData, "ID"));
        this.persistenceService.delete(this.manualTeamShares(teamId));
        for (JsonNode user : shareData.get("users")) {
            AioUser _aioUser = ups.findOrCreateAioUser(loggedInUser, user);
            this.shareTeamWithUser(_aioUser, teamId, false, loggedInUser);
        }
    }

    private AioSharedTeam[] manualTeamShares(int teamId) throws SQLException {
        return (AioSharedTeam[])this.persistenceService.find(AioSharedTeam.class, "teamID = ? and auto = ?", new Object[]{teamId, false});
    }

    public List<Map<String, String>> shareTeamUsers(String teamId, AioUser loggedInUser) throws NumberFormatException, SQLException {
        AioTeam aioTeam = this.findTeamById(teamId);
        ArrayList users = Lists.newArrayList();
        for (AioUser aioUser : aioTeam.getSharedWithUsers()) {
            HashMap m2 = Maps.newHashMap();
            m2.put("type", "user");
            m2.put("userkey", aioUser.getUserkey());
            users.add(m2);
        }
        return users;
    }

    public void shareTeamWithUser(AioUser user, int teamId, boolean auto, AioUser loggedInUser) throws SQLException {
        if (user.equals(loggedInUser)) {
            return;
        }
        if (((AioSharedTeam[])this.persistenceService.find(AioSharedTeam.class, "teamID = ? and userID = ?", new Object[]{teamId, user.getID()})).length == 0) {
            AioSharedTeam sr = this.persistenceService.create(AioSharedTeam.class);
            sr.setTeam(this.findTeamById("" + teamId));
            sr.setUser(user);
            sr.setAuto(auto);
            sr = this.persistenceService.save(sr);
        }
    }
}

