/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kaanha.reports.exception.ReportNotFoundException;
import com.kaanha.reports.exception.UserNotLoggedInException;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.helper.ResourceLoader;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.LinkType;
import com.kaanha.reports.persistence.AdminPersistenceService;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioSharedReport;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import com.kaanha.reports.persistence.TeamPersistenceService;
import com.kaanha.reports.persistence.UserPersistenceService;
import com.kaanha.reports.service.OfflineReportService;
import com.kaanha.reports.service.TrendReportingService;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;

public class ReportPersistenceService {
    private final PersistenceService persistenceService = PersistenceService.getInstance();
    private static Set<String> cannedReportCategories = null;

    public DTO save(DTO dto, AioUser loggedInUser) throws Exception {
        AioReport saved = null;
        saved = dto.getAioReportId() == null ? this.create(dto, loggedInUser) : this.update(dto, loggedInUser);
        return this.convertAioReportToDto(saved, loggedInUser, null);
    }

    private AioReport update(DTO dto, AioUser loggedInUser) throws SQLException, ReportNotFoundException, JsonProcessingException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, dto.getAioReportId());
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            this.convertDtoToAioReport(aioReport, dto);
            aioReport = this.save(aioReport);
            return aioReport;
        }
        throw new ReportNotFoundException();
    }

    private boolean userHasWriteAccessToReport(AioUser loggedInUser, AioReport aioReport) {
        return aioReport != null && aioReport.getOwner() != null && aioReport.getOwner().equals(loggedInUser) && !aioReport.isCanned();
    }

    private AioReport save(AioReport aioReport) throws SQLException {
        aioReport.setName(this.determineName(aioReport));
        aioReport.setLastModified(new Date());
        return this.persistenceService.save(aioReport);
    }

    private AioReport create(DTO dto, AioUser loggedInUser) throws SQLException, JsonProcessingException {
        AioReport aioReport = this.create();
        this.convertDtoToAioReport(aioReport, dto);
        aioReport.setOwner(loggedInUser);
        return this.save(aioReport);
    }

    private void convertDtoToAioReport(AioReport aioReport, DTO dto) throws JsonProcessingException {
        aioReport.setType(dto.getType());
        aioReport.setName(dto.getName());
        aioReport.setRow(JsonUtils.objectToJsonString(dto.getRow()));
        aioReport.setColumn(JsonUtils.objectToJsonString(dto.getColumn()));
        aioReport.setData(JsonUtils.objectToJsonString(dto.getData()));
        if ("custom".equalsIgnoreCase(dto.getDateRange())) {
            aioReport.setStartDate(dto.getStartDate());
            aioReport.setEndDate(dto.getEndDate());
        } else {
            aioReport.setStartDate(null);
            aioReport.setEndDate(null);
        }
        aioReport.setStartDate(dto.getStartDate());
        aioReport.setEndDate(dto.getEndDate());
        aioReport.setFilterType(dto.getFilterType());
        aioReport.setFilterValue(dto.getFilterValue());
        aioReport.setUsers(JsonUtils.objectToJsonString(dto.getUsers()));
        aioReport.setProjects(StringUtils.join(dto.getProjects(), (String)","));
        aioReport.setDateRange(dto.getDateRange());
        aioReport.setIssueTypes(StringUtils.join(dto.getIssueTypes(), (String)","));
        aioReport.setSubIssueTypes(StringUtils.join(dto.getSubIssueTypes(), (String)","));
        aioReport.setIncludeSubTasks(dto.isIncludeSubTasks());
        aioReport.setTrendField(dto.getTrendField());
        aioReport.setTrendValues(StringUtils.join(dto.getTrendValues(), (String)","));
        aioReport.setTrendInterval(dto.getTrendInterval());
        aioReport.setBreakByIssueType(dto.isBreakByIssueType());
        aioReport.setShowPercentages(dto.isShowPercentages());
        aioReport.setShowCumulative(dto.isShowCumulative());
        aioReport.setTrendOutputFormat(dto.getTrendOutputFormat());
        aioReport.setQuickTimesheet(dto.isQuickTimesheet());
        aioReport.setBaseJql(dto.getBaseJql());
        aioReport.setLegacyReportId(dto.getLegacyReportId());
        aioReport.setCanned(dto.getCanned() == null ? false : dto.getCanned());
        aioReport.setCategory(dto.getCategory());
        aioReport.setTimeInStatus(dto.isTimeInStatus());
        aioReport.setDays(dto.getDays());
        aioReport.setTimesheetInterval(dto.getTimesheetInterval());
        aioReport.setIncludeNonWorklog(dto.isIncludeNonWorklog());
    }

    private String determineName(AioReport aioReport) {
        String originalName;
        if (aioReport.isCanned()) {
            return aioReport.getName();
        }
        AioUser owner = aioReport.getOwner();
        AioReport[] ownerReports = owner.getReports();
        String outName = originalName = aioReport.getName();
        int i2 = 1;
        boolean uniqueNameFound = false;
        block2: while (!uniqueNameFound) {
            for (AioReport _report : ownerReports) {
                if (!_report.getName().equals(outName) || aioReport.getID() == _report.getID()) continue;
                try {
                    int end = outName.lastIndexOf(41);
                    int start = outName.lastIndexOf(40) + 1;
                    String number = outName.substring(start, end);
                    i2 = Integer.parseInt(number);
                    outName = StringUtils.trim((String)outName.substring(0, start - 1)) + " (" + ++i2 + ")";
                }
                catch (Exception e2) {
                    outName = originalName + " (" + i2 + ")";
                    ++i2;
                }
                continue block2;
            }
            uniqueNameFound = true;
        }
        return outName;
    }

    public DTO convertAioReportToDto(AioReport aioReport, AioUser loggedInUser, List<Field> schema) throws Exception {
        DTO dto = new DTO();
        dto.setType(aioReport.getType());
        dto.setTrendOutputFormat(aioReport.getTrendOutputFormat());
        dto.setName(aioReport.getName());
        if (schema == null) {
            dto.setRow(this.stringToFieldList(dto, aioReport.getRow()));
            dto.setColumn(this.stringToFieldList(dto, aioReport.getColumn()));
            dto.setData(this.stringToFieldList(dto, aioReport.getData()));
        } else {
            dto.setRow(this.stringToFieldList(dto, aioReport.getRow(), schema, dto.isTrend()));
            dto.setColumn(this.stringToFieldList(dto, aioReport.getColumn(), schema, dto.isTrend()));
            dto.setData(this.stringToFieldList(dto, aioReport.getData(), schema, dto.isTrend()));
        }
        dto.setStartDate(aioReport.getStartDate());
        dto.setEndDate(aioReport.getEndDate());
        dto.setDays(aioReport.getDays());
        dto.setFilterType(aioReport.getFilterType());
        dto.setFilterValue(aioReport.getFilterValue());
        dto.setAioReportId(aioReport.getID());
        if (loggedInUser != null) {
            dto.setLoggedInUserName(loggedInUser.getUsername());
        }
        if (aioReport.getOwner() != null) {
            dto.setOwnerId(aioReport.getOwner().getID());
            dto.setOwnerName(aioReport.getOwner().getDisplayName());
        }
        if (StringUtils.isNotBlank((String)aioReport.getUsers())) {
            dto.setUsers(JsonUtils.stringToType(aioReport.getUsers(), new TypeReference<List<JsonNode>>(){}));
        }
        if (StringUtils.isNotBlank((String)aioReport.getProjects())) {
            dto.setProjects(Lists.newArrayList((Object[])StringUtils.split((String)aioReport.getProjects(), (String)",")));
        }
        dto.setDateRange(aioReport.getDateRange());
        if (StringUtils.isNotBlank((String)aioReport.getIssueTypes())) {
            dto.setIssueTypes(Lists.newArrayList((Object[])StringUtils.split((String)aioReport.getIssueTypes(), (String)",")));
        }
        if (StringUtils.isNotBlank((String)aioReport.getSubIssueTypes())) {
            dto.setSubIssueTypes(Lists.newArrayList((Object[])StringUtils.split((String)aioReport.getSubIssueTypes(), (String)",")));
        }
        dto.setIncludeSubTasks(aioReport.getIncludeSubTasks());
        dto.setTrendField(aioReport.getTrendField());
        if (StringUtils.isNotBlank((String)aioReport.getTrendValues())) {
            dto.setTrendValues(Lists.newArrayList((Object[])StringUtils.split((String)aioReport.getTrendValues(), (String)",")));
        }
        dto.setTrendInterval(aioReport.getTrendInterval());
        dto.setBreakByIssueType(aioReport.isBreakByIssueType());
        dto.setShowPercentages(aioReport.isShowPercentages());
        dto.setShowCumulative(aioReport.isShowCumulative());
        dto.setQuickTimesheet(aioReport.isQuickTimesheet());
        dto.setPublishedLink(aioReport.getPublishedLink());
        if (aioReport.getLastPublishedDate() != null) {
            dto.setLastPublishedDate(DateUtils.applyTimezone(aioReport.getLastPublishedDate(), aioReport.getOwner() == null ? null : aioReport.getOwner().getTimeZone()));
        }
        dto.setBaseJql(aioReport.getBaseJql());
        dto.setIncludeNonWorklog(aioReport.isIncludeNonWorklog());
        String jql = aioReport.getBaseJql();
        if (dto.isTimesheet()) {
            jql = OfflineReportService.buildJqlForTimesheet(dto, jql);
        }
        dto.setJql(jql);
        dto.setCanned(aioReport.isCanned());
        dto.setTimeInStatus(aioReport.isTimeInStatus());
        dto.setTimesheetInterval(aioReport.getTimesheetInterval());
        return dto;
    }

    private List<Field> stringToFieldList(DTO dto, String fields, List<Field> schema, boolean isTrend) throws JsonParseException, JsonMappingException, IOException {
        ArrayList out = Lists.newArrayList();
        List<Field> _fields = this.stringToFieldList(dto, fields);
        if (_fields != null) {
            for (Field _f : _fields) {
                Field _fnc;
                if (_f == null) continue;
                Field _fno = null;
                String fId = _f.getId();
                if (fId.startsWith("name:")) {
                    String name;
                    if ((fId = fId.substring(fId.indexOf(":") + 1)).indexOf("_") == -1) {
                        name = fId;
                        _fno = Fielder.findInFieldsByName(name, schema);
                    } else {
                        name = fId.substring(fId.indexOf(":") + 1, fId.indexOf("_"));
                        String suffix = fId.substring(fId.indexOf("_") + 1);
                        Field f2 = Fielder.findInFieldsByName(name, schema);
                        if (f2 != null) {
                            fId = f2.getId() + "_" + suffix;
                            _fno = Fielder.findInFields(fId, schema);
                        }
                    }
                } else {
                    _fno = Fielder.findInFields(fId, schema);
                }
                if (_fno == null || !_fno.isReportable() && !isTrend || (_fnc = JsonUtils.stringToType(JsonUtils.objectToJsonString(_fno), new TypeReference<Field>(){})) == null) continue;
                if (_fnc.isNumber()) {
                    if (_f.isAggregate() || !StringUtils.isBlank((String)_f.getAggregateFunction())) {
                        _fnc.setAggregate(true);
                    } else {
                        _fnc.setAggregate(false);
                    }
                    _fnc.setAggregateFunction(_f.getAggregateFunction());
                }
                if (_fnc.isDate()) {
                    if (StringUtils.isBlank((String)_f.getPattern())) {
                        _fnc.setPattern("MMM dd, yyyy");
                    } else {
                        _fnc.setPattern(_f.getPattern());
                    }
                }
                if (StringUtils.isNotBlank((String)_f.getFilterValue())) {
                    _fnc.setFilterValue(_f.getFilterValue());
                }
                _fnc.setGroupBy(_f.isGroupBy());
                _fnc.setHidden(_f.isHidden());
                _fnc.setSortDir(_f.getSortDir());
                _fnc.setSortCounter(_f.getSortCounter());
                _fnc.setEpicRollUp(_f.isEpicRollUp());
                _fnc.setParentRollUp(_f.isParentRollUp());
                if (!StringUtils.equals((String)_fnc.getLabel(), (String)_f.getLabel())) {
                    _fnc.setLabel(_f.getLabel());
                }
                if (_f.getBuckets() == null) {
                    _fnc.setBuckets(Lists.newArrayList());
                } else {
                    _fnc.setBuckets(_f.getBuckets());
                }
                out.add(_fnc);
            }
        }
        return out;
    }

    public List<Field> stringToFieldList(DTO dto, String fields) throws IOException, JsonParseException, JsonMappingException {
        List<Field> _fields = JsonUtils.stringToType(fields, new TypeReference<List<Field>>(){});
        if (Utils.isGrid(dto)) {
            for (Field f2 : _fields) {
                LinkType linkType = LinkType.findByField(f2);
                if (linkType == null) continue;
                f2.setLink(true);
            }
        }
        return _fields;
    }

    public DTO open(DTO dto, AioUser loggedInUser, List<Field> schema) throws Exception {
        AioReport aioReport = null;
        Integer aioReportId = dto.getAioReportId();
        if (dto.getAioReportId() == null && dto.getDashboard().booleanValue()) {
            AioReport[] aioReports = (AioReport[])this.persistenceService.find(AioReport.class, "legacyReportId = ?", new Object[]{dto.getLegacyReportId()});
            if (aioReports != null && aioReports.length == 1) {
                aioReport = aioReports[0];
            }
        } else {
            aioReport = this.persistenceService.findById(AioReport.class, aioReportId);
        }
        if (this.userHasReadAccessToReport(loggedInUser, aioReport) || dto.getDashboard().booleanValue() && aioReport != null) {
            return this.convertAioReportToDto(aioReport, loggedInUser, schema);
        }
        throw new ReportNotFoundException();
    }

    private boolean userHasReadAccessToReport(AioUser loggedInUser, AioReport aioReport) {
        return aioReport != null && (this.userHasWriteAccessToReport(loggedInUser, aioReport) || this.reportIsSharedWithUser(aioReport, loggedInUser) || aioReport.isCanned());
    }

    private boolean reportIsSharedWithUser(AioReport aioReport, AioUser loggedInUser) {
        if (aioReport != null) {
            for (AioUser aioUser : aioReport.getSharedWithUsers()) {
                if (!aioUser.equals(loggedInUser)) continue;
                return true;
            }
            for (AioTeam aioTeam : aioReport.getSharedWithTeams()) {
                for (AioTeamMember tm : aioTeam.getMembers()) {
                    if (!tm.getUser().equals(loggedInUser)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void share(DTO dto, AioUser loggedInUser) throws Exception {
        DTO openedDto = this.open(dto, loggedInUser, null);
        ArrayList teamsToBeShared = Lists.newArrayList();
        if (openedDto.getUsers() != null) {
            for (JsonNode n2 : openedDto.getUsers()) {
                if (!"team".equals(JsonUtils.text(n2, "type"))) continue;
                teamsToBeShared.add(Integer.parseInt(JsonUtils.text(n2, "teamId")));
            }
        }
        UserPersistenceService ups = new UserPersistenceService();
        TeamPersistenceService teamPersistenceService = new TeamPersistenceService();
        this.persistenceService.delete(this.reportShares(dto.getAioReportId()));
        HashSet allUsers = Sets.newHashSet();
        for (JsonNode user : dto.getShareUsers()) {
            AioSharedReport sr = this.persistenceService.create(AioSharedReport.class);
            sr.setReport(this.persistenceService.findById(AioReport.class, dto.getAioReportId()));
            if ("team".equals(JsonUtils.text(user, "type"))) {
                AioTeam aioTeam = teamPersistenceService.findTeamById(JsonUtils.text(user, "teamId"));
                sr.setTeam(aioTeam);
                for (AioTeamMember atm : aioTeam.getMembers()) {
                    allUsers.add(atm.getUser());
                }
            } else if (StringUtils.isNotBlank((String)JsonUtils.text(user, "emailAddress"))) {
                AioUser _aioUser = ups.findOrCreateAioUser(loggedInUser, user);
                if (_aioUser.equals(loggedInUser)) continue;
                sr.setUser(_aioUser);
                allUsers.add(_aioUser);
            }
            sr = this.persistenceService.save(sr);
        }
        TeamPersistenceService tps = new TeamPersistenceService();
        for (AioUser u2 : allUsers) {
            Iterator iterator = teamsToBeShared.iterator();
            while (iterator.hasNext()) {
                int t2 = (Integer)iterator.next();
                tps.shareTeamWithUser(u2, t2, true, loggedInUser);
            }
        }
    }

    private AioSharedReport[] reportShares(int reportId) throws SQLException {
        return (AioSharedReport[])this.persistenceService.find(AioSharedReport.class, "reportID = ?", new Object[]{reportId});
    }

    private AioSchedRepRcpt[] reportSubscriptions(int reportId) throws SQLException {
        return (AioSchedRepRcpt[])this.persistenceService.find(AioSchedRepRcpt.class, "scheduledReportID = ?", new Object[]{reportId});
    }

    public List<Map<String, String>> shareUsers(int reportId, AioUser loggedInUser) throws ReportNotFoundException, SQLException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasReadAccessToReport(loggedInUser, aioReport)) {
            HashMap m2;
            ArrayList users = Lists.newArrayList();
            for (AioUser aioUser : aioReport.getSharedWithUsers()) {
                m2 = Maps.newHashMap();
                m2.put("type", "user");
                m2.put("userkey", aioUser.getUserkey());
                users.add(m2);
            }
            for (AioTeam aioTeam : aioReport.getSharedWithTeams()) {
                m2 = Maps.newHashMap();
                m2.put("type", "team");
                m2.put("teamId", "" + aioTeam.getID());
                users.add(m2);
            }
            return users;
        }
        throw new ReportNotFoundException();
    }

    public void delete(int reportId, AioUser loggedInUser) throws SQLException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (aioReport != null) {
            if (aioReport.isCanned()) {
                throw new SQLException("Cannot delete canned reports");
            }
            if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
                this.persistenceService.delete(this.reportShares(reportId));
                this.deleteScheduledReport(this.findScheduledReportForAioReport(reportId));
                this.persistenceService.delete(new AioReport[]{aioReport});
            } else if (this.userHasReadAccessToReport(loggedInUser, aioReport)) {
                this.persistenceService.delete(this.persistenceService.find(AioSharedReport.class, "reportID = ? and userID = ?", new Object[]{reportId, loggedInUser.getID()}));
            }
        }
    }

    public AioReport copy(int reportId, AioUser loggedInUser) throws Exception {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasReadAccessToReport(loggedInUser, aioReport)) {
            AioReport _aioReport = this.create();
            DTO dto = this.convertAioReportToDto(aioReport, loggedInUser, null);
            this.convertDtoToAioReport(_aioReport, dto);
            _aioReport.setOwner(loggedInUser);
            return this.save(_aioReport);
        }
        throw new ReportNotFoundException();
    }

    public AioReport runNow(int reportId, AioUser loggedInUser) throws SQLException, ReportNotFoundException, ParseException, IOException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            AioScheduledReport aioScheduledReport = this.findScheduledReportForAioReport(reportId);
            aioScheduledReport.setNextSendDate(new Date());
            aioScheduledReport.setFailureMessage(null);
            aioScheduledReport.setStatus(null);
            this.save(aioScheduledReport);
            return aioReport;
        }
        throw new ReportNotFoundException();
    }

    public DTO publish(int reportId, String publishedResults, AioUser loggedInUser) throws Exception {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            aioReport.setPublishedResults(publishedResults);
            aioReport.setLastPublishedDate(new Date());
            if (StringUtils.isBlank((String)aioReport.getPublishedLink())) {
                aioReport.setPublishedLink(UUID.randomUUID().toString());
            }
            return this.convertAioReportToDto(this.save(aioReport), loggedInUser, null);
        }
        throw new ReportNotFoundException();
    }

    public DTO findPublishedResultsByLink(String publishedLink, Object loggedInUser) throws Exception {
        AdminPersistenceService aps;
        AioReport[] aioReport = (AioReport[])this.persistenceService.find(AioReport.class, "publishedLink = ?", new Object[]{publishedLink});
        if (aioReport == null || aioReport.length == 0) {
            throw new ReportNotFoundException(true);
        }
        if (PersistenceService.isServer() && "true".equals((aps = new AdminPersistenceService()).getAddOnPreferences(aioReport[0].getOwner()).get("publishedReportAccess").get("value")) && loggedInUser == null) {
            throw new UserNotLoggedInException(true);
        }
        DTO dto = this.convertAioReportToDto(aioReport[0], null, null);
        if (dto.isTrend()) {
            TrendReportingService.trendValuesToData(dto);
        }
        dto.setPublishedResults(JsonUtils.stringToJsonNode(aioReport[0].getPublishedResults()));
        return dto;
    }

    public void unpublish(int reportId, AioUser loggedInUser) throws ReportNotFoundException, SQLException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            aioReport.setPublishedResults(null);
            aioReport.setPublishedLink(null);
            this.save(aioReport);
            return;
        }
        throw new ReportNotFoundException();
    }

    public List<AioScheduledReport> getAllReportSchedules() throws SQLException {
        Object[] schedules = (AioScheduledReport[])this.persistenceService.find(AioScheduledReport.class);
        ArrayList lSchedules = Lists.newArrayList((Object[])schedules);
        Collections.sort(lSchedules, new Comparator<AioScheduledReport>(){

            @Override
            public int compare(AioScheduledReport o1, AioScheduledReport o2) {
                return o1.getID() - o2.getID();
            }
        });
        return lSchedules;
    }

    public AioScheduledReport save(AioScheduledReport reportSchedule) throws SQLException {
        return this.persistenceService.save(reportSchedule);
    }

    public void subscribe(DTO dto, AioUser loggedInUser) throws Exception {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, dto.getAioReportId());
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            AioScheduledReport aioScheduledReport = this.findScheduledReportForAioReport(dto.getAioReportId());
            if (aioScheduledReport == null) {
                if (dto.getSubscribeUsers() == null || dto.getSubscribeUsers().size() == 0) {
                    return;
                }
                aioScheduledReport = this.persistenceService.create(AioScheduledReport.class);
            } else if (dto.getSubscribeUsers() == null || dto.getSubscribeUsers().size() == 0) {
                this.deleteScheduledReport(aioScheduledReport);
                return;
            }
            aioScheduledReport.setCronExpression(dto.getCronExpression());
            aioScheduledReport.setReadableSchedule(dto.getReadableSchedule());
            aioScheduledReport.setPublish(dto.isPublish());
            aioScheduledReport.setReport(aioReport);
            aioScheduledReport.setSubscriptionForm(JsonUtils.objectToJsonString(dto.getSubscriptionForm()));
            CronExpression cron = new CronExpression(dto.getCronExpression());
            aioScheduledReport.setNextSendDate(DateUtils.convertToUTC(cron.getNextValidTimeAfter(DateUtils.convertToLocal(new Date(), loggedInUser.getTimeZone())), loggedInUser.getTimeZone()));
            aioScheduledReport.setStatus(null);
            aioScheduledReport = this.persistenceService.save(aioScheduledReport);
            UserPersistenceService ups = new UserPersistenceService();
            TeamPersistenceService teamPersistenceService = new TeamPersistenceService();
            this.persistenceService.delete(this.reportSubscriptions(aioScheduledReport.getID()));
            for (JsonNode user : dto.getSubscribeUsers()) {
                AioSchedRepRcpt srr = this.persistenceService.create(AioSchedRepRcpt.class);
                if ("team".equals(JsonUtils.text(user, "type"))) {
                    srr.setTeam(teamPersistenceService.findTeamById(JsonUtils.text(user, "teamId")));
                } else {
                    AioUser _aioUser = ups.findOrCreateAioUser(loggedInUser, user);
                    srr.setRecipient(_aioUser);
                }
                srr.setScheduledReport(aioScheduledReport);
                srr.setUnsubscribeLink(UUID.randomUUID().toString());
                this.persistenceService.save(srr);
            }
        }
    }

    private void deleteScheduledReport(AioScheduledReport aioScheduledReport) throws SQLException {
        if (aioScheduledReport != null) {
            this.persistenceService.delete(aioScheduledReport.getScheduledReportRecipient());
            this.persistenceService.delete(new AioScheduledReport[]{aioScheduledReport});
        }
    }

    public DTO scheduledReport(int reportId, AioUser loggedInUser) throws SQLException, JsonParseException, JsonMappingException, IOException {
        AioReport aioReport = this.persistenceService.findById(AioReport.class, reportId);
        if (this.userHasWriteAccessToReport(loggedInUser, aioReport)) {
            AioScheduledReport aioScheduledReport = this.findScheduledReportForAioReport(reportId);
            if (aioScheduledReport == null) {
                return null;
            }
            DTO dto = new DTO();
            dto.setCronExpression(aioScheduledReport.getCronExpression());
            dto.setReadableSchedule(aioScheduledReport.getReadableSchedule());
            dto.setPublish(aioScheduledReport.isPublish());
            dto.setSubscriptionForm(JsonUtils.stringToJsonNode(aioScheduledReport.getSubscriptionForm()));
            ArrayList users = Lists.newArrayList();
            for (AioSchedRepRcpt _user : aioScheduledReport.getScheduledReportRecipient()) {
                HashMap m2 = Maps.newHashMap();
                if (_user.getRecipient() != null) {
                    m2.put("type", "user");
                    m2.put("userkey", _user.getRecipient().getUserkey());
                } else if (_user.getTeam() != null) {
                    m2.put("type", "team");
                    m2.put("teamId", "" + _user.getTeam().getID());
                }
                users.add(m2);
            }
            dto.setSubscribeUsers(JsonUtils.stringToType(JsonUtils.objectToJsonString(users), new TypeReference<List<JsonNode>>(){}));
            dto.setNextSendDate(aioScheduledReport.getNextSendDate());
            return dto;
        }
        return null;
    }

    private AioScheduledReport findScheduledReportForAioReport(int reportId) throws SQLException {
        AioScheduledReport[] scheduledReports = (AioScheduledReport[])this.persistenceService.find(AioScheduledReport.class, "reportID = ?", new Object[]{reportId});
        if (scheduledReports == null || scheduledReports.length == 0) {
            return null;
        }
        return scheduledReports[0];
    }

    public Map<Integer, AioScheduledReport> getScheduledReports(ArrayList<AioReport> savedReports) throws SQLException {
        HashMap out = Maps.newHashMap();
        for (AioReport _r : savedReports) {
            AioScheduledReport _sr = this.findScheduledReportForAioReport(_r.getID());
            if (_sr == null) continue;
            out.put(_r.getID(), _sr);
        }
        return out;
    }

    public int count() throws SQLException {
        return ((AioReport[])this.persistenceService.find(AioReport.class)).length;
    }

    public void deleteAll() throws SQLException {
        AioReport[] aioReports;
        for (AioReport r2 : aioReports = (AioReport[])this.persistenceService.find(AioReport.class)) {
            this.persistenceService.delete(this.reportShares(r2.getID()));
            this.deleteScheduledReport(this.findScheduledReportForAioReport(r2.getID()));
            this.persistenceService.delete(new AioReport[]{r2});
        }
    }

    public void deleteAllCanned() throws SQLException {
        this.persistenceService.delete(this.findCannedReports());
    }

    private AioReport[] findCannedReports() throws SQLException {
        return (AioReport[])this.persistenceService.find(AioReport.class, "canned = ?", new Object[]{true});
    }

    public List<AioReport> getCannedReports() throws SQLException {
        return Lists.newArrayList((Object[])this.persistenceService.find(AioReport.class, "canned = ? ", new Object[]{true}));
    }

    public static Set<String> getCannedReportCategories() throws SQLException {
        if (cannedReportCategories == null) {
            cannedReportCategories = Sets.newLinkedHashSet();
            cannedReportCategories.add("Agile Management");
            cannedReportCategories.add("Time Tracking");
            cannedReportCategories.add("Performance Measurement");
            cannedReportCategories.add("Project and Portfolio Management");
            cannedReportCategories.add("Trends over Time");
            cannedReportCategories.add("Other");
        }
        return cannedReportCategories;
    }

    public void populateCannedReports(AioUser loggedInUser) throws Exception {
        if (this.persistenceService.count(AioReport.class, "canned = ?", true) == 0) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            List cannedReports = (List)mapper.readValue(ResourceLoader.getClasspathResourceInputStream("canned-reports.json"), (TypeReference)new TypeReference<List<DTO>>(){});
            for (DTO dto : cannedReports) {
                this.save(dto, null);
            }
        }
    }

    public AioReport[] findByLegacyId(int legacyReportId) throws SQLException {
        AioReport[] ra = (AioReport[])this.persistenceService.find(AioReport.class, "legacyReportId = ? ", new Object[]{legacyReportId});
        if (ra != null && ra.length > 0) {
            return ra;
        }
        return null;
    }

    public AioScheduledReport findReportSchedule(int id2) throws SQLException {
        return this.persistenceService.findById(AioScheduledReport.class, id2);
    }

    public AioReport findByID(int id2, AioUser user) throws SQLException, ReportNotFoundException {
        AioReport report = this.persistenceService.findById(AioReport.class, id2);
        if (this.userHasReadAccessToReport(user, report)) {
            return report;
        }
        throw new ReportNotFoundException();
    }

    public AioReport create() throws SQLException {
        return this.persistenceService.create(AioReport.class);
    }
}

