/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioMetrics;
import com.kaanha.reports.persistence.AioPermissions;
import com.kaanha.reports.persistence.AioReport;
import com.kaanha.reports.persistence.AioSchedRepRcpt;
import com.kaanha.reports.persistence.AioScheduledReport;
import com.kaanha.reports.persistence.AioSharedReport;
import com.kaanha.reports.persistence.AioSharedTeam;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.AioUserPreferences;
import com.kaanha.reports.service.SchedulerService;
import java.sql.SQLException;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.EntityManager;
import net.java.ao.builder.EntityManagerBuilder;
import org.apache.log4j.Logger;

public class PersistenceService {
    private ActiveObjects ao;
    private EntityManager em;
    private static PersistenceService persistenceService;
    private static Logger logger;
    private static boolean server;

    public ActiveObjects getAo() {
        return this.ao;
    }

    public void setAo(ActiveObjects ao2) {
        this.ao = ao2;
    }

    public EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em2) {
        this.em = em2;
    }

    public <T extends Entity> T create(Class<T> type) throws SQLException {
        Entity entity = null;
        if (this.em != null) {
            entity = (Entity)this.em.create(type, new DBParam[0]);
        }
        if (this.ao != null) {
            entity = (Entity)this.ao.create(type, new DBParam[0]);
        }
        return (T)entity;
    }

    public <T extends Entity> T findById(Class<T> type, Integer id2) throws SQLException {
        Entity entity = null;
        if (this.em != null) {
            entity = (Entity)this.em.get(type, (Object)id2);
        }
        if (this.ao != null) {
            entity = (Entity)this.ao.get(type, (Object)id2);
        }
        return (T)entity;
    }

    public <T extends Entity> T save(T entity) throws SQLException {
        entity.save();
        if (this.em != null) {
            this.em.flushAll();
        }
        if (this.ao != null) {
            this.ao.flushAll();
        }
        return this.findById(entity.getEntityType(), entity.getID());
    }

    public static PersistenceService createCloudInstance() throws Exception {
        if (persistenceService == null) {
            try {
                persistenceService = new PersistenceService();
                persistenceService.setEm(EntityManagerBuilder.url((String)Utils.getEnvProperty("AIO_DB_URL")).username(Utils.getEnvProperty("AIO_DB_USERNAME")).password(Utils.getEnvProperty("AIO_DB_PASSWORD")).auto().build());
                persistenceService.getEm().migrate(new Class[]{AioReport.class, AioUser.class, AioTenant.class, AioSharedReport.class, AioScheduledReport.class, AioSchedRepRcpt.class, AioMetrics.class, AioTeam.class, AioTeamMember.class, AioPermissions.class, AioUserPreferences.class, AioSharedTeam.class});
                server = false;
            }
            catch (Exception e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return persistenceService;
    }

    public static PersistenceService createHostedInstance(ActiveObjects ao2) throws Exception {
        if (persistenceService == null) {
            persistenceService = new PersistenceService();
            persistenceService.setAo(ao2);
            server = true;
        }
        return persistenceService;
    }

    public static PersistenceService getInstance() throws Exception {
        if (persistenceService == null) {
            throw new Exception("Persistence service not initialized");
        }
        return persistenceService;
    }

    public <T extends Entity> T[] find(Class<T> type) throws SQLException {
        Entity[] entities = null;
        if (this.em != null) {
            entities = (Entity[])this.em.find(type);
        }
        if (this.ao != null) {
            entities = (Entity[])this.ao.find(type);
        }
        return entities;
    }

    public <T extends Entity> T[] find(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        Entity[] entities = null;
        if (this.em != null) {
            entities = (Entity[])this.em.find(type, criteria, parameters);
        }
        if (this.ao != null) {
            String _criteria = this.toAOColumnNames(criteria);
            entities = (Entity[])this.ao.find(type, _criteria, parameters);
        }
        return entities;
    }

    public <T extends Entity> int count(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        int count = 0;
        if (this.em != null) {
            count = this.em.count(type, criteria, parameters);
        }
        if (this.ao != null) {
            String _criteria = this.toAOColumnNames(criteria);
            count = this.ao.count(type, _criteria, parameters);
        }
        return count;
    }

    public String toAOColumnNames(String criteria) {
        String _criteria = "";
        int lastIndexOfUCL = Utils.lastIndexOfUCL(criteria);
        int prevIndex = -1;
        while (lastIndexOfUCL > -1) {
            if (prevIndex == lastIndexOfUCL + 1) {
                String upchar = criteria.substring(lastIndexOfUCL).toUpperCase();
                _criteria = "_" + upchar + _criteria.substring(1);
            } else {
                _criteria = "_" + criteria.substring(lastIndexOfUCL).toUpperCase() + _criteria;
            }
            criteria = criteria.substring(0, lastIndexOfUCL);
            prevIndex = lastIndexOfUCL;
            lastIndexOfUCL = Utils.lastIndexOfUCL(criteria);
        }
        _criteria = criteria.toUpperCase() + _criteria;
        return _criteria;
    }

    public <T extends Entity> void delete(T[] entities) throws SQLException {
        if (this.em != null) {
            this.em.delete(entities);
        }
        if (this.ao != null) {
            this.ao.delete(entities);
        }
    }

    public static boolean isServer() {
        return server;
    }

    public static void setServer(boolean server) {
        PersistenceService.server = server;
    }

    static {
        logger = Logger.getLogger(SchedulerService.class);
        server = false;
    }
}

