/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.persistence;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.persistence.AioPermissions;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.PersistenceService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AdminPersistenceService {
    private final PersistenceService persistenceService;
    private final Map<String, Map<String, String>> defaultPreferences = Maps.newTreeMap();

    public AdminPersistenceService() throws Exception {
        this.persistenceService = PersistenceService.getInstance();
        HashMap m2 = Maps.newHashMap();
        m2.put("type", "number");
        m2.put("label", "Business hours in a day");
        m2.put("value", "8");
        this.defaultPreferences.put("businessHoursPerDay", m2);
        if (PersistenceService.isServer()) {
            m2 = Maps.newHashMap();
            m2.put("type", "checkbox");
            m2.put("label", "Restrict published reports access to Active JIRA Users only");
            m2.put("value", "false");
            this.defaultPreferences.put("publishedReportAccess", m2);
        }
    }

    public void saveAddOnPermissions(AioUser loggedInUser, String postData) throws SQLException, JsonParseException, JsonMappingException, IOException {
        AioPermissions permissions = this.getAddOnPermissions(loggedInUser);
        if (permissions == null) {
            permissions = this.persistenceService.create(AioPermissions.class);
        }
        JsonNode pNode = JsonUtils.stringToJsonNode(postData);
        permissions.setCreateGroups(JsonUtils.objectToJsonString(pNode.get("aio_access_create")));
        permissions.setTimeGroups(JsonUtils.objectToJsonString(pNode.get("aio_access_other_time")));
        permissions = this.persistenceService.save(permissions);
        AioTenant tenant = loggedInUser.getTenant();
        if (tenant != null) {
            tenant.setPermissions(permissions);
            this.persistenceService.save(tenant);
        }
    }

    public Map<String, JsonNode> fetchAddOnPermissions(AioUser loggedInUser) throws SQLException, JsonParseException, JsonMappingException, IOException {
        AioPermissions permissions = this.getAddOnPermissions(loggedInUser);
        HashMap pNode = Maps.newHashMap();
        if (permissions != null) {
            if (permissions.getCreateGroups() != null) {
                pNode.put("aio_access_create", JsonUtils.stringToJsonNode(permissions.getCreateGroups()));
            }
            if (permissions.getTimeGroups() != null) {
                pNode.put("aio_access_other_time", JsonUtils.stringToJsonNode(permissions.getTimeGroups()));
            }
        }
        return pNode;
    }

    public AioPermissions getAddOnPermissions(AioUser loggedInUser) throws SQLException {
        if (loggedInUser == null) {
            return null;
        }
        AioPermissions permissions = null;
        AioTenant tenant = loggedInUser.getTenant();
        if (tenant == null) {
            AioPermissions[] permissionsArr = (AioPermissions[])this.persistenceService.find(AioPermissions.class);
            if (permissionsArr.length > 0) {
                permissions = permissionsArr[0];
            }
        } else {
            permissions = tenant.getPermissions();
        }
        return permissions;
    }

    public Map<String, Map<String, String>> getAddOnPreferences(AioUser loggedInUser) throws SQLException, IOException {
        AioPermissions permissions = this.getAddOnPermissions(loggedInUser);
        if (permissions == null) {
            return this.defaultPreferences;
        }
        String preferences = permissions.getPreferences();
        if (StringUtils.isBlank((CharSequence)preferences)) {
            preferences = JsonUtils.objectToJsonString(this.defaultPreferences);
        } else {
            Map<String, Map<String, String>> addOnPreferences = JsonUtils.stringToType(preferences, new TypeReference<Map<String, Map<String, String>>>(){});
            for (String defaultPreferenceKey : this.defaultPreferences.keySet()) {
                if (addOnPreferences.containsKey(defaultPreferenceKey)) continue;
                addOnPreferences.put(defaultPreferenceKey, this.defaultPreferences.get(defaultPreferenceKey));
            }
            preferences = JsonUtils.objectToJsonString(addOnPreferences);
        }
        return JsonUtils.stringToType(preferences, new TypeReference<Map<String, Map<String, String>>>(){});
    }

    public void saveAddOnPreferences(AioUser loggedInUser, String postData) throws SQLException, JsonParseException, JsonMappingException, IOException {
        AioPermissions permissions = this.getAddOnPermissions(loggedInUser);
        if (permissions == null) {
            permissions = this.persistenceService.create(AioPermissions.class);
        }
        JsonNode pNode = JsonUtils.stringToJsonNode(postData).get("preferences");
        Map<String, Map<String, String>> preferences = this.getAddOnPreferences(loggedInUser);
        for (JsonNode preference : pNode) {
            preferences.get(preference.get("key").asText()).put("value", preference.get("val").asText());
        }
        permissions.setPreferences(JsonUtils.objectToJsonString(preferences));
        permissions = this.persistenceService.save(permissions);
        AioTenant tenant = loggedInUser.getTenant();
        if (tenant != null) {
            tenant.setPermissions(permissions);
            this.persistenceService.save(tenant);
        }
    }
}

