/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.model;

import com.kaanha.reports.connect.ConnectUtils;
import com.kaanha.reports.helper.Constants;
import com.kaanha.reports.helper.HttpUtils;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.persistence.AioKey;
import com.kaanha.reports.persistence.AioTenant;
import com.kaanha.reports.persistence.AioUser;
import com.kaanha.reports.persistence.KeyPersistenceService;
import com.kaanha.reports.persistence.TenantPersistenceService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import java.io.StringWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemWriter;

public class OAuthParams {
    String addOnKey;
    String consumerKey;
    String consumerPrivateKey;
    String baseUrl;
    AioUser user;
    String callbackUrl;
    String publicKey;

    private OAuthParams() {
    }

    public String getAddOnKey() {
        return this.addOnKey;
    }

    public void setAddOnKey(String addOnKey) {
        this.addOnKey = addOnKey;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerPrivateKey() {
        return this.consumerPrivateKey;
    }

    public void setConsumerPrivateKey(String consumerPrivateKey) {
        this.consumerPrivateKey = consumerPrivateKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public AioUser getUser() {
        return this.user;
    }

    public void setUser(AioUser user) {
        this.user = user;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public static OAuthParams build(PlatformTypeEnum platformType, HttpServletRequest request, AioUser user, String action) throws Exception {
        OAuthParams oAuthParams = new OAuthParams();
        oAuthParams.setUser(user);
        if (PlatformTypeEnum.HOSTED.equals((Object)platformType)) {
            TenantPersistenceService tps = new TenantPersistenceService();
            AioTenant t2 = null;
            AioTenant[] tenants = tps.findAll();
            t2 = tenants.length == 0 ? tps.create() : tenants[0];
            KeyPersistenceService keyPersistenceService = new KeyPersistenceService();
            if (!keyPersistenceService.hasKey()) {
                oAuthParams.generateKey();
            }
            AioKey key = keyPersistenceService.getKey();
            String qs = "";
            if (request != null) {
                String requestBaseUrl = HttpUtils.getBaseUrl(request);
                String addOnKey = request.getAttribute("addOnKey").toString();
                t2.setBaseUrl(requestBaseUrl);
                t2.setAddOnKey(addOnKey);
                t2 = tps.save(t2);
                qs = request.getQueryString();
                if ("/rest".equals(action)) {
                    qs = qs + "&action=rest";
                }
            }
            oAuthParams.setAddOnKey(t2.getAddOnKey());
            oAuthParams.setBaseUrl(t2.getBaseUrl());
            String oAuthCBU = "/plugins/servlet/aio-tb/view/oauth";
            if ("com.kaanha.reports".equals(t2.getAddOnKey())) {
                oAuthCBU = "/plugins/servlet/aio/view/oauth";
            } else if ("com.kaanha.timesheets".equals(t2.getAddOnKey())) {
                oAuthCBU = "/plugins/servlet/aio-ts/view/oauth";
            }
            oAuthParams.setCallbackUrl(new StringBuffer(t2.getBaseUrl()).append(oAuthCBU).append("?").append(qs).toString());
            oAuthParams.setConsumerKey(Constants.addOnName(oAuthParams.getAddOnKey()));
            oAuthParams.setConsumerPrivateKey(key.getPrivateKey());
            oAuthParams.setPublicKey(key.getPublicKey());
        } else {
            String requestBaseUrl = null;
            if (request != null) {
                requestBaseUrl = HttpUtils.getBaseUrl(request);
            }
            String consumerKeyEnvVariableName = Utils.consumerKeyEnvVariableName(user.getTenant().getAddOnKey());
            oAuthParams.setConsumerKey(Utils.getEnvProperty(consumerKeyEnvVariableName));
            oAuthParams.setConsumerPrivateKey(Utils.getEnvProperty("CONSUMER_PRIVATE_KEY"));
            oAuthParams.setBaseUrl(user.getTenant().getBaseUrl());
            oAuthParams.setPublicKey("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6VHbvCjXt6QUprqxOxxS2q/LGqpbdN+Sco0I7fp7PHFEYZwbXnUsRoyBkHE3S9IKLIIxDdQOHHYBSD8v5WKHS98AJ+OYLmWVz9fuYfKFDhO1zqxNRPGf1t48Gz2Bg+NKmvPwLBAMv1+3nQOBU9q9ZW3RdpyuRZ0FP2MYv4bnMJJeREbxlaLxvVpENXh4wugJzToNKlagraSSf9HxOdI09RR1r9tqVXuuu+jaVAOmsC8Atutxafy8L4yPeyU2aTkoyE9EEvyQSmw+25T3qMT9KyHHLTzk1cOXTsVUjd59R9WYtfOTh8aIMxykt4lUWptDujZycblikUQnzXU1mZQK1wIDAQAB");
            if (request != null) {
                oAuthParams.setAddOnKey(ConnectUtils.extractAtlassianParamsFromRequest(request).getAok());
                String qs = request.getQueryString();
                if ("/rest".equals(action)) {
                    qs = qs + "&action=rest";
                }
                oAuthParams.setCallbackUrl(new StringBuffer(requestBaseUrl).append("/aio/view/oauth").append("?").append(qs).toString());
            }
        }
        return oAuthParams;
    }

    public void generateKey() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey priv = pair.getPrivate();
        PublicKey pub = pair.getPublic();
        PemObject po = new PemObject("Private Key", priv.getEncoded());
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter(stringWriter);
        pemWriter.writeObject(po);
        pemWriter.close();
        String privateKey = stringWriter.toString();
        privateKey = privateKey.substring(privateKey.indexOf("\n"));
        privateKey = privateKey.substring(0, privateKey.lastIndexOf("\n"));
        privateKey = privateKey.substring(0, privateKey.lastIndexOf("\n"));
        privateKey = privateKey.replace("\n", "").replace("\r", "");
        po = new PemObject("Public Key", pub.getEncoded());
        stringWriter = new StringWriter();
        pemWriter = new PemWriter(stringWriter);
        pemWriter.writeObject(po);
        pemWriter.close();
        String publicKey = stringWriter.toString();
        publicKey = publicKey.substring(publicKey.indexOf("\n"));
        publicKey = publicKey.substring(0, publicKey.lastIndexOf("\n"));
        publicKey = publicKey.substring(0, publicKey.lastIndexOf("\n"));
        publicKey = publicKey.replace("\n", "").replace("\r", "");
        KeyPersistenceService keyPersistenceService = new KeyPersistenceService();
        keyPersistenceService.create(privateKey, publicKey);
    }
}

