/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.model;

import com.kaanha.reports.model.Field;
import com.kaanha.reports.service.SchemaBuilder;

public enum LinkType {
    ISSUE("issuekey", "/browse/"),
    PROJECT(SchemaBuilder.derivedFieldId("project", "key"), "/projects/"),
    PROJECT_NAME(SchemaBuilder.derivedFieldId("project", "name"), "/issues/?jql=project="),
    PARENT("parent", "/browse/"),
    ISSUELINKS("issuelinks", "/issues/?jql=issuekey in ", true),
    SUBTASKS("subtasks", "/issues/?jql=issuekey in ", true),
    EPIC_LINK("Epic Link", "/browse/");

    private String fieldId;
    private String url;
    private boolean array = false;

    private LinkType(String fieldId, String url) {
        this(fieldId, url, false);
    }

    private LinkType(String fieldId, String url, boolean array) {
        this.fieldId = fieldId;
        this.url = url;
        this.array = array;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public static LinkType findByField(Field field) {
        for (LinkType olt : LinkType.values()) {
            if (!olt.getFieldId().equals(field.getId())) continue;
            return olt;
        }
        for (LinkType olt : LinkType.values()) {
            if (!olt.getFieldId().equals(field.getName())) continue;
            return olt;
        }
        return null;
    }
}

