/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.kaanha.reports.model.FieldType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Field {
    private String id;
    private String name;
    private FieldType type;
    private boolean measure;
    private List<Field> dependsOn = Lists.newArrayList();
    private String jiraType;
    private boolean raw;
    private String columnName;
    private boolean date;
    private boolean number;
    private boolean aggregate;
    private String operation;
    private String aggregateFunction;
    private String aggregateFunctionDisplay;
    private String pattern;
    private String expression;
    private boolean derived;
    private String group;
    private boolean reportable = true;
    private boolean link = false;
    @JsonIgnore
    private JsonNode clauseNames;
    @JsonIgnore
    private String clauseName;
    @JsonIgnore
    private JsonNode auto;
    private boolean filterable = false;
    @JsonIgnore
    private JsonNode operators;
    @JsonIgnore
    private boolean isUserType;
    private String filterValue;
    private boolean groupBy;
    private String label;
    private boolean hidden = false;
    private String sortDir;
    private Integer sortCounter;
    private List<Map<String, String>> buckets = Lists.newArrayList();
    private boolean percent;
    private String percentOverId;
    private boolean epicRollUp;
    private boolean parentRollUp;

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
        this.number = false;
        this.measure = false;
        this.date = false;
        if (FieldType.TIMESTAMP.equals((Object)type)) {
            this.date = true;
        } else if (FieldType.NUMBER.equals((Object)type)) {
            this.number = true;
            this.measure = true;
        }
    }

    public boolean isMeasure() {
        return this.measure;
    }

    public List<Field> getDependsOn() {
        return this.dependsOn;
    }

    public String getJiraType() {
        return this.jiraType;
    }

    public void setJiraType(String jiraType) {
        this.jiraType = jiraType;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public String getOperation() {
        return StringUtils.isBlank((String)this.operation) ? "" : this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getAggregateFunction() {
        return this.aggregateFunction;
    }

    public void setAggregateFunction(String aggregateFunction) {
        this.aggregateFunction = aggregateFunction;
        this.aggregateFunctionDisplay = "SUM".equals(this.aggregateFunction) ? "Sum" : ("AVG".equals(this.aggregateFunction) ? "Average" : ("MAX".equals(this.aggregateFunction) ? "Max" : ("Min".equals(this.aggregateFunction) ? "Min" : "")));
    }

    public String getAggregateFunctionDisplay() {
        return this.aggregateFunctionDisplay;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpression() {
        return StringUtils.isBlank((String)this.expression) ? this.id : this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isReportable() {
        return this.reportable;
    }

    public void setReportable(boolean reportable) {
        this.reportable = reportable;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public JsonNode getClauseNames() {
        return this.clauseNames;
    }

    public void setClauseNames(JsonNode clauseNames) {
        this.clauseNames = clauseNames;
    }

    public String getClauseName() {
        return this.clauseName;
    }

    public void setClauseName(String clauseName) {
        this.clauseName = clauseName;
    }

    public JsonNode getAuto() {
        return this.auto;
    }

    public void setAuto(JsonNode auto) {
        this.auto = auto;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public JsonNode getOperators() {
        return this.operators;
    }

    public void setOperators(JsonNode operators) {
        this.operators = operators;
    }

    public boolean isUserType() {
        return this.isUserType;
    }

    public void setUserType(boolean isUserType) {
        this.isUserType = isUserType;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public boolean isGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(boolean groupBy) {
        this.groupBy = groupBy;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getSortDir() {
        return this.sortDir;
    }

    public void setSortDir(String sortDir) {
        this.sortDir = sortDir;
    }

    public Integer getSortCounter() {
        return this.sortCounter;
    }

    public void setSortCounter(Integer sortCounter) {
        this.sortCounter = sortCounter;
    }

    public List<Map<String, String>> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<Map<String, String>> buckets) {
        this.buckets = buckets;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean percent) {
        this.percent = percent;
    }

    public String getPercentOverId() {
        return this.percentOverId;
    }

    public void setPercentOverId(String percentOverId) {
        this.percentOverId = percentOverId;
    }

    public boolean isEpicRollUp() {
        return this.epicRollUp;
    }

    public void setEpicRollUp(boolean epicRollUp) {
        this.epicRollUp = epicRollUp;
    }

    public boolean isParentRollUp() {
        return this.parentRollUp;
    }

    public void setParentRollUp(boolean parentRollUp) {
        this.parentRollUp = parentRollUp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Field [id=" + this.id + ", name=" + this.name + ", group=" + this.group + "]";
    }
}

