/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.kaanha.reports.helper.DateUtils;
import com.kaanha.reports.helper.Fielder;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.Field;
import com.kaanha.reports.model.FilterType;
import com.kaanha.reports.model.ReportType;
import com.kaanha.reports.persistence.AioTeam;
import com.kaanha.reports.persistence.AioTeamMember;
import com.kaanha.reports.persistence.TeamPersistenceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DTO {
    ReportType type;
    List<Field> schema;
    List<Field> row;
    List<Field> column;
    List<Field> data;
    List<String> queryFields;
    List<JsonNode> issues;
    String timezone;
    String startDate;
    String endDate;
    List<Field> _all;
    Integer aioReportId;
    String name;
    FilterType filterType;
    String filterValue;
    List<JsonNode> shareUsers;
    List<JsonNode> subscribeUsers;
    JsonNode subscriptionForm;
    String readableSchedule;
    String cronExpression;
    int ownerId;
    List<JsonNode> users;
    List<String> projects;
    String dateRange;
    List<String> issueTypes;
    List<String> subIssueTypes;
    boolean includeSubTasks;
    String trendField;
    List<String> trendValues;
    String trendInterval;
    boolean breakByIssueType;
    boolean showPercentages;
    boolean showCumulative;
    String trendOutputFormat;
    boolean quickTimesheet;
    String publishedLink;
    JsonNode publishedResults;
    boolean publish;
    Date nextSendDate;
    Date lastPublishedDate;
    String ownerName;
    String baseJql;
    String jql;
    String jiraBaseUrl;
    Integer legacyReportId;
    Boolean dashboard;
    Boolean canned;
    String category;
    boolean timeInStatus;
    boolean tableau;
    Integer days;
    String timesheetInterval;
    Map<String, Object> team;
    boolean grouped;
    String loggedInUserName;
    boolean includeNonWorklog;
    boolean timeEntry;
    Map<String, Integer> priorities;
    List<Field> helpers = Lists.newArrayList();

    public ReportType getType() {
        return this.type;
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    @JsonIgnore
    public List<Field> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public void setSchema(List<Field> schema) {
        this.schema = schema;
    }

    public List<Field> getRow() {
        return this.row;
    }

    public void setRow(List<Field> row) {
        this.row = row;
    }

    public List<Field> getColumn() {
        return this.column;
    }

    public void setColumn(List<Field> column) {
        this.column = column;
    }

    public List<Field> getData() {
        return this.data;
    }

    public void setData(List<Field> data) {
        this.data = data;
    }

    @JsonIgnore
    public List<Field> getQueryFields() {
        return Fielder.idsToFields(this.queryFields, this.schema);
    }

    @JsonProperty
    public void setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
    }

    @JsonIgnore
    public List<JsonNode> getIssues() {
        return this.issues;
    }

    @JsonProperty
    public void setIssues(List<JsonNode> issues) {
        this.issues = issues;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @JsonIgnore
    public boolean isList() {
        return ReportType.list.equals((Object)this.type);
    }

    @JsonIgnore
    public boolean isCrosstab() {
        return ReportType.matrix.equals((Object)this.type);
    }

    public boolean isTimesheet() {
        return ReportType.timesheet.equals((Object)this.type);
    }

    @JsonIgnore
    public boolean isPie() {
        return ReportType.pie.equals((Object)this.type);
    }

    @JsonIgnore
    public boolean isBar() {
        return ReportType.bar.equals((Object)this.type);
    }

    @JsonIgnore
    public boolean isLine() {
        return ReportType.line.equals((Object)this.type);
    }

    @JsonIgnore
    public boolean isTrend() {
        return ReportType.trend.equals((Object)this.type);
    }

    @JsonIgnore
    public List<Field> getAllFields() {
        return this.getAllFields(false);
    }

    @JsonIgnore
    public List<Field> getAllFields(boolean force) {
        if (this._all == null || force) {
            this._all = Lists.newArrayList();
            this._all.addAll(this.getRow());
            this._all.addAll(this.getColumn());
            this._all.addAll(this.getData());
        }
        return this._all;
    }

    public Integer getAioReportId() {
        return this.aioReportId;
    }

    public void setAioReportId(Integer aioReportId) {
        this.aioReportId = aioReportId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    @JsonIgnore
    public List<JsonNode> getShareUsers() {
        return this.shareUsers;
    }

    @JsonProperty
    public void setShareUsers(List<JsonNode> shareUsers) {
        this.shareUsers = shareUsers;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public List<JsonNode> getUsers() {
        return this.users;
    }

    public void setUsers(List<JsonNode> users) {
        this.users = users;
    }

    public List<String> getProjects() {
        return this.projects;
    }

    public void setProjects(List<String> projects) {
        this.projects = projects;
    }

    public String getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(String dateRange) {
        this.dateRange = dateRange;
    }

    public List<String> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(List<String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public List<String> getSubIssueTypes() {
        return this.subIssueTypes;
    }

    public void setSubIssueTypes(List<String> subIssueTypes) {
        this.subIssueTypes = subIssueTypes;
    }

    public boolean isIncludeSubTasks() {
        return this.includeSubTasks;
    }

    public void setIncludeSubTasks(boolean includeSubTasks) {
        this.includeSubTasks = includeSubTasks;
    }

    public String getTrendField() {
        return this.trendField;
    }

    public void setTrendField(String trendField) {
        this.trendField = trendField;
    }

    public List<String> getTrendValues() {
        return this.trendValues;
    }

    public void setTrendValues(List<String> trendValues) {
        this.trendValues = trendValues;
    }

    public String getTrendInterval() {
        return this.trendInterval;
    }

    public void setTrendInterval(String trendInterval) {
        this.trendInterval = trendInterval;
    }

    public boolean isBreakByIssueType() {
        return this.breakByIssueType;
    }

    public void setBreakByIssueType(boolean breakByIssueType) {
        this.breakByIssueType = breakByIssueType;
    }

    public boolean isShowPercentages() {
        return this.showPercentages;
    }

    public void setShowPercentages(boolean showPercentages) {
        this.showPercentages = showPercentages;
    }

    public boolean isShowCumulative() {
        return this.showCumulative;
    }

    public void setShowCumulative(boolean showCumulative) {
        this.showCumulative = showCumulative;
    }

    public String getTrendOutputFormat() {
        return this.trendOutputFormat;
    }

    public void setTrendOutputFormat(String trendOutputFormat) {
        this.trendOutputFormat = trendOutputFormat;
    }

    public boolean isQuickTimesheet() {
        return this.quickTimesheet;
    }

    public void setQuickTimesheet(boolean quickTimesheet) {
        this.quickTimesheet = quickTimesheet;
    }

    public String getPublishedLink() {
        return this.publishedLink;
    }

    public void setPublishedLink(String publishedLink) {
        this.publishedLink = publishedLink;
    }

    public JsonNode getPublishedResults() {
        return this.publishedResults;
    }

    public void setPublishedResults(JsonNode publishedResults) {
        this.publishedResults = publishedResults;
    }

    public List<JsonNode> getSubscribeUsers() {
        return this.subscribeUsers;
    }

    public void setSubscribeUsers(List<JsonNode> subscribeUsers) {
        this.subscribeUsers = subscribeUsers;
    }

    public JsonNode getSubscriptionForm() {
        return this.subscriptionForm;
    }

    public void setSubscriptionForm(JsonNode subscriptionForm) {
        this.subscriptionForm = subscriptionForm;
    }

    public String getReadableSchedule() {
        return this.readableSchedule;
    }

    public void setReadableSchedule(String readableSchedule) {
        this.readableSchedule = readableSchedule;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public Date getNextSendDate() {
        return this.nextSendDate;
    }

    public void setNextSendDate(Date nextSendDate) {
        this.nextSendDate = nextSendDate;
    }

    @JsonIgnore
    public void setLastPublishedDate(Date lastPublishedDate) {
        this.lastPublishedDate = lastPublishedDate;
    }

    @JsonProperty
    public String getLastPublishedDateDisplay() {
        return DateUtils.format(this.lastPublishedDate, "MMM-dd-yyyy 'at' hh:mm a");
    }

    @JsonIgnore
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @JsonProperty
    public String getOwnerName() {
        return this.ownerName;
    }

    public String getBaseJql() {
        return this.baseJql;
    }

    public void setBaseJql(String baseJql) {
        this.baseJql = baseJql;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public String getJiraBaseUrl() {
        return this.jiraBaseUrl;
    }

    public void setJiraBaseUrl(String jiraBaseUrl) {
        this.jiraBaseUrl = jiraBaseUrl;
    }

    public Integer getLegacyReportId() {
        return this.legacyReportId;
    }

    public void setLegacyReportId(Integer legacyReportId) {
        this.legacyReportId = legacyReportId;
    }

    public Boolean getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Boolean dashboard) {
        this.dashboard = dashboard;
    }

    public Boolean getCanned() {
        return this.canned;
    }

    public void setCanned(Boolean canned) {
        this.canned = canned;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isTimeInStatus() {
        return this.timeInStatus;
    }

    public void setTimeInStatus(boolean timeInStatus) {
        this.timeInStatus = timeInStatus;
    }

    @JsonIgnore
    public boolean isTableau() {
        return this.tableau;
    }

    @JsonIgnore
    public void setTableau(boolean tableau) {
        this.tableau = tableau;
    }

    public Integer getDays() {
        return this.days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public String getTimesheetInterval() {
        if (StringUtils.isBlank((CharSequence)this.timesheetInterval)) {
            return "daily";
        }
        return this.timesheetInterval;
    }

    public void setTimesheetInterval(String timesheetInterval) {
        this.timesheetInterval = timesheetInterval;
    }

    public Map<String, Object> getTeam() {
        return this.team;
    }

    public void setTeam(Map<String, Object> team) {
        this.team = team;
    }

    public String getLoggedInUserName() {
        return this.loggedInUserName;
    }

    public void setLoggedInUserName(String loggedInUserName) {
        this.loggedInUserName = loggedInUserName;
    }

    public boolean isIncludeNonWorklog() {
        return this.includeNonWorklog;
    }

    public void setIncludeNonWorklog(boolean includeNonWorklog) {
        this.includeNonWorklog = includeNonWorklog;
    }

    public boolean isTimeEntry() {
        return this.timeEntry;
    }

    public void setTimeEntry(boolean timeEntry) {
        this.timeEntry = timeEntry;
    }

    public Map<String, Integer> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(Map<String, Integer> priorities) {
        this.priorities = priorities;
    }

    @JsonIgnore
    public List<Field> getHelpers() {
        return this.helpers;
    }

    @JsonIgnore
    public void setAverageHelpers(List<Field> averageHelpers) {
        this.helpers = averageHelpers;
    }

    public String toString() {
        return "DTO [type=" + (Object)((Object)this.type) + ", schema=" + this.schema + ", row=" + this.row + ", column=" + this.column + ", data=" + this.data + ", queryFields=" + this.queryFields + ", issues=" + this.issues + ", timezone=" + this.timezone + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", aioReportId=" + this.aioReportId + ", name=" + this.name + ", filterType=" + (Object)((Object)this.filterType) + ", filterValue=" + this.filterValue + ", shareUsers=" + this.shareUsers + ", subscribeUsers=" + this.subscribeUsers + ", subscriptionForm=" + this.subscriptionForm + ", readableSchedule=" + this.readableSchedule + ", cronExpression=" + this.cronExpression + ", ownerId=" + this.ownerId + ", users=" + this.users + ", projects=" + this.projects + ", dateRange=" + this.dateRange + ", issueTypes=" + this.issueTypes + ", includeSubTasks=" + this.includeSubTasks + ", trendField=" + this.trendField + ", trendValues=" + this.trendValues + ", trendInterval=" + this.trendInterval + ", breakByIssueType=" + this.breakByIssueType + ", showPercentages=" + this.showPercentages + ", showCumulative=" + this.showCumulative + ", trendOutputFormat=" + this.trendOutputFormat + ", quickTimesheet=" + this.quickTimesheet + ", publishedLink=" + this.publishedLink + ", publishedResults=" + this.publishedResults + "]";
    }

    @JsonIgnore
    public List<String> determineTimesheetUsers() throws Exception {
        TeamPersistenceService tps = new TeamPersistenceService();
        List<JsonNode> users = this.getUsers();
        ArrayList _users = Lists.newArrayList();
        if (users != null) {
            for (JsonNode _u : users) {
                if ("team".equals(JsonUtils.text(_u, "type"))) {
                    String teamId = JsonUtils.text(_u, "teamId");
                    AioTeam t2 = tps.findTeamById(teamId);
                    if (t2 == null) continue;
                    for (AioTeamMember tm : t2.getMembers()) {
                        _users.add("\"" + tm.getUser().getUsername() + "\"");
                    }
                    continue;
                }
                String userkey = JsonUtils.text(_u, "userkey");
                if ("aio_loggedin_userkey".equals(userkey)) {
                    _users.add("\"" + this.loggedInUserName + "\"");
                    continue;
                }
                _users.add("\"" + JsonUtils.text(_u, "username") + "\"");
            }
        }
        return _users;
    }
}

