/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.kaanha.reports.model.DTO;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static String getEnvironment() {
        try {
            return Utils.getEnvProperty("JIRA_REPORTS_ENV");
        }
        catch (Exception e2) {
            return "UNKNOWN";
        }
    }

    public static String getEnvProperty(String propertyName) throws Exception {
        String propertyValue = System.getenv().get(propertyName);
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            throw new Exception("Unknown environment (Set " + propertyName + " variable): " + propertyValue);
        }
        return propertyValue;
    }

    public static Double round(double diff) {
        return (double)Math.round(diff * 100.0) / 100.0;
    }

    public static void addAll(List<JsonNode> results, Iterator<JsonNode> elements) {
        while (elements.hasNext()) {
            results.add(elements.next());
        }
    }

    public static String h2Escape(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    public static String[] getValueFromLink(String val) {
        String[] out = new String[2];
        int startIdx = val.indexOf("\"");
        int endIdx = val.indexOf("\" target=\"");
        if (startIdx > -1 && endIdx > -1) {
            String link = val.substring(startIdx + 1, endIdx);
            String value = StringUtils.substringBetween((String)val, (String)">", (String)"<");
            String prefix = StringUtils.substring((String)val, (int)0, (int)val.indexOf("<"));
            out[0] = value = prefix + value;
            out[1] = link;
        } else {
            out[0] = val;
            out[1] = val;
        }
        return out;
    }

    public static int lastIndexOfUCL(String str) {
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            if (!Character.isUpperCase(str.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static String generateExportFileName(String name, String format) {
        String fileName = "AIO Report";
        if (StringUtils.isNotBlank((CharSequence)name)) {
            fileName = name;
        }
        fileName = name.replaceAll("[^A-Za-z0-9]", "_");
        return fileName + "." + format;
    }

    public static String consumerKeyEnvVariableName(String addOnKey) {
        String addOnSuffix = "_" + StringUtils.replace((String)addOnKey, (String)".", (String)"_");
        return "CONSUMER_KEY" + addOnSuffix;
    }

    public static boolean hasEnvProperty(String prop) {
        try {
            Utils.getEnvProperty(prop);
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public static String indexedStyle(String style, int i2) {
        return style + "-" + i2;
    }

    public static boolean isGrid(DTO dto) {
        return dto.isList() || dto.isCrosstab() || dto.isTimesheet() || dto.isTrend() && "table".equals(dto.getTrendOutputFormat());
    }
}

