/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String text(JsonNode json, String attribute) {
        if (json == null || json.isNull() || StringUtils.isBlank((CharSequence)attribute) || !json.has(attribute)) {
            return null;
        }
        return json.get(attribute).asText();
    }

    public static <T> T stringToType(String content, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            return mapper.readValue(content, valueTypeRef);
        }
        return null;
    }

    public static String objectToJsonString(Object obj) throws JsonProcessingException {
        return mapper.writeValueAsString(obj);
    }

    public static <T> T jsonNodeToPojo(JsonNode node, Class<T> clazz) throws JsonProcessingException {
        return mapper.treeToValue(node, clazz);
    }

    public static JsonNode stringToJsonNode(String value) throws JsonParseException, JsonMappingException, IOException {
        return JsonUtils.stringToType(value, new TypeReference<JsonNode>(){});
    }

    public static boolean notJsonNull(JsonNode node) {
        return !JsonUtils.isJsonNull(node);
    }

    public static boolean isJsonNull(JsonNode node) {
        return node == null || node.isNull();
    }

    public static boolean isNotJsonNull(JsonNode node) {
        return !JsonUtils.isJsonNull(node);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

