/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.google.common.io.CharStreams;
import com.kaanha.reports.helper.Utils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.service.ExportService;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HttpUtils {
    static Logger logger = Logger.getLogger(HttpUtils.class);

    public static String postData(HttpServletRequest request) throws IOException {
        return CharStreams.toString((Readable)request.getReader());
    }

    public static String getBaseUrl(HttpServletRequest request) {
        if (request != null) {
            String contextPath;
            String requestURL = request.getRequestURL().toString();
            String requestBaseURL = requestURL.substring(0, requestURL.indexOf("/", 8));
            String originalProtocol = request.getHeader("X-Forwarded-Proto");
            if (StringUtils.isNotBlank((CharSequence)originalProtocol)) {
                requestBaseURL = originalProtocol + requestBaseURL.substring(requestBaseURL.indexOf(":"));
            }
            if (StringUtils.isBlank((CharSequence)(contextPath = request.getContextPath())) || "/".equals(contextPath)) {
                return requestBaseURL;
            }
            return requestBaseURL + contextPath;
        }
        return null;
    }

    public static void exportToResponse(HttpServletResponse response, ExportService exportService, DTO dto, String format) throws IOException, Exception {
        if ("excel".equals(format)) {
            format = "xlsx";
        }
        String exportFileName = Utils.generateExportFileName(dto.getName(), format);
        response.setHeader("Content-Disposition", "inline; filename=" + exportFileName);
        response.setHeader("X-Download-Options", "noopen");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=UTF-8");
        exportService.writeFileToOutputStream((OutputStream)response.getOutputStream(), format);
    }
}

