/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.kaanha.reports.helper.JsonUtils;
import com.kaanha.reports.model.DTO;
import com.kaanha.reports.model.Field;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Fielder {
    public static final String _AVG_HLP = "_AVG_HLP";
    public static final String _PCT_HLP = "_PCT_HLP";

    public static String id(JsonNode json) {
        return JsonUtils.text(json, "id");
    }

    public static String name(JsonNode json) {
        return JsonUtils.text(json, "name");
    }

    public static Field findInFields(String fieldId, Collection<Field> fields) {
        for (Field field : fields) {
            if (!field.getId().equalsIgnoreCase(fieldId)) continue;
            return field;
        }
        return null;
    }

    public static boolean isArray(Field f2) {
        return "array".equals(f2.getJiraType());
    }

    public static boolean isSLA(Field f2) {
        return "sla".equals(f2.getJiraType());
    }

    public static List<Field> idsToFields(List<String> fieldIds, List<Field> schema) {
        ArrayList fields = Lists.newArrayList();
        for (String fieldId : fieldIds) {
            Field field = Fielder.findInFields(fieldId, schema);
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Collection<Field> worklogFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (!Fielder.isWorklogField(f2)) continue;
            out.add(f2);
        }
        return out;
    }

    public static Collection<Field> historyFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (!Fielder.isHistoryField(f2)) continue;
            out.add(f2);
        }
        return out;
    }

    public static Collection<Field> nonWorklogFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (Fielder.isWorklogField(f2)) continue;
            out.add(f2);
        }
        return out;
    }

    public static boolean isWorklogField(Field f2) {
        return "worklog".equals(f2.getId()) || f2.getId() != null && f2.getId().startsWith("worklog_");
    }

    public static boolean isHistoryField(Field f2) {
        return "changelog".equals(f2.getId()) || f2.getId() != null && f2.getId().startsWith("changelog_");
    }

    public static Collection<Field> nonNumericFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (f2.isNumber()) continue;
            out.add(f2);
        }
        return out;
    }

    public static Collection<Field> numericFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (!f2.isNumber()) continue;
            out.add(f2);
        }
        return out;
    }

    public static boolean isNonWorklogField(Field f2) {
        return !Fielder.isWorklogField(f2);
    }

    public static boolean isNonHistoryField(Field f2) {
        return !Fielder.isHistoryField(f2);
    }

    public static boolean isFilterField(Field f2) {
        return StringUtils.isNotBlank((CharSequence)f2.getFilterValue()) && !StringUtils.equals((CharSequence)f2.getFilterValue(), (CharSequence)"{}");
    }

    public static boolean containsField(Set<String> fieldIds, String fieldId) {
        for (String _fieldId : fieldIds) {
            if (!_fieldId.equalsIgnoreCase(fieldId)) continue;
            return true;
        }
        return false;
    }

    public static Field findInFieldsByName(String name, List<Field> fields) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static Collection<Field> nonHistoryFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (Fielder.isHistoryField(f2)) continue;
            out.add(f2);
        }
        return out;
    }

    public static Field findByClauseNames(List<Field> fields, String visibileFieldName) {
        for (Field field : fields) {
            if (field.getClauseNames() == null) continue;
            for (JsonNode clauseName : field.getClauseNames()) {
                if (!visibileFieldName.toLowerCase().equals(clauseName.asText().toLowerCase()) && !visibileFieldName.toLowerCase().equals("\"" + clauseName.asText().toLowerCase() + "\"")) continue;
                return field;
            }
        }
        return null;
    }

    public static boolean isCount(Field f2) {
        return f2.getId().equals("aio_count") || f2.getId().equals("aio_count_percent");
    }

    public static boolean hasAggregateField(Collection<Field> fields) {
        for (Field f2 : fields) {
            if (!f2.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public static String name(Field field) {
        return StringUtils.isBlank((CharSequence)field.getColumnName()) ? field.getId().replaceAll("\\.", "_") : field.getColumnName();
    }

    public static Collection<Field> nonAggregateFields(Collection<Field> fields) {
        ArrayList out = Lists.newArrayList();
        for (Field f2 : fields) {
            if (f2.isAggregate()) continue;
            out.add(f2);
        }
        return out;
    }

    public static void removeHiddenFields(Collection<Field> fields) {
        Iterator<Field> iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field f2 = iterator.next();
            if (!f2.isHidden()) continue;
            iterator.remove();
        }
    }

    public static boolean isPriority(Field f2) {
        return "priority".equalsIgnoreCase(f2.getId());
    }

    public static boolean isPercentCompletion(Field f2) {
        return "progress_percent".equalsIgnoreCase(f2.getId());
    }

    public static Field clone(Field f2) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        return JsonUtils.stringToType(JsonUtils.objectToJsonString(f2), new TypeReference<Field>(){});
    }

    public static void addHelpers(DTO dto) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        ArrayList rowAndDataFields = Lists.newArrayList();
        rowAndDataFields.add(dto.getRow());
        rowAndDataFields.add(dto.getData());
        for (List fields : rowAndDataFields) {
            ArrayList helpers = Lists.newArrayList();
            for (Field f2 : fields) {
                if (f2.isAggregate() && "AVG".equals(f2.getAggregateFunction())) {
                    Field avg_hlp = Fielder.clone(f2);
                    helpers.add(avg_hlp);
                    avg_hlp.setAggregateFunction("SUM");
                    avg_hlp.setId(f2.getId() + _AVG_HLP);
                    avg_hlp.setFilterValue(null);
                }
                if (!f2.isPercent() || Fielder.isCount(f2)) continue;
                Field percentOver = Fielder.findInFields(f2.getPercentOverId(), dto.getQueryFields());
                Field pct_hlp = Fielder.clone(percentOver);
                helpers.add(pct_hlp);
                pct_hlp.setAggregateFunction("SUM");
                pct_hlp.setId(f2.getId() + _PCT_HLP);
                pct_hlp.setFilterValue(null);
            }
            fields.addAll(helpers);
            dto.getHelpers().addAll(helpers);
        }
    }

    public static void removeHelpers(DTO dto) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        ArrayList rowAndDataFields = Lists.newArrayList();
        rowAndDataFields.add(dto.getRow());
        rowAndDataFields.add(dto.getData());
        for (List fields : rowAndDataFields) {
            ArrayList helpers = Lists.newArrayList();
            for (Field f2 : fields) {
                if (StringUtils.endsWith((CharSequence)f2.getId(), (CharSequence)_AVG_HLP)) {
                    helpers.add(f2);
                }
                if (!StringUtils.endsWith((CharSequence)f2.getId(), (CharSequence)_PCT_HLP)) continue;
                helpers.add(f2);
            }
            fields.removeAll(helpers);
        }
    }

    public static String fieldLabel(Field f2) {
        if (StringUtils.isBlank((CharSequence)f2.getLabel())) {
            String name = f2.getName();
            if (StringUtils.isNotBlank((CharSequence)f2.getAggregateFunctionDisplay()) && !StringUtils.equals((CharSequence)f2.getId(), (CharSequence)"aio_count") && !StringUtils.equals((CharSequence)f2.getId(), (CharSequence)"aio_total") && !StringUtils.equals((CharSequence)f2.getId(), (CharSequence)"aio_count_percent")) {
                name = f2.getAggregateFunctionDisplay() + " [" + name + "]";
            }
            return name;
        }
        return f2.getLabel();
    }
}

